/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Vector;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.DOMParser;
import org.globus.ogsa.encoding.ObjectSerializer;
import org.globus.ogsa.types.profiling.Timestamp;
import org.globus.ogsa.types.profiling.TimestampType;
import org.globus.ogsa.utils.MessageUtils;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class TimestampUtils {
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$utils$TimestampUtils == null ? (class$org$globus$ogsa$utils$TimestampUtils = TimestampUtils.class$("org.globus.ogsa.utils.TimestampUtils")) : class$org$globus$ogsa$utils$TimestampUtils).getName());
    public static final String[] HEADERS = new String[]{"Start Time", "Available Memory", "Thread ID", "Message Context Hash", "ServiceURL", "Operation", "Client/Server", "Request/Response", "End Time"};
    static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    static final String XSD_REF = " xmlns=\"http://org.globus.ogsa/timestamp\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://org.globus.ogsa/timestamp ./timestamp.xsd\"";
    static final String START_TAG = "<ns1:timestamp x";
    static final String END_TAG = "</ns1:timestamp>";
    public static final int ORIGIN_TYPE_CLIENT = 0;
    public static final int ORIGIN_TYPE_SERVER = 1;
    public static final int ORIGIN_TYPE_INVALID = -1;
    public static final int MESSAGE_TYPE_REQUEST = 0;
    public static final int MESSAGE_TYPE_RESPONSE = 1;
    public static final int MESSAGE_TYPE_INVALID = -1;
    static /* synthetic */ Class class$org$globus$ogsa$utils$TimestampUtils;

    public static String originTypeToString(int originType) {
        switch (originType) {
            case 0: {
                return "client";
            }
            case 1: {
                return "server";
            }
        }
        return "INVALID ORIGIN TYPE";
    }

    public static int originTypeStringToInt(String originType) {
        if (originType.equals("client")) {
            return 0;
        }
        if (originType.equals("server")) {
            return 1;
        }
        return -1;
    }

    public static String messageTypeToString(int messageType) {
        switch (messageType) {
            case 0: {
                return "request";
            }
            case 1: {
                return "response";
            }
        }
        return "INVALID MESSAGE TYPE";
    }

    public static int messageTypeStringToInt(String messageType) {
        if (messageType.equals("request")) {
            return 0;
        }
        if (messageType.equals("response")) {
            return 1;
        }
        return -1;
    }

    public static void populate(Timestamp timestamp) {
        TimestampUtils.populate(timestamp, null);
    }

    public static void populate(Timestamp timestamp, MessageContext messageContext) {
        timestamp.setStartTime(System.currentTimeMillis());
        timestamp.setThreadID(Thread.currentThread().getName());
        timestamp.setAvailableMemory(Runtime.getRuntime().freeMemory());
        if (messageContext != null) {
            timestamp.setMessageContextHash(String.valueOf(messageContext.hashCode()));
            timestamp.setServiceURL(messageContext.getProperty("transport.url").toString());
            Message message = messageContext.getCurrentMessage();
            SOAPEnvelope soapEnvelope = null;
            SOAPBody soapBody = null;
            try {
                soapEnvelope = message.getSOAPEnvelope();
                soapBody = (SOAPBody)soapEnvelope.getBody();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("SOAPBody: " + soapBody));
                }
            }
            catch (AxisFault af) {
                logger.error((Object)af);
            }
            catch (SOAPException soape) {
                logger.error((Object)MessageUtils.getMessage("noSOAPEnvelope"), (Throwable)soape);
            }
            SOAPElement firstSOAPBodyChildElement = (SOAPElement)soapBody.getChildElements().next();
            Name operationNameInfo = firstSOAPBodyChildElement.getElementName();
            String operationName = operationNameInfo.getLocalName();
            timestamp.setOperation(operationName);
            if (messageContext.isClient()) {
                timestamp.setOriginType(0);
            } else {
                timestamp.setOriginType(1);
            }
            String messageType = message.getMessageType();
            if (messageType == null) {
                messageType = operationName.endsWith("Response") ? "response" : "request";
            }
            timestamp.setMessageType(TimestampUtils.messageTypeStringToInt(messageType));
        }
        timestamp.setEndTime(System.currentTimeMillis());
    }

    public static Timestamp deserialize(String timestampXMLString) {
        DOMParser xmlParser = new DOMParser();
        try {
            xmlParser.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXNotRecognizedException saxnre) {
            logger.error((Object)saxnre);
        }
        catch (SAXNotSupportedException saxnre) {
            logger.error((Object)saxnre);
        }
        BufferedReader xmlReader = new BufferedReader(new StringReader(timestampXMLString));
        try {
            xmlParser.parse(new InputSource(xmlReader));
        }
        catch (SAXException saxe) {
            logger.error((Object)saxe);
        }
        catch (IOException ioe) {
            logger.error((Object)ioe);
        }
        Document timestampDocument = xmlParser.getDocument();
        Element timestampElement = timestampDocument.getDocumentElement();
        NodeList nodeList = null;
        CharacterData cdata = null;
        Timestamp timestamp = new Timestamp();
        nodeList = timestampElement.getElementsByTagNameNS("http://ogsa.globus.org/types/profiling", "startTime");
        cdata = (CharacterData)nodeList.item(0).getFirstChild();
        timestamp.setStartTime(Long.parseLong(cdata.getData()));
        nodeList = timestampElement.getElementsByTagNameNS("http://ogsa.globus.org/types/profiling", "threadID");
        cdata = (CharacterData)nodeList.item(0).getFirstChild();
        timestamp.setThreadID(cdata.getData());
        nodeList = timestampElement.getElementsByTagNameNS("http://ogsa.globus.org/types/profiling", "availableMemory");
        cdata = (CharacterData)nodeList.item(0).getFirstChild();
        timestamp.setAvailableMemory(Long.parseLong(cdata.getData()));
        nodeList = timestampElement.getElementsByTagNameNS("http://ogsa.globus.org/types/profiling", "messageContextHash");
        cdata = (CharacterData)nodeList.item(0).getFirstChild();
        timestamp.setMessageContextHash(cdata.getData());
        nodeList = timestampElement.getElementsByTagNameNS("http://ogsa.globus.org/types/profiling", "serviceURL");
        cdata = (CharacterData)nodeList.item(0).getFirstChild();
        timestamp.setServiceURL(cdata.getData());
        nodeList = timestampElement.getElementsByTagNameNS("http://ogsa.globus.org/types/profiling", "operation");
        cdata = (CharacterData)nodeList.item(0).getFirstChild();
        timestamp.setOperation(cdata.getData());
        nodeList = timestampElement.getElementsByTagNameNS("http://ogsa.globus.org/types/profiling", "originType");
        cdata = (CharacterData)nodeList.item(0).getFirstChild();
        timestamp.setOriginType(Integer.parseInt(cdata.getData()));
        nodeList = timestampElement.getElementsByTagNameNS("http://ogsa.globus.org/types/profiling", "messageType");
        cdata = (CharacterData)nodeList.item(0).getFirstChild();
        timestamp.setMessageType(Integer.parseInt(cdata.getData()));
        nodeList = timestampElement.getElementsByTagNameNS("http://ogsa.globus.org/types/profiling", "endTime");
        cdata = (CharacterData)nodeList.item(0).getFirstChild();
        timestamp.setEndTime(Long.parseLong(cdata.getData()));
        return timestamp;
    }

    public static Vector extractTimestamps(InputStream inputStream) throws IOException {
        Vector<Timestamp> timestamps = new Vector<Timestamp>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        boolean append = false;
        int expectedNumChars = START_TAG.length() - 1;
        char[] testBuffer = new char[expectedNumChars];
        String tagTestString = null;
        StringBuffer timestampBuffer = null;
        int nextChar = reader.read();
        while (nextChar >= 0) {
            if (nextChar == 60) {
                reader.mark(START_TAG.length());
                int numCharsRead = reader.read(testBuffer, 0, expectedNumChars);
                if (numCharsRead == expectedNumChars) {
                    tagTestString = new String(testBuffer);
                    if (START_TAG.substring(1).equals(tagTestString)) {
                        if (!append) {
                            append = true;
                            timestampBuffer = new StringBuffer();
                            timestampBuffer.append((char)nextChar);
                            timestampBuffer.append(tagTestString);
                            nextChar = reader.read();
                            continue;
                        }
                        logger.error((Object)"invalid parse state: start tag found, but already in append mode");
                        reader.reset();
                    } else if (END_TAG.substring(1).equals(tagTestString)) {
                        if (append) {
                            append = false;
                            timestampBuffer.append((char)nextChar);
                            timestampBuffer.append(tagTestString);
                            timestamps.add(TimestampUtils.deserialize(timestampBuffer.toString()));
                            reader.read();
                            continue;
                        }
                        reader.reset();
                    } else {
                        reader.reset();
                    }
                } else {
                    if (numCharsRead == -1) {
                        nextChar = -1;
                        continue;
                    }
                    logger.error((Object)("tried to read " + expectedNumChars + " characters from input stream, but got " + numCharsRead));
                }
            }
            if (append) {
                timestampBuffer.append((char)nextChar);
            }
            nextChar = reader.read();
        }
        return timestamps;
    }

    public static String[] getFieldValues(Timestamp timestamp) {
        return new String[]{String.valueOf(timestamp.getStartTime()), String.valueOf(timestamp.getAvailableMemory()), timestamp.getThreadID(), timestamp.getMessageContextHash(), timestamp.getServiceURL(), timestamp.getOperation(), TimestampUtils.originTypeToString(timestamp.getOriginType()), TimestampUtils.messageTypeToString(timestamp.getMessageType()), String.valueOf(timestamp.getEndTime())};
    }

    public static String toCSV(Timestamp timestamp) {
        return TimestampUtils.toCSV(timestamp, false);
    }

    public static String toCSV(Timestamp timestamp, boolean withHeaders) {
        StringBuffer csvBuffer = new StringBuffer();
        if (withHeaders) {
            int index = 0;
            while (index < HEADERS.length) {
                csvBuffer.append(HEADERS[index]);
                if (index < HEADERS.length - 1) {
                    csvBuffer.append(',');
                }
                ++index;
            }
            csvBuffer.append('\n');
        }
        String[] fieldValues = TimestampUtils.getFieldValues(timestamp);
        int fieldCount = fieldValues.length;
        int index = 0;
        while (index < fieldCount) {
            csvBuffer.append(fieldValues[index]);
            if (index < fieldCount - 1) {
                csvBuffer.append(',');
            }
            ++index;
        }
        return csvBuffer.toString();
    }

    public static String toString(Timestamp timestamp) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] fieldValues = TimestampUtils.getFieldValues(timestamp);
        int fieldCount = fieldValues.length;
        int index = 0;
        while (index < fieldCount) {
            stringBuffer.append(HEADERS[index]);
            stringBuffer.append(": ");
            stringBuffer.append(fieldValues[index]);
            if (index < fieldCount - 1) {
                stringBuffer.append("\n");
            }
            ++index;
        }
        return stringBuffer.toString();
    }

    public static Element toElement(Timestamp timestamp) throws Exception {
        TimestampType timestampType = new TimestampType();
        timestampType.setTimestamp(timestamp);
        return ObjectSerializer.toElement(timestampType);
    }

    public static String serialize(Timestamp timestamp) {
        String timestampString = null;
        try {
            TimestampType timestampType = new TimestampType();
            timestampType.setTimestamp(timestamp);
            timestampString = ObjectSerializer.toString(timestampType);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return timestampString;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

