/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid;

import java.io.RandomAccessFile;
import org.apache.axis.types.URI;
import org.ecoinformatics.ecogrid.EcoGridFTPClient;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.FTPClient;
import org.globus.ftp.FileRandomIO;
import org.globus.ftp.MarkerListener;
import org.ietf.jgss.GSSCredential;

public class EcoGridFTPTransfer {
    private int transferType = -1;
    private String sourceScheme = null;
    private String sourceHost = null;
    private int sourcePort = -1;
    private String sourceFilePath = null;
    private String destinationScheme = null;
    private String destinationHost = null;
    private int destinationPort = -1;
    private String destinationFilePath = null;
    private GSSCredential cred = null;
    private static final int FAIL = 0;
    private static final int SUCCESS = 1;

    public EcoGridFTPTransfer(URI sourceURI, URI destURI, GSSCredential credt) throws Exception {
        if (sourceURI == null || destURI == null) {
            // empty if block
        }
        this.cred = credt;
        this.sourceScheme = sourceURI.getScheme();
        System.out.println("source scheme in sourceURI is " + this.sourceScheme);
        this.sourceHost = sourceURI.getHost();
        System.out.println("source host in sourceURI is " + this.sourceHost);
        this.sourcePort = sourceURI.getPort();
        System.out.println("source port in sourceURI is " + this.sourcePort);
        this.sourceFilePath = sourceURI.getPath();
        System.out.println("source file path in sourceURI is " + this.sourceFilePath);
        this.destinationScheme = destURI.getScheme();
        System.out.println("destination scheme in destinationURI is " + this.destinationScheme);
        this.destinationHost = destURI.getHost();
        System.out.println("destination host in destinationURI is " + this.destinationHost);
        this.destinationPort = destURI.getPort();
        System.out.println("destination port in destinationURI is " + this.destinationPort);
        this.destinationFilePath = destURI.getPath();
        System.out.println("destination path in destinationURI is " + this.destinationFilePath);
        this.checkTransferType();
    }

    public int getTransferType() {
        return this.transferType;
    }

    private int checkTransferType() throws Exception {
        if (this.sourceScheme == null || this.destinationScheme == null) {
            throw new Exception("Should specify scheme in source or destionation URI in get method");
        }
        if (this.sourceScheme.equals("file") && this.destinationScheme.equals("gsiftp")) {
            this.transferType = 1;
            System.out.println("it is client to server type");
        } else if (this.sourceScheme.equals("gsiftp") && this.destinationScheme.equals("file")) {
            this.transferType = 2;
            System.out.println("it is server to client type");
        } else if (this.sourceScheme.equals("gsiftp") && this.destinationScheme.equals("gsiftp")) {
            this.transferType = 3;
            System.out.println("it is third party type");
        } else {
            System.out.println("unkonw type");
            throw new Exception("Unsupport scheme for transfer: " + this.sourceScheme + " or " + this.destinationScheme);
        }
        return this.transferType;
    }

    public int transfer() throws Exception {
        System.out.println("the transferType is " + this.transferType);
        int flag = 0;
        if (this.transferType == 1) {
            System.out.println("in client to server transfer");
            flag = this.transferFromClientToServer();
        } else if (this.transferType == 2) {
            System.out.println("in server to client transfer");
            flag = this.transferFromServerToClient();
        } else if (this.transferType == 3) {
            System.out.println("in third party tansfer");
            flag = this.thridPartyTransfer();
        } else {
            System.out.println("in unkown tansfer");
            throw new Exception("Unkown transfer");
        }
        return flag;
    }

    private int transferFromClientToServer() {
        int flag = 0;
        if (this.transferType == 1) {
            System.out.println(" start tansfer from client to server");
            try {
                System.out.println("before instantial ftp client");
                EcoGridFTPClient client = new EcoGridFTPClient(this.destinationHost, this.destinationPort, this.cred);
                System.out.println("after instantial ftp client");
                FileRandomIO datasource = null;
                System.out.println("before instantial data source");
                datasource = new FileRandomIO(new RandomAccessFile(this.sourceFilePath, "rw"));
                System.out.println("after instantial data source");
                System.out.println("before extendput");
                client.extendedPut(this.destinationFilePath, (DataSource)datasource, null);
                System.out.println("after extendput");
                System.out.println("before close");
                client.close();
                System.out.println("after close");
                flag = 1;
            }
            catch (Exception e) {
                System.out.println("Error: " + e.getMessage());
            }
        }
        return flag;
    }

    private int transferFromServerToClient() {
        int flag = 0;
        if (this.transferType == 2) {
            System.out.println("start sever to client transfer...");
            try {
                System.out.println("start ftp object");
                System.out.println("hostname is " + this.sourceHost);
                System.out.println("portNumber is " + this.sourcePort);
                EcoGridFTPClient client = new EcoGridFTPClient(this.sourceHost, this.sourcePort, this.cred);
                System.out.println("after create client object");
                long size = client.getSize(this.sourceFilePath);
                System.out.println("the size of remote file is " + size);
                FileRandomIO sink = null;
                sink = new FileRandomIO(new RandomAccessFile(this.destinationFilePath, "rw"));
                client.setLocalPassive();
                client.setActive();
                System.out.println("start extentedGet...");
                client.extendedGet(this.sourceFilePath, size, (DataSink)sink, null);
                System.out.println("after extenedGet...");
                client.close();
                System.out.println("close the transfer...");
                flag = 1;
            }
            catch (Exception e) {
                System.out.println("Error: " + e.getMessage());
            }
        }
        return flag;
    }

    private int thridPartyTransfer() {
        int flag = 0;
        if (this.transferType == 3) {
            try {
                EcoGridFTPClient sClient = new EcoGridFTPClient(this.sourceHost, this.sourcePort, this.cred);
                EcoGridFTPClient dClient = new EcoGridFTPClient(this.destinationHost, this.destinationPort, this.cred);
                boolean append = false;
                MarkerListener mListener = null;
                System.out.println("before transfer ....");
                System.out.println("source file path is " + this.sourceFilePath);
                System.out.println("destination file path is " + this.destinationFilePath);
                sClient.transfer(this.sourceFilePath, (FTPClient)dClient, this.destinationFilePath, append, mListener);
                System.out.println("after transfer ....");
                flag = 1;
            }
            catch (Exception e) {
                System.out.println("Error: " + e.getMessage());
            }
        }
        return flag;
    }
}

