/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid;

import java.io.StringReader;
import org.ecoinformatics.ecogrid.ANDType;
import org.ecoinformatics.ecogrid.ConditionType;
import org.ecoinformatics.ecogrid.EcogridQueryParser;
import org.ecoinformatics.ecogrid.EcogridUtils;
import org.ecoinformatics.ecogrid.LimitedXPathExpression;
import org.ecoinformatics.ecogrid.ORType;
import org.ecoinformatics.ecogrid.OperatorType;
import org.ecoinformatics.ecogrid.QueryType;
import org.ecoinformatics.ecogrid.QueryType_namespace;

public class EcogridQueryTransformer {
    private static boolean mIdent = true;

    public static void setIndent(boolean aIdent) {
        mIdent = aIdent;
    }

    private static String getLeadingSpace(int aDepth) {
        if (!mIdent) {
            return "";
        }
        StringBuffer spaces = new StringBuffer();
        for (int i = 0; i < aDepth; ++i) {
            spaces.append("  ");
        }
        return spaces.toString();
    }

    private static void process(StringBuffer aStrBuf, ANDType[] aAnds, ORType[] aOrs, ConditionType[] aConds, int aDepth) {
        int i;
        if (aAnds != null) {
            for (i = 0; i < aAnds.length; ++i) {
                EcogridQueryTransformer.processAND(aStrBuf, aAnds[i], aDepth + 1);
            }
        }
        if (aOrs != null) {
            for (i = 0; i < aOrs.length; ++i) {
                EcogridQueryTransformer.processOR(aStrBuf, aOrs[i], aDepth + 1);
            }
        }
        if (aConds != null) {
            for (i = 0; i < aConds.length; ++i) {
                EcogridQueryTransformer.processCond(aStrBuf, aConds[i], aDepth + 1);
            }
        }
    }

    private static void processAND(StringBuffer aStrBuf, ANDType aAnd, int aDepth) {
        if (aAnd == null) {
            return;
        }
        aStrBuf.append(EcogridQueryTransformer.getLeadingSpace(aDepth));
        aStrBuf.append("<AND>\n");
        EcogridQueryTransformer.process(aStrBuf, aAnd.getAND(), aAnd.getOR(), aAnd.getCondition(), aDepth);
        aStrBuf.append(EcogridQueryTransformer.getLeadingSpace(aDepth));
        aStrBuf.append("</AND>\n");
    }

    private static void processOR(StringBuffer aStrBuf, ORType aOR, int aDepth) {
        if (aOR == null) {
            return;
        }
        aStrBuf.append(EcogridQueryTransformer.getLeadingSpace(aDepth));
        aStrBuf.append("<OR>\n");
        EcogridQueryTransformer.process(aStrBuf, aOR.getAND(), aOR.getOR(), aOR.getCondition(), aDepth);
        aStrBuf.append(EcogridQueryTransformer.getLeadingSpace(aDepth));
        aStrBuf.append("</OR>\n");
    }

    private static void processCond(StringBuffer aStrBuf, ConditionType aCond, int aDepth) {
        LimitedXPathExpression concept;
        if (aCond == null) {
            return;
        }
        aStrBuf.append(EcogridQueryTransformer.getLeadingSpace(aDepth));
        aStrBuf.append("<condition");
        OperatorType oper = aCond.getOperator();
        if (oper != null) {
            aStrBuf.append(" operator=\"" + oper.getValue() + "\"");
        }
        if ((concept = aCond.getConcept()) != null) {
            aStrBuf.append(" concept=\"" + concept.getValue() + "\"");
        }
        aStrBuf.append(">" + aCond.getValue() + "</condition>\n");
    }

    public static String toXMLString(QueryType aQuery) {
        String[] titles;
        String[] returnfields;
        StringBuffer strBuf = new StringBuffer("<query");
        if (aQuery.getQueryId() != null) {
            strBuf.append(" queryId=\"" + aQuery.getQueryId() + "\"");
        }
        if (aQuery.getSystem() != null) {
            strBuf.append(" system=\"" + aQuery.getSystem().toString() + "\"");
        }
        strBuf.append(">\n");
        QueryType_namespace[] namespaces = aQuery.getNamespace();
        if (namespaces != null) {
            for (int i = 0; i < namespaces.length; ++i) {
                if (namespaces[i].getValue() == null) continue;
                strBuf.append("  <namespace");
                if (namespaces[i].getPrefix() != null) {
                    strBuf.append(" prefix=\"" + namespaces[i].getPrefix() + "\"");
                }
                strBuf.append(">" + namespaces[i].getValue().toString() + "</namespace>\n");
            }
        }
        if ((returnfields = aQuery.getReturnfield()) != null) {
            for (int i = 0; i < returnfields.length; ++i) {
                strBuf.append("  <returnField>" + returnfields[i] + "</returnField>\n");
            }
        }
        if ((titles = aQuery.getTitle()) != null) {
            for (int i = 0; i < titles.length; ++i) {
                strBuf.append("  <title>" + titles[i] + "</title>\n");
            }
        }
        EcogridQueryTransformer.processAND(strBuf, aQuery.getAND(), 1);
        EcogridQueryTransformer.processOR(strBuf, aQuery.getOR(), 1);
        EcogridQueryTransformer.processCond(strBuf, aQuery.getCondition(), 1);
        strBuf.append("</query>");
        return strBuf.toString();
    }

    public static void test(String aFileName) {
        QueryType query = null;
        String domStr = EcogridUtils.readXMLFile2Str(aFileName);
        StringReader strReader = new StringReader(domStr);
        try {
            EcogridQueryParser parser = new EcogridQueryParser(strReader);
            parser.parseXML();
            query = parser.getEcogridQuery();
            System.out.println("File contains:");
            System.out.println(domStr);
            System.out.println("Query XML:");
            System.out.println(EcogridQueryTransformer.toXMLString(query));
            System.out.println("\n");
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        EcogridQueryTransformer.test("/home/globus/workspace/kepler/query.xml");
        EcogridQueryTransformer.test("/home/globus/seek/projects/ecogrid/tests/testfiles/query-digir.xml");
        EcogridQueryTransformer.test("/home/globus/seek/projects/ecogrid/tests/testfiles/query-test.xml");
    }
}

