/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.StringReader;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import org.ecoinformatics.ecogrid.EcogridQueryParser;
import org.ecoinformatics.ecogrid.QueryType;
import org.ecoinformatics.ecogrid.ResultsetType_record_returnField;
import org.ecoinformatics.ecogrid.ResultsetType_resultsetMetadata;
import org.ecoinformatics.ecogrid.ResultsetType_resultsetMetadata_namespace;
import org.ecoinformatics.ecogrid.ResultsetType_resultsetMetadata_recordStructure;
import org.ecoinformatics.ecogrid.ResultsetType_resultsetMetadata_recordStructure_returnField;
import org.ecoinformatics.ecogrid.ResultsetType_resultsetMetadata_system;
import org.globus.ogsa.config.ContainerConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class EcogridUtils {
    private static boolean _printAll = false;
    private static boolean _debugOn = false;
    private static int _level = 100;

    public static void setDebug(boolean aOn) {
        _debugOn = aOn;
    }

    public static void setLevel(int aLevel) {
        _level = aLevel;
    }

    public static boolean isDebugOn() {
        return _debugOn;
    }

    public static void debugMessage(String aMsg, int aLevel) {
        if (_debugOn) {
            if (aLevel < 0) {
                aLevel = 0;
            }
            if (aLevel <= _level) {
                System.err.println("EcogridUtils: " + aMsg);
            }
        }
    }

    public static void debugMessage(String aMsg) {
        EcogridUtils.debugMessage(aMsg, 1);
    }

    public static void setPrintAll(boolean aPrintAll) {
        _printAll = aPrintAll;
    }

    public static String getNodeTypeStr(int aType) {
        String str = "N/A";
        switch (aType) {
            case 2: {
                str = "The node is an Attr.";
                break;
            }
            case 4: {
                str = "The node is a CDATASection.";
                break;
            }
            case 8: {
                str = "The node is a Comment.";
                break;
            }
            case 11: {
                str = "The node is a DocumentFragment.";
                break;
            }
            case 9: {
                str = "The node is a Document.";
                break;
            }
            case 10: {
                str = "The node is a DocumentType.";
                break;
            }
            case 1: {
                str = "The node is an Element.";
                break;
            }
            case 6: {
                str = "The node is an Entity.";
                break;
            }
            case 5: {
                str = "The node is an EntityReference.";
                break;
            }
            case 12: {
                str = "The node is a Notation.";
                break;
            }
            case 7: {
                str = "The node is a ProcessingInstruction.";
                break;
            }
            case 3: {
                str = "The node is a Text node.";
            }
        }
        return str;
    }

    public static String getNodeValue(Node aNode) {
        String value = null;
        if (aNode.getNodeValue() != null) {
            value = aNode.getNodeValue() != null ? aNode.getNodeValue().trim() : null;
        } else {
            Node child;
            NodeList list = aNode.getChildNodes();
            if (list.getLength() == 1 && (child = list.item(0)) != null) {
                value = child.getNodeValue() != null ? child.getNodeValue().trim() : null;
            }
        }
        return value;
    }

    public static Node findNode(Node aNode, String aName) {
        String name;
        String string = name = aNode.getNodeName() != null ? aNode.getNodeName().trim() : "";
        if (aName.equalsIgnoreCase(name)) {
            return aNode;
        }
        NodeList list = aNode.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node;
                Node child = list.item(i);
                if (child == null || (node = EcogridUtils.findNode(child, aName)) == null) continue;
                return node;
            }
        }
        return null;
    }

    protected static Node findNodeWithXPath(Node aNode, Vector aNodeNames, int aDepth) {
        if (aDepth == aNodeNames.size()) {
            return null;
        }
        String pathNodeName = (String)aNodeNames.elementAt(aDepth);
        NodeList list = aNode.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                String nodeName;
                Node child = list.item(i);
                if (child == null || !pathNodeName.equals(nodeName = child.getNodeName())) continue;
                if (aDepth == aNodeNames.size() - 1) {
                    return child;
                }
                Node node = EcogridUtils.findNodeWithXPath(child, aNodeNames, aDepth + 1);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    public static Node findNodeWithXPath(Node aRootNode, String aXPath) {
        Vector<String> nodeNames = new Vector<String>();
        StringTokenizer st = new StringTokenizer(aXPath, "/");
        while (st.hasMoreTokens()) {
            nodeNames.addElement(st.nextToken());
        }
        int depth = 0;
        return EcogridUtils.findNodeWithXPath(aRootNode, nodeNames, depth);
    }

    public static String findNodeValue(Node aNode, String aName) {
        String value = null;
        Node node = EcogridUtils.findNode(aNode, aName);
        if (node != null) {
            value = EcogridUtils.getNodeValue(node);
        }
        return value;
    }

    public static String findAttrValueForNode(Node aNode, String aName, String aAttr) {
        Node attrNode;
        NamedNodeMap map;
        String value = null;
        Node node = EcogridUtils.findNode(aNode, aName);
        if (node != null && (map = node.getAttributes()) != null && (attrNode = map.getNamedItem(aAttr)) != null) {
            value = EcogridUtils.getNodeValue(attrNode);
        }
        return value;
    }

    public static String findAttrValue(Node aNode, String aAttr) {
        Node attrNode;
        NamedNodeMap map;
        String value = null;
        if (aNode != null && (map = aNode.getAttributes()) != null && (attrNode = map.getNamedItem(aAttr)) != null) {
            value = EcogridUtils.getNodeValue(attrNode);
        }
        return value;
    }

    public static void printNode(Node aNode, int aLevel) {
        if (aNode == null) {
            return;
        }
        String spaces = "";
        for (int i = 0; i < aLevel; ++i) {
            spaces = spaces + "..";
        }
        System.out.println(spaces + "Name:  " + aNode.getNodeName());
        System.out.println(spaces + "Type:  " + aNode.getNodeType());
        System.out.println(spaces + "Value: [" + aNode.getNodeValue() + "]");
        NodeList list = aNode.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node child = list.item(i);
                EcogridUtils.printNode(child, aLevel + 1);
            }
        }
    }

    public static String readXMLFile2Str(String aFileName) {
        try {
            String buffer = "";
            FileReader fileReader = new FileReader(aFileName);
            BufferedReader bufReader = new BufferedReader(fileReader);
            String line = bufReader.readLine();
            while (line != null) {
                buffer = buffer + line + "\n";
                line = bufReader.readLine();
            }
            return buffer;
        }
        catch (Exception e) {
            System.err.println("readXMLFile2Str - Exception: " + e);
            return null;
        }
    }

    public static Document readXMLFile2DOM(String aFileName) {
        if (aFileName == null) {
            System.err.println("*** EcogridUtils readXMLFile2DOM file name is null!");
            return null;
        }
        if (aFileName.length() == 0) {
            System.err.println("*** EcogridUtils readXMLFile2DOM file name is null!");
            return null;
        }
        File file = new File(aFileName);
        if (file == null || !file.exists() || file.length() == 0L) {
            System.err.println("*** EcogridUtils readXMLFile2DOM - file " + aFileName + " does not exist or is zero length!");
            return null;
        }
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            if (tFactory.getFeature("http://javax.xml.transform.dom.DOMSource/feature") && tFactory.getFeature("http://javax.xml.transform.dom.DOMResult/feature")) {
                DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                dFactory.setNamespaceAware(true);
                DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
                Document xmlDoc = dBuilder.parse(aFileName);
                return xmlDoc;
            }
        }
        catch (SAXParseException e) {
            System.err.println("Tried Reading[" + aFileName + "]");
            System.err.println("readXMLFile2DOM - Exception: " + e);
        }
        catch (Exception e) {
            System.err.println("Tried Reading[" + aFileName + "]");
            System.err.println("readXMLFile2DOM - Exception: " + e);
        }
        return null;
    }

    public static Document convertXMLStr2DOM(String aXMLStr) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            if (tFactory.getFeature("http://javax.xml.transform.dom.DOMSource/feature") && tFactory.getFeature("http://javax.xml.transform.dom.DOMResult/feature")) {
                DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                dFactory.setNamespaceAware(true);
                DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
                StringReader strReader = new StringReader(aXMLStr);
                InputSource inpSrc = new InputSource(strReader);
                Document xmlDoc = dBuilder.parse(inpSrc);
                return xmlDoc;
            }
        }
        catch (Exception e) {
            System.err.println("convertXMLStr2DOM - Exception: " + e);
            System.err.println("XML Dump");
            System.err.println("------------------------------------------");
            System.err.println(aXMLStr);
            System.err.println("------------------------------------------");
            e.printStackTrace();
        }
        return null;
    }

    public static boolean writeXMLToFile(String aFileName, Document aDOM) {
        return false;
    }

    public static boolean compareDOMs(Node aNode1, Node aNode2, int aLevel, boolean aPrintAll) {
        int i;
        String uri2;
        String name2;
        String spaces = "";
        if (aPrintAll) {
            for (int i2 = 0; i2 < aLevel; ++i2) {
                spaces = spaces + "..";
            }
        }
        boolean isOK = true;
        NodeList list1 = aNode1.getChildNodes();
        NodeList list2 = aNode2.getChildNodes();
        String name1 = aNode1.getNodeName() != null ? aNode1.getNodeName().trim() : "";
        String string = name2 = aNode2.getNodeName() != null ? aNode2.getNodeName().trim() : "";
        if (!name1.equalsIgnoreCase(name2)) {
            System.out.println(spaces + "NodeName not equal [" + name1 + "][" + name2 + "]");
            isOK = false;
        } else if (aPrintAll) {
            System.out.println(spaces + "NodeName:  " + name1);
        }
        if (aNode1.getNodeType() != aNode2.getNodeType()) {
            System.out.println(spaces + "NodeType not equal [" + EcogridUtils.getNodeTypeStr(aNode1.getNodeType()) + "][" + EcogridUtils.getNodeTypeStr(aNode2.getNodeType()) + "]");
            isOK = false;
        } else if (aPrintAll) {
            System.out.println(spaces + "NodeType:  " + EcogridUtils.getNodeTypeStr(aNode1.getNodeType()));
        }
        String value1 = aNode1.getNodeValue() != null ? aNode1.getNodeValue().trim() : "";
        String value2 = aNode2.getNodeValue() != null ? aNode2.getNodeValue().trim() : "";
        String skip = "--skip--";
        if (!(value1.equalsIgnoreCase(value2) || value1.equalsIgnoreCase(skip) || value2.equalsIgnoreCase(skip))) {
            System.out.println(spaces + "NodeValue not equal [" + value1 + "][" + value2 + "]");
            isOK = false;
        } else if (aPrintAll) {
            System.out.println(spaces + "NodeValue:  " + value1);
        }
        String uri1 = aNode1.getNamespaceURI() != null ? aNode1.getNamespaceURI().trim() : "";
        String string2 = uri2 = aNode2.getNamespaceURI() != null ? aNode2.getNamespaceURI().trim() : "";
        if (!uri1.equalsIgnoreCase(uri2)) {
            System.out.println(spaces + "NamespaceURI not equal [" + uri1 + "][" + uri2 + "]");
            isOK = false;
        } else if (aPrintAll) {
            System.out.println(spaces + "NamespaceURI:  " + uri1);
        }
        if (list1.getLength() != list2.getLength()) {
            String value;
            Node child;
            System.out.println(spaces + "Num Children not equal [" + list1.getLength() + "][" + list2.getLength() + "]");
            System.out.println(spaces + "-----------------------------");
            System.out.println(spaces + "Node1:");
            for (i = 0; i < list1.getLength(); ++i) {
                child = list1.item(i);
                value = child.getNodeValue() != null ? child.getNodeValue().trim() : "";
                System.out.println(spaces + "..");
                System.out.println(spaces + "..Name:  " + child.getNodeName());
                System.out.println(spaces + "..Type:  " + child.getNodeType());
                System.out.println(spaces + "..Value: [" + value + "]");
            }
            System.out.println(spaces + "-----------------------------");
            System.out.println(spaces + "Node2:");
            for (i = 0; i < list2.getLength(); ++i) {
                child = list2.item(i);
                value = child.getNodeValue() != null ? child.getNodeValue().trim() : "";
                System.out.println(spaces + "..");
                System.out.println(spaces + "..Name:  " + child.getNodeName());
                System.out.println(spaces + "..Type:  " + child.getNodeType());
                System.out.println(spaces + "..Value: [" + value + "]");
            }
            System.out.println(spaces + "-----------------------------");
            isOK = false;
        } else if (aPrintAll) {
            System.out.println(spaces + "Num Children: " + list1.getLength());
        }
        if (!isOK) {
            return false;
        }
        for (i = 0; i < list1.getLength(); ++i) {
            Node child2;
            Node child1 = list1.item(i);
            if (EcogridUtils.compareDOMs(child1, child2 = list2.item(i), aLevel + 1, _printAll)) continue;
            return false;
        }
        return true;
    }

    public static boolean compareDOMs(String aDOM1Filename, String aDOM2Filename) {
        Document dom1 = EcogridUtils.readXMLFile2DOM(aDOM1Filename);
        if (dom1 == null) {
            System.out.println("Error - Couldn't find xml file: " + aDOM1Filename);
            return false;
        }
        Document dom2 = EcogridUtils.readXMLFile2DOM(aDOM2Filename);
        if (dom2 == null) {
            System.out.println("Error - Couldn't find xml file: " + aDOM2Filename);
            return false;
        }
        return EcogridUtils.compareDOMs(dom1, dom2, 0, _printAll);
    }

    public static QueryType readEcogridXMLQuery(String aFileName) {
        QueryType query = null;
        try {
            File queryXMLFile = new File(aFileName);
            if (queryXMLFile != null) {
                FileReader xmlReader = new FileReader(queryXMLFile);
                if (xmlReader != null) {
                    EcogridQueryParser parser = new EcogridQueryParser(xmlReader);
                    if (parser != null) {
                        parser.parseXML();
                        query = parser.getEcogridQuery();
                    } else {
                        System.err.println("EcogridQueryParser was null.");
                    }
                } else {
                    System.err.println("Couldn't create xmlReader.");
                }
            } else {
                System.err.println("Couldn't open file[" + aFileName + "]");
            }
        }
        catch (Exception e) {
            System.err.println("readEcogridXMLQuery exception: " + e);
            e.printStackTrace();
        }
        return query;
    }

    public static final String escapeHTML(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static ResultsetType_resultsetMetadata_system createSystem(String aURIStr, String aId) {
        ResultsetType_resultsetMetadata_system system = new ResultsetType_resultsetMetadata_system(aURIStr);
        system.setId(aId);
        return system;
    }

    public static ResultsetType_resultsetMetadata_namespace createNameSpace(String aVal, String aPrefix) {
        ResultsetType_resultsetMetadata_namespace namespace = new ResultsetType_resultsetMetadata_namespace(aVal);
        namespace.setPrefix(aPrefix);
        return namespace;
    }

    public static ResultsetType_resultsetMetadata_recordStructure_returnField createRecordStructReturnField(String aId, String aPathNS, String aName) {
        ResultsetType_resultsetMetadata_recordStructure_returnField returnField = new ResultsetType_resultsetMetadata_recordStructure_returnField();
        returnField.setId(aId);
        returnField.setPathns(aPathNS);
        returnField.setName(aName);
        return returnField;
    }

    public static ResultsetType_resultsetMetadata_recordStructure createRecordStruct(String aNameSpace) {
        ResultsetType_resultsetMetadata_recordStructure recStruct = new ResultsetType_resultsetMetadata_recordStructure();
        recStruct.setNamespace(aNameSpace);
        return recStruct;
    }

    public static ResultsetType_resultsetMetadata createMetadata(Calendar aSendTime, long aStartRecord, long aEndRecord, long aRecordCount) {
        ResultsetType_resultsetMetadata metadata = new ResultsetType_resultsetMetadata();
        metadata.setSendTime(aSendTime);
        metadata.setStartRecord(aStartRecord);
        metadata.setEndRecord(aEndRecord);
        metadata.setRecordCount(aRecordCount);
        return metadata;
    }

    public static ResultsetType_record_returnField createRecordReturnField(String aId, String aName, String aContent) {
        ResultsetType_record_returnField returnField = new ResultsetType_record_returnField();
        returnField.setId(aId);
        returnField.setName(aName);
        returnField.setContent(aContent);
        return returnField;
    }

    /*
     * WARNING - void declaration
     */
    public static Document OpenEcogridConfigFile(String dataSystem) {
        void var2_3;
        String configFileName;
        String ogsaConfigPath;
        if (dataSystem == null || dataSystem.length() == 0) {
            return null;
        }
        try {
            ogsaConfigPath = ContainerConfig.getConfig().getConfigPath();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return null;
        }
        if (ogsaConfigPath == null || ogsaConfigPath.length() == 0) {
            System.err.println("ContainerConfig.getConfig().getConfigPath() gets null/empty string back.");
            return null;
        }
        if (dataSystem.compareToIgnoreCase("srb") == 0) {
            configFileName = ogsaConfigPath + "/etc/SrbConfig.xml";
        } else if (dataSystem.compareToIgnoreCase("metacat") == 0) {
            configFileName = ogsaConfigPath + "/etc/MetacatConfig.xml";
        } else {
            return null;
        }
        Document doc = EcogridUtils.readXMLFile2DOM((String)var2_3);
        if (doc == null) {
            System.err.println("readXMLFile2DOM returns null for " + (String)var2_3);
        }
        return doc;
    }

    public static String getEcogridConfigValue(Document doc, String configName) {
        Node tNode;
        Element rootElement = doc.getDocumentElement();
        String tmpValue = null;
        NodeList tNodeList = rootElement.getElementsByTagName(configName);
        if (tNodeList != null && (tNode = tNodeList.item(0)) != null) {
            tmpValue = EcogridUtils.getNodeValue(tNode);
        }
        return tmpValue;
    }

    public static Calendar getCalendarDate(String aDateStr) {
        Calendar sendDate = Calendar.getInstance();
        if (aDateStr != null && aDateStr.length() > 18) {
            try {
                int dy;
                int mn;
                int yr;
                if (aDateStr.charAt(2) == '-') {
                    yr = Integer.valueOf(aDateStr.substring(6, 10));
                    mn = Integer.valueOf(aDateStr.substring(3, 5));
                    dy = Integer.valueOf(aDateStr.substring(0, 2));
                } else {
                    yr = Integer.valueOf(aDateStr.substring(0, 4));
                    mn = Integer.valueOf(aDateStr.substring(5, 7));
                    dy = Integer.valueOf(aDateStr.substring(8, 10));
                }
                int hr = Integer.valueOf(aDateStr.substring(11, 13));
                int min = Integer.valueOf(aDateStr.substring(14, 16));
                int sec = Integer.valueOf(aDateStr.substring(17, 19));
                sendDate.set(yr, mn - 1, dy, hr, min, sec);
                EcogridUtils.debugMessage("********* " + yr + "/" + mn + "/" + dy + " " + hr + ":" + min + ":" + sec);
            }
            catch (Exception e) {
                sendDate.setTime(new Date());
            }
        } else {
            sendDate.setTime(new Date());
        }
        return sendDate;
    }

    public static void parseForNameAndNamespace(String aStr, StringBuffer aNodeName, StringBuffer aNameSpace) {
        aNodeName.setLength(0);
        aNameSpace.setLength(0);
        if (aStr != null) {
            int inx = aStr.indexOf(58);
            if (inx != -1) {
                aNodeName.append(aStr.substring(inx + 1, aStr.length()));
                aNameSpace.append(aStr.substring(0, inx));
            } else {
                aNodeName.append(aStr);
            }
        }
    }

    public static boolean isaFcatoryServiceByEnv() {
        String str = System.getProperty("FACTORY");
        if (str == null) {
            return true;
        }
        return str.compareToIgnoreCase("no") != 0;
    }

    public static boolean printStackTraceByEnv() {
        String str = System.getProperty("PRINT_STACK_TRACE");
        if (str == null) {
            return false;
        }
        return str.compareToIgnoreCase("yes") == 0;
    }
}

