/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.JCEUtil;
import javax.crypto.MacSpi;
import javax.crypto.ShortBufferException;

public class Mac
implements Cloneable {
    MacSpi macSpi;
    Provider provider;
    String algorithm;
    private boolean initialised = false;

    protected Mac(MacSpi macSpi, Provider provider, String string) {
        this.macSpi = macSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final Mac getInstance(String string) throws NoSuchAlgorithmException {
        try {
            JCEUtil.Implementation implementation = JCEUtil.getImplementation("Mac", string, null);
            if (implementation == null) {
                throw new NoSuchAlgorithmException(string + " not found");
            }
            Mac mac = new Mac((MacSpi)implementation.getEngine(), implementation.getProvider(), string);
            return mac;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
    }

    public static final Mac getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new IllegalArgumentException("No provider specified to Mac.getInstance()");
        }
        JCEUtil.Implementation implementation = JCEUtil.getImplementation("Mac", string, string2);
        if (implementation == null) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
        Mac mac = new Mac((MacSpi)implementation.getEngine(), implementation.getProvider(), string);
        return mac;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final int getMacLength() {
        return this.macSpi.engineGetMacLength();
    }

    public final void init(Key key) throws InvalidKeyException {
        try {
            this.macSpi.engineInit(key, null);
            this.initialised = true;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException("underlying mac waon't work without an AlgorithmParameterSpec");
        }
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.macSpi.engineInit(key, algorithmParameterSpec);
        this.initialised = true;
    }

    public final void update(byte by) throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("MAC not initialised");
        }
        this.macSpi.engineUpdate(by);
    }

    public final void update(byte[] byArray) throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("MAC not initialised");
        }
        if (byArray == null) {
            return;
        }
        this.macSpi.engineUpdate(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n, int n2) throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("MAC not initialised");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Null input passed");
        }
        if (n2 < 0 || n < 0 || n2 > byArray.length - n) {
            throw new IllegalArgumentException("Bad offset/len");
        }
        if (byArray.length == 0) {
            return;
        }
        this.macSpi.engineUpdate(byArray, n, n2);
    }

    public final byte[] doFinal() throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("MAC not initialised");
        }
        return this.macSpi.engineDoFinal();
    }

    public final void doFinal(byte[] byArray, int n) throws ShortBufferException, IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("MAC not initialised");
        }
        if (byArray.length - n < this.macSpi.engineGetMacLength()) {
            throw new ShortBufferException("buffer to short for MAC output");
        }
        byte[] byArray2 = this.macSpi.engineDoFinal();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("MAC not initialised");
        }
        this.macSpi.engineUpdate(byArray, 0, byArray.length);
        return this.macSpi.engineDoFinal();
    }

    public final void reset() {
        this.macSpi.engineReset();
    }

    public final Object clone() throws CloneNotSupportedException {
        Mac mac = new Mac((MacSpi)this.macSpi.clone(), this.provider, this.algorithm);
        mac.initialised = this.initialised;
        return mac;
    }
}

