/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class NullCipher
extends Cipher {
    public NullCipher() {
        super(new NullCipherSpi(), null, "NULL");
    }

    private static class NullCipherSpi
    extends CipherSpi {
        private NullCipherSpi() {
        }

        protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        }

        protected void engineSetPadding(String string) throws NoSuchPaddingException {
        }

        protected int engineGetBlockSize() {
            return 1;
        }

        protected int engineGetOutputSize(int n) {
            return n;
        }

        protected byte[] engineGetIV() {
            return null;
        }

        protected AlgorithmParameters engineGetParameters() {
            return null;
        }

        protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        }

        protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        }

        protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        }

        protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
            if (byArray == null) {
                return null;
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            return byArray2;
        }

        protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
            if (byArray == null) {
                return 0;
            }
            if (byArray2.length - n3 < n2) {
                throw new ShortBufferException("output buffer to short for NullCipher");
            }
            System.arraycopy(byArray, n, byArray2, n3, n2);
            return n2;
        }

        protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
            if (byArray == null) {
                return new byte[0];
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            return byArray2;
        }

        protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
            if (byArray == null) {
                return 0;
            }
            if (byArray2.length - n3 < n2) {
                throw new ShortBufferException("output buffer too short for NullCipher");
            }
            System.arraycopy(byArray, n, byArray2, n3, n2);
            return n2;
        }

        protected int engineGetKeySize(Key key) throws InvalidKeyException {
            return 0;
        }
    }
}

