/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.encryption;

import java.security.Key;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.encryption.EncryptionMethod;
import org.apache.xml.security.algorithms.encryption.params.EncryptionMethodParams;
import org.apache.xml.security.encryption.CarriedKeyName;
import org.apache.xml.security.encryption.CipherData;
import org.apache.xml.security.encryption.DataReference;
import org.apache.xml.security.encryption.EncryptionProperties;
import org.apache.xml.security.encryption.KeyReference;
import org.apache.xml.security.encryption.ReferenceList;
import org.apache.xml.security.encryption.type.EncryptedType;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.KeyName;
import org.apache.xml.security.utils.EncryptionElementProxy;
import org.apache.xml.security.utils.HexDump;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EncryptedKey
extends EncryptionElementProxy
implements EncryptedType {
    public EncryptedKey(Document document, EncryptionMethod encryptionMethod, KeyInfo keyInfo, CipherData cipherData, EncryptionProperties encryptionProperties, ReferenceList referenceList, String string, String string2, String string3, String string4) throws XMLSecurityException {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
        if (encryptionMethod != null) {
            if (!encryptionMethod.getUsableInEncryptedKey()) {
                Object[] objectArray = new Object[]{encryptionMethod.getAlgorithmURI()};
                throw new XMLSecurityException("encryption.algorithmCannotBeUsedForEncryptedKey", objectArray);
            }
            this._constructionElement.appendChild(encryptionMethod.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
        if (keyInfo != null) {
            this._constructionElement.appendChild(keyInfo.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
        this._constructionElement.appendChild(cipherData.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
        if (encryptionProperties != null) {
            this._constructionElement.appendChild(encryptionProperties.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
        if (referenceList != null) {
            this._constructionElement.appendChild(referenceList.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
        this.setCarriedKeyName(string);
        this.setId(string2);
        this.setType(string3);
        this.setRecipient(string4);
    }

    public EncryptedKey(Document document, String string, EncryptionMethodParams encryptionMethodParams, KeyInfo keyInfo, Key key, Key key2, EncryptionProperties encryptionProperties, ReferenceList referenceList, String string2, String string3, String string4, String string5) throws XMLSecurityException {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
        EncryptionMethod encryptionMethod = new EncryptionMethod(document, string, encryptionMethodParams);
        if (!encryptionMethod.getUsableInEncryptedKey()) {
            Object[] objectArray = new Object[]{encryptionMethod.getAlgorithmURI()};
            throw new XMLSecurityException("encryption.algorithmCannotBeUsedForEncryptedKey", objectArray);
        }
        this._constructionElement.appendChild(encryptionMethod.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
        if (keyInfo != null) {
            this._constructionElement.appendChild(keyInfo.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
        byte[] byArray = encryptionMethod.wrap(key, key2);
        CipherData cipherData = new CipherData(document, byArray);
        this._constructionElement.appendChild(cipherData.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
        if (encryptionProperties != null) {
            this._constructionElement.appendChild(encryptionProperties.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
        if (referenceList != null) {
            this._constructionElement.appendChild(referenceList.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
        this.setCarriedKeyName(string2);
        this.setId(string3);
        this.setType(string4);
        this.setRecipient(string5);
    }

    public EncryptedKey(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    private void setReferenceList(ReferenceList referenceList) {
    }

    public ReferenceList getReferenceList() throws XMLSecurityException {
        int n = this.length("http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
        if (n > 1) {
            Object[] objectArray = new Object[]{"More then one xenc:ReferenceList found"};
            throw new XMLSecurityException("empty", objectArray);
        }
        if (n == 1) {
            Element element = this.getChildElementLocalName(0, "http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
            return new ReferenceList(element, this._baseURI);
        }
        return null;
    }

    public void addDataReference(DataReference dataReference) throws XMLSecurityException {
        if (this.getReferenceList() == null) {
            ReferenceList referenceList = new ReferenceList(this._doc);
            this.setReferenceList(referenceList);
        }
        this.getReferenceList().add(dataReference);
    }

    public void addKeyReference(KeyReference keyReference) throws XMLSecurityException {
        if (this.getReferenceList() == null) {
            ReferenceList referenceList = new ReferenceList(this._doc);
            this.setReferenceList(referenceList);
        }
        this.getReferenceList().add(keyReference);
    }

    public int getLengthDataReference() throws XMLSecurityException {
        ReferenceList referenceList = this.getReferenceList();
        if (referenceList == null) {
            return 0;
        }
        return referenceList.getLengthDataReference();
    }

    public int getLengthKeyReference() throws XMLSecurityException {
        ReferenceList referenceList = this.getReferenceList();
        if (referenceList == null) {
            return 0;
        }
        return referenceList.getLengthKeyReference();
    }

    public DataReference itemDataReference(int n) throws XMLSecurityException {
        ReferenceList referenceList = this.getReferenceList();
        return referenceList.itemDataReference(n);
    }

    public KeyReference itemKeyReference(int n) throws XMLSecurityException {
        ReferenceList referenceList = this.getReferenceList();
        return referenceList.itemKeyReference(n);
    }

    public void setCarriedKeyName(String string) throws XMLSecurityException {
        if (string != null && string.length() > 0 && this._state == 0) {
            CarriedKeyName carriedKeyName = this.getCarriedKeyName();
            if (carriedKeyName != null) {
                carriedKeyName.setCarriedKeyName(string);
            } else {
                carriedKeyName = new CarriedKeyName(this._doc, string);
                this._constructionElement.appendChild(carriedKeyName.getElement());
                XMLUtils.addReturnToElement(this._constructionElement);
            }
        }
    }

    public CarriedKeyName getCarriedKeyName() throws XMLSecurityException {
        Element element = XMLUtils.getDirectChild(this._constructionElement, "CarriedKeyName", "http://www.w3.org/2001/04/xmlenc#");
        if (element != null) {
            return new CarriedKeyName(element, this._baseURI);
        }
        return null;
    }

    public String getRecipient() {
        return this._constructionElement.getAttributeNS(null, "Recipient");
    }

    public void setRecipient(String string) {
        if (this._state == 0 && string != null && string.length() > 0) {
            this._constructionElement.setAttributeNS(null, "Recipient", string);
        }
    }

    public EncryptionMethod getEncryptionMethod() throws XMLSecurityException {
        Element element = XMLUtils.getDirectChild(this._constructionElement, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#");
        if (element != null) {
            return new EncryptionMethod(element, this._baseURI);
        }
        return null;
    }

    public KeyInfo getKeyInfo() throws XMLSecurityException {
        Element element = XMLUtils.getDirectChild(this._constructionElement, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        if (element != null) {
            return new KeyInfo(element, this._baseURI);
        }
        return null;
    }

    public CipherData getCipherData() throws XMLSecurityException {
        Element element = XMLUtils.getDirectChild(this._constructionElement, "CipherData", "http://www.w3.org/2001/04/xmlenc#");
        if (element != null) {
            return new CipherData(element, this._baseURI);
        }
        return null;
    }

    public EncryptionProperties getEncryptionProperties() throws XMLSecurityException {
        Element element = XMLUtils.getDirectChild(this._constructionElement, "EncryptionProperties", "http://www.w3.org/2001/04/xmlenc#");
        if (element != null) {
            return new EncryptionProperties(element, this._baseURI);
        }
        return null;
    }

    public void setId(String string) {
        if (this._state == 0 && string != null && string.length() != 0) {
            this._constructionElement.setAttributeNS(null, "Id", string);
            IdResolver.registerElementById(this._constructionElement, string);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public void setType(String string) {
        if (this._state == 0 && string != null) {
            this._constructionElement.setAttributeNS(null, "Type", string);
        }
    }

    public String getType() {
        return this._constructionElement.getAttributeNS(null, "Type");
    }

    public boolean getTypeIsElement() {
        String string = this.getType();
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equals("http://www.w3.org/2001/04/xmlenc#Element");
    }

    public boolean getTypeIsContent() {
        String string = this.getType();
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equals("http://www.w3.org/2001/04/xmlenc#Content");
    }

    public boolean getTypeIsMediaType() {
        String string = this.getType();
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.startsWith("http://www.isi.edu/in-notes/iana/assignments/media-types/");
    }

    public String getMediaTypeOfType() {
        if (this.getTypeIsMediaType()) {
            return this.getType().substring("http://www.isi.edu/in-notes/iana/assignments/media-types/".length());
        }
        return null;
    }

    public String getBaseLocalName() {
        return "EncryptedKey";
    }

    public Key unwrap(Key key, String string) throws XMLSecurityException {
        byte[] byArray = this.getCipherData().getCipherValue().getCipherText();
        return this.getEncryptionMethod().unwrap(byArray, key, string);
    }

    public static void main(String[] stringArray) throws Exception {
        Init.init();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        EncryptionMethod encryptionMethod = new EncryptionMethod(document, "http://www.w3.org/2001/04/xmlenc#kw-aes128");
        Key key = encryptionMethod.createSecretKeyFromBytes(HexDump.hexStringToByteArray("00 01 02 03 04 05 06 07 08 09 0a 0b 0c 0d 0e 0f"));
        Key key2 = encryptionMethod.createSecretKeyFromBytes(HexDump.hexStringToByteArray("00 01 02 03 04 05 06 07 08 09 0a 0b 0c 0d 0e 0f"));
        byte[] byArray = encryptionMethod.wrap(key2, key);
        KeyInfo keyInfo = new KeyInfo(document);
        keyInfo.add(new KeyName(document, "Christian Geuer-Pollmann"));
        EncryptedKey encryptedKey = new EncryptedKey(document, encryptionMethod, keyInfo, new CipherData(document, byArray), null, null, "Christian Geuer-Pollmann", "", "http://www.w3.org/2001/04/xmlenc#Content", "Ed Simon");
        document.appendChild(encryptedKey.getElement());
        XMLUtils.outputDOMc14nWithComments(document, System.out);
        EncryptionMethod encryptionMethod2 = encryptedKey.getEncryptionMethod();
        byte[] byArray2 = encryptedKey.getCipherData().getCipherValue().getCipherText();
        Key key3 = encryptionMethod2.createSecretKeyFromBytes(HexDump.hexStringToByteArray("00 01 02 03 04 05 06 07 08 09 0a 0b 0c 0d 0e 0f"));
        Key key4 = encryptionMethod2.unwrap(byArray2, key, "http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("getTypeIsContent   " + encryptedKey.getTypeIsContent());
        System.out.println("getTypeIsElement   " + encryptedKey.getTypeIsElement());
        System.out.println("getMediaTypeOfType " + encryptedKey.getMediaTypeOfType());
        System.out.println("Decrypted: '" + HexDump.byteArrayToHexString(key4.getEncoded()) + "'");
        System.out.println("Match: " + encryptedKey.getCarriedKeyName().matchesAgainstKeyInfo(encryptedKey.getKeyInfo()));
    }
}

