/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Manifest;
import org.apache.xml.security.signature.MissingResourceFailureException;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SignedInfo
extends Manifest {
    private SignatureAlgorithm _signatureAlgorithm = null;
    private byte[] _c14nizedBytes = null;

    public SignedInfo(Document document) throws XMLSecurityException {
        this(document, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "http://www.w3.org/2000/09/xmldsig#dsa-sha1");
    }

    public SignedInfo(Document document, String string, String string2) throws XMLSecurityException {
        this(document, string, string2, 0);
    }

    public SignedInfo(Document document, String string, String string2, int n) throws XMLSecurityException {
        super(document);
        Element element = XMLUtils.createElementInSignatureSpace(this._doc, "CanonicalizationMethod");
        element.setAttributeNS(null, "Algorithm", string);
        this._constructionElement.appendChild(element);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._signatureAlgorithm = n > 0 ? new SignatureAlgorithm(this._doc, string2, n) : new SignatureAlgorithm(this._doc, string2);
        this._constructionElement.appendChild(this._signatureAlgorithm.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public SignedInfo(Element element, String string) throws XMLSecurityException {
        super(element, string);
        try {
            Canonicalizer canonicalizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
            this._c14nizedBytes = canonicalizer.canonicalizeSubtree(this._constructionElement);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(this._c14nizedBytes));
            Node node = this._doc.importNode(document.getDocumentElement(), true);
            this._constructionElement.getParentNode().replaceChild(node, this._constructionElement);
            this._constructionElement = (Element)node;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XMLSecurityException("empty", parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new XMLSecurityException("empty", iOException);
        }
        catch (SAXException sAXException) {
            throw new XMLSecurityException("empty", sAXException);
        }
        this._signatureAlgorithm = new SignatureAlgorithm(this.getSignatureMethodElement(), this.getBaseURI());
    }

    public boolean verify() throws MissingResourceFailureException, XMLSecurityException {
        return super.verifyReferences(false);
    }

    public boolean verify(boolean bl) throws MissingResourceFailureException, XMLSecurityException {
        return super.verifyReferences(bl);
    }

    public byte[] getCanonicalizedOctetStream() throws CanonicalizationException, InvalidCanonicalizerException, IOException, XMLSecurityException {
        Object object;
        if (this._c14nizedBytes == null && this._state == 0) {
            object = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
            this._c14nizedBytes = ((Canonicalizer)object).canonicalizeSubtree(this._constructionElement);
        }
        object = new byte[this._c14nizedBytes.length];
        System.arraycopy(this._c14nizedBytes, 0, object, 0, ((Object)object).length);
        return object;
    }

    public String getCanonicalizationMethodURI() {
        NodeList nodeList = this._constructionElement.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                boolean bl = true;
                try {
                    XMLUtils.guaranteeThatElementInSignatureSpace((Element)node, "CanonicalizationMethod");
                }
                catch (XMLSecurityException xMLSecurityException) {
                    bl = false;
                }
                if (bl) {
                    return ((Element)node).getAttributeNS(null, "Algorithm");
                }
            }
            ++n;
        }
        return null;
    }

    public String getSignatureMethodURI() {
        Element element = this.getSignatureMethodElement();
        if (element != null) {
            return element.getAttributeNS(null, "Algorithm");
        }
        return null;
    }

    public Element getSignatureMethodElement() {
        NodeList nodeList = this._constructionElement.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            Manifest.cat.debug((Object)("Looking for SignatureMethodURI in " + node));
            if (node.getNodeType() == 1) {
                boolean bl = true;
                try {
                    XMLUtils.guaranteeThatElementInSignatureSpace((Element)node, "SignatureMethod");
                }
                catch (XMLSecurityException xMLSecurityException) {
                    bl = false;
                }
                if (bl) {
                    return (Element)node;
                }
            }
            ++n;
        }
        return null;
    }

    public SecretKey createSecretKey(byte[] byArray) throws XMLSecurityException {
        return new SecretKeySpec(byArray, this._signatureAlgorithm.getJCEAlgorithmString());
    }

    public String getBaseLocalName() {
        return "SignedInfo";
    }
}

