/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Category;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.Constants;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.EncryptionConstants;
import org.apache.xml.security.utils.HelperNodeList;
import org.apache.xml.security.utils.I18n;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtils {
    static Category cat = Category.getInstance((String)(class$org$apache$xml$security$utils$XMLUtils == null ? (class$org$apache$xml$security$utils$XMLUtils = XMLUtils.class$("org.apache.xml.security.utils.XMLUtils")) : class$org$apache$xml$security$utils$XMLUtils).getName());
    private static String[] nodeTypeString = new String[]{"", "ELEMENT", "ATTRIBUTE", "TEXT_NODE", "CDATA_SECTION", "ENTITY_REFERENCE", "ENTITY", "PROCESSING_INSTRUCTION", "COMMENT", "DOCUMENT", "DOCUMENT_TYPE", "DOCUMENT_FRAGMENT", "NOTATION"};
    private static String randomNS = null;
    public static final String randomNSprefix = "http://www.xmlsecurity.org/NS#randomval";
    static /* synthetic */ Class class$org$apache$xml$security$utils$XMLUtils;
    static /* synthetic */ Class class$java$lang$Thread;

    private XMLUtils() {
    }

    public static String getXalanVersion() {
        String string = XMLUtils.getXalan1Version();
        if (string != null) {
            return string;
        }
        string = XMLUtils.getXalan20Version();
        if (string != null) {
            return string;
        }
        string = XMLUtils.getXalan2Version();
        if (string != null) {
            return string;
        }
        return "Apache Xalan not installed";
    }

    public static String getXercesVersion() {
        String string = XMLUtils.getXerces1Version();
        if (string != null) {
            return string;
        }
        string = XMLUtils.getXerces2Version();
        if (string != null) {
            return string;
        }
        return "Apache Xerces not installed";
    }

    private static String getXalan1Version() {
        try {
            Class clazz = XMLUtils.classForName("org.apache.xalan.xslt.XSLProcessorVersion");
            StringBuffer stringBuffer = new StringBuffer();
            Field field = clazz.getField("PRODUCT");
            stringBuffer.append(field.get(null));
            stringBuffer.append(';');
            field = clazz.getField("LANGUAGE");
            stringBuffer.append(field.get(null));
            stringBuffer.append(';');
            field = clazz.getField("S_VERSION");
            stringBuffer.append(field.get(null));
            stringBuffer.append(';');
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getXalan20Version() {
        try {
            Class[] classArray = new Class[]{};
            Class clazz = XMLUtils.classForName("org.apache.xalan.Version");
            Method method = clazz.getMethod("getVersion", classArray);
            Object object = method.invoke(null, new Object[0]);
            return (String)object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getXalan2Version() {
        try {
            Class clazz = XMLUtils.classForName("org.apache.xalan.processor.XSLProcessorVersion");
            StringBuffer stringBuffer = new StringBuffer();
            Field field = clazz.getField("S_VERSION");
            stringBuffer.append(field.get(null));
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getXerces1Version() {
        try {
            Class clazz = XMLUtils.classForName("org.apache.xerces.framework.Version");
            Field field = clazz.getField("fVersion");
            String string = (String)field.get(null);
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getXerces2Version() {
        try {
            Class clazz = XMLUtils.classForName("org.apache.xerces.impl.Version");
            Field field = clazz.getField("fVersion");
            String string = (String)field.get(null);
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static Class classForName(String string) throws ClassNotFoundException {
        ClassLoader classLoader = XMLUtils.findClassLoader();
        if (classLoader == null) {
            return Class.forName(string);
        }
        return classLoader.loadClass(string);
    }

    protected static ClassLoader findClassLoader() throws ClassNotFoundException {
        Object var0 = null;
        Method method = null;
        try {
            method = (class$java$lang$Thread == null ? (class$java$lang$Thread = XMLUtils.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return (class$org$apache$xml$security$utils$XMLUtils == null ? (class$org$apache$xml$security$utils$XMLUtils = XMLUtils.class$("org.apache.xml.security.utils.XMLUtils")) : class$org$apache$xml$security$utils$XMLUtils).getClassLoader();
        }
        try {
            return (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public static void spitOutVersions(Category category) {
        category.debug((Object)XMLUtils.getXercesVersion());
        category.debug((Object)XMLUtils.getXalanVersion());
    }

    public static String getNodeTypeString(short s) {
        if (s > 0 && s < 13) {
            return nodeTypeString[s];
        }
        return "";
    }

    public static String getNodeTypeString(Node node) {
        return XMLUtils.getNodeTypeString(node.getNodeType());
    }

    public static Vector getAncestorElements(Node node) {
        if (node.getNodeType() != 1) {
            return null;
        }
        Vector<Node> vector = new Vector<Node>();
        Node node2 = node;
        while ((node2 = node2.getParentNode()) != null && node2.getNodeType() == 1) {
            vector.add(node2);
        }
        vector.trimToSize();
        return vector;
    }

    public static Vector getAncestorElements(Node node, Node node2) {
        Vector<Node> vector = new Vector<Node>();
        if (node.getNodeType() != 1) {
            return vector;
        }
        Node node3 = node;
        Node node4 = node2.getParentNode();
        while ((node3 = node3.getParentNode()) != null && node3.getNodeType() == 1 && node3 != node4) {
            vector.add(node3);
        }
        vector.trimToSize();
        return vector;
    }

    public static NodeList getDirectChildrenElements(Element element) {
        NodeList nodeList = element.getChildNodes();
        HelperNodeList helperNodeList = new HelperNodeList();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                helperNodeList.appendChild(node);
            }
            ++n;
        }
        return helperNodeList;
    }

    public static Element getDirectChild(Element element, String string, String string2) {
        NodeList nodeList = element.getChildNodes();
        Vector<Node> vector = new Vector<Node>();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1 && ((Element)node).getLocalName().equals(string) && ((Element)node).getNamespaceURI().equals(string2)) {
                vector.add(node);
            }
            ++n;
        }
        if (vector.size() != 1) {
            return null;
        }
        return (Element)vector.elementAt(0);
    }

    public static void outputDOM(Node node, String string) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        XMLUtils.outputDOM(node, fileOutputStream);
    }

    public static void outputDOM(Node node, OutputStream outputStream) {
        XMLUtils.outputDOM(node, outputStream, false);
    }

    public static void outputDOM(Node node, OutputStream outputStream, boolean bl) {
        try {
            if (bl) {
                outputStream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes());
            }
            outputStream.write(Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments").canonicalizeSubtree(node));
        }
        catch (IOException iOException) {
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            invalidCanonicalizerException.printStackTrace();
        }
        catch (CanonicalizationException canonicalizationException) {
            canonicalizationException.printStackTrace();
        }
    }

    public static void outputDOMc14nWithComments(Node node, OutputStream outputStream) {
        try {
            outputStream.write(Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments").canonicalizeSubtree(node));
        }
        catch (IOException iOException) {
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
        }
        catch (CanonicalizationException canonicalizationException) {
            // empty catch block
        }
    }

    public static NodeList elementToNodeList(Node node) {
        HelperNodeList helperNodeList = new HelperNodeList();
        helperNodeList.appendChild(node);
        return helperNodeList;
    }

    public static Attr createAttr(Document document, String string, String string2, String string3) {
        Attr attr = document.createAttributeNS(string3, string);
        attr.setNodeValue(string2);
        return attr;
    }

    public static void setAttr(Element element, String string, String string2) {
        Document document = element.getOwnerDocument();
        Attr attr = document.createAttributeNS("http://www.w3.org/2000/09/xmldsig#", string);
        attr.setNodeValue(string2);
        element.setAttributeNode(attr);
    }

    public static Element createElementFromBigint(Document document, String string, BigInteger bigInteger) throws XMLSignatureException {
        Object object;
        Element element = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", Constants.getSignatureSpecNSprefix() + ":" + string);
        if (bigInteger.signum() != 1) {
            throw new XMLSignatureException("signature.Util.BignumNonPositive");
        }
        byte[] byArray = bigInteger.toByteArray();
        while (byArray[0] == 0) {
            object = byArray;
            byArray = new byte[((byte[])object).length - 1];
            System.arraycopy(object, 1, byArray, 0, ((byte[])object).length - 1);
        }
        object = document.createTextNode(Base64.encode(byArray));
        element.appendChild((Node)object);
        return element;
    }

    public static String getFullTextChildrenFromElement(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 3) {
                stringBuffer.append(((Text)node).getData());
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static BigInteger getBigintFromElement(Element element) throws XMLSignatureException {
        try {
            if (element.getChildNodes().getLength() != 1) {
                throw new XMLSignatureException("signature.Util.TooManyChilds");
            }
            Node node = element.getFirstChild();
            if (node == null || node.getNodeType() != 3) {
                throw new XMLSignatureException("signature.Util.NonTextNode");
            }
            Text text = (Text)node;
            String string = text.getData();
            byte[] byArray = Base64.decode(string);
            int n = 1;
            BigInteger bigInteger = new BigInteger(n, byArray);
            return bigInteger;
        }
        catch (Base64DecodingException base64DecodingException) {
            throw new XMLSignatureException("empty", base64DecodingException);
        }
    }

    public static byte[] getBytesFromElement(Element element) throws XMLSignatureException {
        try {
            if (element.getChildNodes().getLength() != 1) {
                throw new XMLSignatureException("signature.Util.TooManyChilds");
            }
            Node node = element.getFirstChild();
            if (node == null || node.getNodeType() != 3) {
                throw new XMLSignatureException("signature.Util.NonTextNode");
            }
            Text text = (Text)node;
            String string = text.getData();
            byte[] byArray = Base64.decode(string);
            return byArray;
        }
        catch (Base64DecodingException base64DecodingException) {
            throw new XMLSignatureException("empty", base64DecodingException);
        }
    }

    public static Element createElementInSignatureSpace(Document document, String string) {
        if (document == null) {
            throw new RuntimeException("Document is null");
        }
        String string2 = Constants.getSignatureSpecNSprefix();
        if (string2 == null || string2.length() == 0) {
            Element element = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", string);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
            return element;
        }
        Element element = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", string2 + ":" + string);
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string2, "http://www.w3.org/2000/09/xmldsig#");
        return element;
    }

    public static Element createElementInEncryptionSpace(Document document, String string) {
        if (document == null) {
            throw new RuntimeException("Document is null");
        }
        String string2 = EncryptionConstants.getEncryptionSpecNSprefix();
        if (string2 == null || string2.length() == 0) {
            Element element = document.createElementNS("http://www.w3.org/2001/04/xmlenc#", string);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
            return element;
        }
        Element element = document.createElementNS("http://www.w3.org/2001/04/xmlenc#", string2 + ":" + string);
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string2, "http://www.w3.org/2001/04/xmlenc#");
        return element;
    }

    public static boolean elementIsInSignatureSpace(Element element, String string) {
        if (element == null) {
            return false;
        }
        if (element.getNamespaceURI() == null) {
            return false;
        }
        if (!element.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) {
            return false;
        }
        return element.getLocalName().equals(string);
    }

    public static boolean elementIsInEncryptionSpace(Element element, String string) {
        if (element == null) {
            return false;
        }
        if (element.getNamespaceURI() == null) {
            return false;
        }
        if (!element.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#")) {
            return false;
        }
        return element.getLocalName().equals(string);
    }

    public static void guaranteeThatElementInSignatureSpace(Element element, String string) throws XMLSignatureException {
        if (element == null) {
            Object[] objectArray = new Object[]{string, null};
            throw new XMLSignatureException("xml.WrongElement", objectArray);
        }
        if (string == null || string.equals("") || !XMLUtils.elementIsInSignatureSpace(element, string)) {
            Object[] objectArray = new Object[]{string, element.getLocalName()};
            throw new XMLSignatureException("xml.WrongElement", objectArray);
        }
    }

    public static void guaranteeThatElementInEncryptionSpace(Element element, String string) throws XMLSecurityException {
        if (element == null) {
            Object[] objectArray = new Object[]{string, null};
            throw new XMLSecurityException("xml.WrongElement", objectArray);
        }
        if (string == null || string.equals("") || !XMLUtils.elementIsInEncryptionSpace(element, string)) {
            Object[] objectArray = new Object[]{string, element.getLocalName()};
            throw new XMLSecurityException("xml.WrongElement", objectArray);
        }
    }

    public static Document getOwnerDocument(Node node) {
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        try {
            return node.getOwnerDocument();
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException(I18n.translate("endorsed.jdk1.4.0") + " Original message was \"" + ((Throwable)nullPointerException).getMessage() + "\"");
        }
    }

    public static String getRandomNamespacePrefix() {
        if (randomNS == null) {
            byte[] byArray = new byte[21];
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(byArray);
            String string = "xmlsecurityOrgPref" + Base64.encode(byArray);
            randomNS = "";
            int n = 0;
            while (n < string.length()) {
                if (string.charAt(n) != '+' && string.charAt(n) != '/' && string.charAt(n) != '=') {
                    randomNS = randomNS + string.charAt(n);
                }
                ++n;
            }
        }
        return randomNS;
    }

    public static Element createDSctx(Document document, String string, String string2) {
        Element element = document.createElementNS(null, "namespaceContext");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string.trim(), string2);
        return element;
    }

    public static Element createDSctx(Document document, String string) {
        return XMLUtils.createDSctx(document, string, "http://www.w3.org/2000/09/xmldsig#");
    }

    public static void indentSignature(Element element, String string, int n) {
        try {
            NodeList nodeList = XPathAPI.selectNodeList((Node)element, (String)".//text()");
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                Text text = (Text)nodeList.item(n2);
                Element element2 = (Element)text.getParentNode();
                Document document = text.getOwnerDocument();
                int n3 = 0;
                while (element2 != element) {
                    ++n3;
                }
                String string2 = "";
                int n4 = 0;
                while (n4 < n3) {
                    string2 = string2 + string;
                    ++n4;
                }
                Text text2 = document.createTextNode(string2);
                element2.replaceChild(text2, text);
                ++n2;
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public static void addReturnToElement(ElementProxy elementProxy) {
        Document document = elementProxy._doc;
        elementProxy.getElement().appendChild(document.createTextNode("\n"));
    }

    public static void addReturnToElement(Element element) {
        Document document = element.getOwnerDocument();
        element.appendChild(document.createTextNode("\n"));
    }

    public static void addReturnToNode(Node node) {
        Document document = node.getOwnerDocument();
        node.appendChild(document.createTextNode("\n"));
    }

    public static Set convertNodelistToSet(NodeList nodeList) {
        if (nodeList == null) {
            return new HashSet();
        }
        int n = nodeList.getLength();
        HashSet<Node> hashSet = new HashSet<Node>(n);
        int n2 = 0;
        while (n2 < n) {
            hashSet.add(nodeList.item(n2));
            ++n2;
        }
        return hashSet;
    }

    public static NodeList convertSetToNodelist(Set set) {
        HelperNodeList helperNodeList = new HelperNodeList();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            helperNodeList.appendChild((Node)iterator.next());
        }
        return helperNodeList;
    }

    public static void circumventBug2650(Document document) {
        XMLUtils.circumventBug2650recurse(document);
    }

    private static void circumventBug2650recurse(Node node) {
        Node node2;
        if (node.getNodeType() == 1) {
            node2 = (Element)node;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            int n = namedNodeMap.getLength();
            NodeList nodeList = node2.getChildNodes();
            int n2 = nodeList.getLength();
            int n3 = 0;
            while (n3 < n2) {
                Node node3 = nodeList.item(n3);
                if (node3.getNodeType() == 1) {
                    Element element = (Element)node3;
                    int n4 = 0;
                    while (n4 < n) {
                        Attr attr = (Attr)namedNodeMap.item(n4);
                        String string = attr.getNodeName();
                        if (string.startsWith("xmlns")) {
                            boolean bl;
                            String string2 = attr.getNodeValue();
                            boolean bl2 = bl = !element.hasAttribute(string);
                            if (bl) {
                                element.setAttributeNS("http://www.w3.org/2000/xmlns/", string, string2);
                            }
                        }
                        ++n4;
                    }
                }
                ++n3;
            }
        }
        node2 = node.getFirstChild();
        while (node2 != null) {
            switch (node2.getNodeType()) {
                case 1: 
                case 5: 
                case 9: {
                    XMLUtils.circumventBug2650recurse(node2);
                }
            }
            node2 = node2.getNextSibling();
        }
    }

    private static String getXPath(Node node, String string) {
        if (node == null) {
            return string;
        }
        switch (node.getNodeType()) {
            case 2: {
                return XMLUtils.getXPath(((Attr)node).getOwnerElement(), "/@" + ((Attr)node).getNodeName() + "=\"" + ((Attr)node).getNodeValue() + "\"");
            }
            case 1: {
                return XMLUtils.getXPath(node.getParentNode(), "/" + ((Element)node).getTagName() + string);
            }
            case 3: {
                return XMLUtils.getXPath(node.getParentNode(), "/#text");
            }
            case 9: {
                if (string.length() > 0) {
                    return string;
                }
                return "/";
            }
        }
        return string;
    }

    public static String getXPath(Node node) {
        return XMLUtils.getXPath(node, "");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

