/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.encoding;

import cryptix.asn1.encoding.CoderOperations;
import cryptix.asn1.encoding.PackageProperties;
import cryptix.asn1.lang.ASNAny;
import cryptix.asn1.lang.ASNBitString;
import cryptix.asn1.lang.ASNBoolean;
import cryptix.asn1.lang.ASNInteger;
import cryptix.asn1.lang.ASNNull;
import cryptix.asn1.lang.ASNObjectIdentifier;
import cryptix.asn1.lang.ASNOctetString;
import cryptix.asn1.lang.ASNPrintableString;
import cryptix.asn1.lang.ASNSequence;
import cryptix.asn1.lang.ASNSequenceOf;
import cryptix.asn1.lang.ASNSet;
import cryptix.asn1.lang.ASNSetOf;
import cryptix.asn1.lang.ASNSpecification;
import cryptix.asn1.lang.ASNTaggedType;
import cryptix.asn1.lang.ASNTime;
import cryptix.asn1.lang.ASNType;
import cryptix.asn1.lang.ASNTypeAlias;
import cryptix.asn1.lang.Parser;
import cryptix.asn1.lang.SimpleNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class BaseCoder
implements CoderOperations {
    private static final String NAME = "BaseCoder";
    private static final boolean IN = true;
    private static final boolean OUT = false;
    private static final boolean DEBUG = false;
    private static final int debuglevel = 0;
    private static final PrintWriter err = null;
    private static final boolean TRACE = PackageProperties.isTraceable("BaseCoder");
    private static final String ENCODING_HOME = "asn.1.encoding.home";
    protected InputStream in;
    protected OutputStream out;
    private int state = 0;

    private static void debug(String string) {
        ((PrintWriter)null).println(">>> BaseCoder: " + string);
    }

    public void decode(ASNAny aSNAny, InputStream inputStream) throws IOException {
    }

    public void decode(ASNBitString aSNBitString, InputStream inputStream) throws IOException {
    }

    public void decode(ASNBoolean aSNBoolean, InputStream inputStream) throws IOException {
    }

    public void decode(ASNInteger aSNInteger, InputStream inputStream) throws IOException {
    }

    public void decode(ASNNull aSNNull, InputStream inputStream) throws IOException {
    }

    public void decode(ASNObjectIdentifier aSNObjectIdentifier, InputStream inputStream) throws IOException {
    }

    public void decode(ASNOctetString aSNOctetString, InputStream inputStream) throws IOException {
    }

    public void decode(ASNPrintableString aSNPrintableString, InputStream inputStream) throws IOException {
    }

    public void decode(ASNSequence aSNSequence, InputStream inputStream) throws IOException {
    }

    public void decode(ASNSequenceOf aSNSequenceOf, InputStream inputStream) throws IOException {
    }

    public void decode(ASNSet aSNSet, InputStream inputStream) throws IOException {
    }

    public void decode(ASNSetOf aSNSetOf, InputStream inputStream) throws IOException {
    }

    public void decode(ASNTaggedType aSNTaggedType, InputStream inputStream) throws IOException {
    }

    public void decode(ASNTime aSNTime, InputStream inputStream) throws IOException {
    }

    public void decode(ASNType aSNType, InputStream inputStream) throws IOException {
        SimpleNode simpleNode;
        boolean bl = aSNType.isOptional();
        String string = aSNType.getName();
        if (string != null) {
            aSNType.getParser();
            simpleNode = (SimpleNode)Parser.resolve(string);
        } else {
            simpleNode = (SimpleNode)aSNType.getChild(0);
        }
        simpleNode.setOptional(bl);
        Object object = this.visitInternal(simpleNode, null);
        aSNType.setValue(object);
    }

    public void decode(ASNTypeAlias aSNTypeAlias, InputStream inputStream) throws IOException {
        aSNTypeAlias.getParser();
        SimpleNode simpleNode = (SimpleNode)Parser.resolve(aSNTypeAlias.getName());
        Object object = this.visitInternal(simpleNode, null);
        aSNTypeAlias.setValue(object);
    }

    public void encode(ASNAny aSNAny, OutputStream outputStream) throws IOException {
    }

    public void encode(ASNBitString aSNBitString, OutputStream outputStream) throws IOException {
    }

    public void encode(ASNBoolean aSNBoolean, OutputStream outputStream) throws IOException {
    }

    public void encode(ASNInteger aSNInteger, OutputStream outputStream) throws IOException {
    }

    public void encode(ASNNull aSNNull, OutputStream outputStream) throws IOException {
    }

    public void encode(ASNObjectIdentifier aSNObjectIdentifier, OutputStream outputStream) throws IOException {
    }

    public void encode(ASNOctetString aSNOctetString, OutputStream outputStream) throws IOException {
    }

    public void encode(ASNPrintableString aSNPrintableString, OutputStream outputStream) throws IOException {
    }

    public void encode(ASNSequence aSNSequence, OutputStream outputStream) throws IOException {
    }

    public void encode(ASNSequenceOf aSNSequenceOf, OutputStream outputStream) throws IOException {
    }

    public void encode(ASNSet aSNSet, OutputStream outputStream) throws IOException {
    }

    public void encode(ASNSetOf aSNSetOf, OutputStream outputStream) throws IOException {
    }

    public void encode(ASNTaggedType aSNTaggedType, OutputStream outputStream) throws IOException {
    }

    public void encode(ASNTime aSNTime, OutputStream outputStream) throws IOException {
    }

    public void encode(ASNType aSNType, OutputStream outputStream) throws IOException {
    }

    public void encode(ASNTypeAlias aSNTypeAlias, OutputStream outputStream) throws IOException {
    }

    public static CoderOperations getInstance(String string) {
        Object object;
        int n = string.lastIndexOf(46);
        if (n == -1) {
            object = PackageProperties.getProperty(ENCODING_HOME);
            string = String.valueOf(object) + "." + string;
        }
        object = null;
        try {
            object = (CoderOperations)Class.forName(string).newInstance();
        }
        catch (Throwable throwable) {
            BaseCoder.debug("Unable to instantiate " + string + " coder");
            BaseCoder.debug(throwable.toString());
            BaseCoder.debug(throwable.getMessage());
            throwable.printStackTrace((PrintWriter)null);
        }
        return object;
    }

    public int getState() {
        return this.state;
    }

    public void init(InputStream inputStream) {
        this.in = inputStream;
        this.state = 1;
    }

    public void init(OutputStream outputStream) {
        this.out = outputStream;
        this.state = 2;
    }

    private static void trace(String string) {
        if (TRACE) {
            ((PrintWriter)null).println("<=> BaseCoder." + string);
        }
    }

    private static void trace(boolean bl, String string) {
        if (TRACE) {
            ((PrintWriter)null).println(String.valueOf(bl ? "==> " : "<== ") + NAME + "." + string);
        }
    }

    public Object visit(ASNAny aSNAny, Object object) throws IOException {
        return this.visitInternal(aSNAny, object);
    }

    public Object visit(ASNBitString aSNBitString, Object object) throws IOException {
        return aSNBitString.childrenAccept(this, object);
    }

    public Object visit(ASNBoolean aSNBoolean, Object object) throws IOException {
        return this.visitInternal(aSNBoolean, object);
    }

    public Object visit(ASNInteger aSNInteger, Object object) throws IOException {
        return this.visitInternal(aSNInteger, object);
    }

    public Object visit(ASNNull aSNNull, Object object) throws IOException {
        return this.visitInternal(aSNNull, object);
    }

    public Object visit(ASNObjectIdentifier aSNObjectIdentifier, Object object) throws IOException {
        return this.visitInternal(aSNObjectIdentifier, object);
    }

    public Object visit(ASNOctetString aSNOctetString, Object object) throws IOException {
        return this.visitInternal(aSNOctetString, object);
    }

    public Object visit(ASNPrintableString aSNPrintableString, Object object) throws IOException {
        return this.visitInternal(aSNPrintableString, object);
    }

    public Object visit(ASNSequence aSNSequence, Object object) throws IOException {
        return this.visitInternal(aSNSequence, object);
    }

    public Object visit(ASNSequenceOf aSNSequenceOf, Object object) throws IOException {
        return this.visitInternal(aSNSequenceOf, object);
    }

    public Object visit(ASNSet aSNSet, Object object) throws IOException {
        return this.visitInternal(aSNSet, object);
    }

    public Object visit(ASNSetOf aSNSetOf, Object object) throws IOException {
        return this.visitInternal(aSNSetOf, object);
    }

    public Object visit(ASNSpecification aSNSpecification, Object object) throws IOException {
        return aSNSpecification.childrenAccept(this, object);
    }

    public Object visit(ASNTaggedType aSNTaggedType, Object object) throws IOException {
        return this.visitInternal(aSNTaggedType, object);
    }

    public Object visit(ASNTime aSNTime, Object object) throws IOException {
        return this.visitInternal(aSNTime, object);
    }

    public Object visit(ASNType aSNType, Object object) throws IOException {
        return this.visitInternal(aSNType, object);
    }

    public Object visit(ASNTypeAlias aSNTypeAlias, Object object) throws IOException {
        return this.visitInternal(aSNTypeAlias, object);
    }

    public Object visit(SimpleNode simpleNode, Object object) throws IOException {
        String string = "Don't know how to visit " + simpleNode;
        throw new RuntimeException(string);
    }

    protected Object visitInternal(SimpleNode simpleNode, Object object) throws IOException {
        block37: {
            block38: {
                block36: {
                    if (this.state != 2) break block36;
                    switch (simpleNode.getID()) {
                        case 2: {
                            this.encode((ASNType)simpleNode, this.out);
                            break block37;
                        }
                        case 3: {
                            this.encode((ASNTypeAlias)simpleNode, this.out);
                            break block37;
                        }
                        case 4: {
                            this.encode((ASNBoolean)simpleNode, this.out);
                            break block37;
                        }
                        case 5: {
                            this.encode((ASNInteger)simpleNode, this.out);
                            break block37;
                        }
                        case 6: {
                            this.encode((ASNBitString)simpleNode, this.out);
                            break block37;
                        }
                        case 7: {
                            this.encode((ASNOctetString)simpleNode, this.out);
                            break block37;
                        }
                        case 8: {
                            this.encode((ASNNull)simpleNode, this.out);
                            break block37;
                        }
                        case 9: {
                            this.encode((ASNObjectIdentifier)simpleNode, this.out);
                            break block37;
                        }
                        case 10: {
                            this.encode((ASNSequence)simpleNode, this.out);
                            break block37;
                        }
                        case 11: {
                            this.encode((ASNSequenceOf)simpleNode, this.out);
                            break block37;
                        }
                        case 12: {
                            this.encode((ASNSet)simpleNode, this.out);
                            break block37;
                        }
                        case 13: {
                            this.encode((ASNSetOf)simpleNode, this.out);
                            break block37;
                        }
                        case 14: {
                            this.encode((ASNTaggedType)simpleNode, this.out);
                            break block37;
                        }
                        case 15: {
                            this.encode((ASNAny)simpleNode, this.out);
                            break block37;
                        }
                        case 16: {
                            this.encode((ASNPrintableString)simpleNode, this.out);
                            break block37;
                        }
                        case 17: {
                            this.encode((ASNTime)simpleNode, this.out);
                            break block37;
                        }
                        default: {
                            String string = "Don't know how to encode " + simpleNode;
                            throw new RuntimeException(string);
                        }
                    }
                }
                if (this.state != 1) break block38;
                switch (simpleNode.getID()) {
                    case 2: {
                        this.decode((ASNType)simpleNode, this.in);
                        break block37;
                    }
                    case 3: {
                        this.decode((ASNTypeAlias)simpleNode, this.in);
                        break block37;
                    }
                    case 4: {
                        this.decode((ASNBoolean)simpleNode, this.in);
                        break block37;
                    }
                    case 5: {
                        this.decode((ASNInteger)simpleNode, this.in);
                        break block37;
                    }
                    case 6: {
                        this.decode((ASNBitString)simpleNode, this.in);
                        break block37;
                    }
                    case 7: {
                        this.decode((ASNOctetString)simpleNode, this.in);
                        break block37;
                    }
                    case 8: {
                        this.decode((ASNNull)simpleNode, this.in);
                        break block37;
                    }
                    case 9: {
                        this.decode((ASNObjectIdentifier)simpleNode, this.in);
                        break block37;
                    }
                    case 10: {
                        this.decode((ASNSequence)simpleNode, this.in);
                        break block37;
                    }
                    case 11: {
                        this.decode((ASNSequenceOf)simpleNode, this.in);
                        break block37;
                    }
                    case 12: {
                        this.decode((ASNSet)simpleNode, this.in);
                        break block37;
                    }
                    case 13: {
                        this.decode((ASNSetOf)simpleNode, this.in);
                        break block37;
                    }
                    case 14: {
                        this.decode((ASNTaggedType)simpleNode, this.in);
                        break block37;
                    }
                    case 15: {
                        this.decode((ASNAny)simpleNode, this.in);
                        break block37;
                    }
                    case 16: {
                        this.decode((ASNPrintableString)simpleNode, this.in);
                        break block37;
                    }
                    case 17: {
                        this.decode((ASNTime)simpleNode, this.in);
                        break block37;
                    }
                    default: {
                        String string = "Don't know how to decode " + simpleNode;
                        throw new RuntimeException(string);
                    }
                }
            }
            throw new IllegalStateException();
        }
        return simpleNode.getValue();
    }
}

