/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.lang;

import cryptix.asn1.lang.ASNBitString;
import cryptix.asn1.lang.ASNBoolean;
import cryptix.asn1.lang.ASNInteger;
import cryptix.asn1.lang.ASNNull;
import cryptix.asn1.lang.ASNObject;
import cryptix.asn1.lang.ASNObjectIdentifier;
import cryptix.asn1.lang.ASNOctetString;
import cryptix.asn1.lang.ASNPrintableString;
import cryptix.asn1.lang.ASNSequence;
import cryptix.asn1.lang.ASNSequenceOf;
import cryptix.asn1.lang.ASNSet;
import cryptix.asn1.lang.ASNSetOf;
import cryptix.asn1.lang.ASNTaggedType;
import cryptix.asn1.lang.ASNTime;
import cryptix.asn1.lang.ASNType;
import cryptix.asn1.lang.ASNTypeAlias;
import cryptix.asn1.lang.Node;
import cryptix.asn1.lang.PackageProperties;
import cryptix.asn1.lang.Parser;
import cryptix.asn1.lang.ParserTreeConstants;
import cryptix.asn1.lang.ParserVisitor;
import cryptix.asn1.lang.Tag;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class SimpleNode
implements ASNObject {
    private static final String NAME = "SimpleNode";
    private static final boolean IN = true;
    private static final boolean OUT = false;
    private static final boolean DEBUG = false;
    private static final int debuglevel = 0;
    private static final PrintWriter err = null;
    private static final boolean TRACE = PackageProperties.isTraceable("SimpleNode");
    protected ASNObject parent;
    protected ASNObject[] children;
    protected int id;
    protected Parser parser;
    protected String name;
    protected Tag tag;
    protected boolean optional;
    protected Object value;
    protected Object defaultValue;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(Parser parser, int n) {
        this(n);
        this.parser = parser;
    }

    public Object accept(ParserVisitor parserVisitor, Object object) throws IOException {
        return this.jjtAccept(parserVisitor, object);
    }

    public Object childrenAccept(ParserVisitor parserVisitor, Object object) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                this.children[n].jjtAccept(parserVisitor, object);
                vector.addElement(this.children[n].getValue());
                ++n;
            }
        }
        return vector;
    }

    private static void debug(String string) {
        ((PrintWriter)null).println(">>> SimpleNode: " + string);
    }

    public void dump() {
        System.out.println(this.toString());
    }

    public void dump(String string) {
        if (this instanceof ASNType) {
            this.dumpType(this, string);
        } else if (this instanceof ASNTaggedType) {
            this.dumpTaggedType(this, string);
        } else if (this instanceof ASNTypeAlias) {
            this.dumpTypeAlias(this, string);
        } else {
            this.dumpSimpleNode(this, string);
        }
    }

    private void dumpChildren(ASNObject[] aSNObjectArray, String string) {
        if (aSNObjectArray == null) {
            return;
        }
        string = String.valueOf(string) + "+ ";
        int n = aSNObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleNode simpleNode = (SimpleNode)aSNObjectArray[n2];
            if (simpleNode != null) {
                simpleNode.dump(string);
            }
            ++n2;
        }
    }

    private void dumpSimpleNode(SimpleNode simpleNode, String string) {
        System.out.println(simpleNode.toString(string));
        this.dumpChildren(this.children, string);
    }

    private void dumpTaggedType(SimpleNode simpleNode, String string) {
        SimpleNode simpleNode2 = (SimpleNode)Parser.resolve(simpleNode.name);
        System.out.println(simpleNode2.toString(String.valueOf(string) + simpleNode.getTag()));
    }

    private void dumpType(SimpleNode simpleNode, String string) {
        SimpleNode simpleNode2 = (SimpleNode)simpleNode.children[0];
        simpleNode2.dump(string);
    }

    private void dumpTypeAlias(SimpleNode simpleNode, String string) {
        SimpleNode simpleNode2 = (SimpleNode)Parser.resolve(simpleNode.name);
        simpleNode2.dump(string);
    }

    public ASNObject getChild(int n) {
        return (ASNObject)this.jjtGetChild(n);
    }

    public ASNObject[] getChildren() {
        return this.children;
    }

    public ASNObject getComponent(String string) {
        ASNObject aSNObject = (ASNObject)Parser.resolve(string);
        return aSNObject;
    }

    public Object getDefaultValue() {
        if (this instanceof ASNType) {
            SimpleNode simpleNode = (SimpleNode)this.children[0];
            return simpleNode.defaultValue;
        }
        if (this instanceof ASNTaggedType) {
            SimpleNode simpleNode = (SimpleNode)Parser.resolve(this.name);
            return simpleNode.defaultValue;
        }
        if (this instanceof ASNTypeAlias) {
            SimpleNode simpleNode = (SimpleNode)Parser.resolve(this.name);
            return simpleNode.defaultValue;
        }
        return this.defaultValue;
    }

    public int getID() {
        return this.id;
    }

    public static final SimpleNode getInstance(Parser parser, Tag tag) {
        int n = tag.getClazz();
        if (n != 0) {
            return null;
        }
        int n2 = tag.getValue();
        SimpleNode simpleNode = null;
        switch (n2) {
            case 1: {
                simpleNode = new ASNBoolean(parser, 4);
                break;
            }
            case 2: {
                simpleNode = new ASNInteger(parser, 5);
                break;
            }
            case 3: {
                simpleNode = new ASNBitString(parser, 6);
                break;
            }
            case 4: {
                simpleNode = new ASNOctetString(parser, 7);
                break;
            }
            case 5: {
                simpleNode = new ASNNull(parser, 8);
                break;
            }
            case 6: {
                simpleNode = new ASNObjectIdentifier(parser, 9);
                break;
            }
            case 16: {
                simpleNode = new ASNSequence(parser, 10);
                break;
            }
            case 48: {
                simpleNode = new ASNSequenceOf(parser, 11);
                break;
            }
            case 17: {
                simpleNode = new ASNSet(parser, 12);
                break;
            }
            case 49: {
                simpleNode = new ASNSetOf(parser, 13);
                break;
            }
            case 19: 
            case 20: 
            case 22: {
                simpleNode = new ASNPrintableString(parser, 16);
                break;
            }
            case 23: {
                simpleNode = new ASNTime(parser, 17);
                break;
            }
        }
        return simpleNode;
    }

    public String getName() {
        return this.name;
    }

    public ASNObject getParent() {
        SimpleNode simpleNode = this;
        while ((simpleNode = (SimpleNode)simpleNode.jjtGetParent()) != null && simpleNode.id == 2) {
        }
        return simpleNode;
    }

    public Parser getParser() {
        return this.parser;
    }

    public Tag getTag() {
        return this.tag;
    }

    public Object getValue() {
        Object object = null;
        if (this.id == 3) {
            SimpleNode simpleNode = (SimpleNode)Parser.resolve(this.name);
            if (simpleNode != null) {
                object = simpleNode.getValue();
            }
        } else {
            object = this.value;
        }
        return object;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Object jjtAccept(ParserVisitor parserVisitor, Object object) throws IOException {
        return parserVisitor.visit(this, object);
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new ASNObject[n + 1];
        } else if (n >= this.children.length) {
            ASNObject[] aSNObjectArray = new ASNObject[n + 1];
            System.arraycopy(this.children, 0, aSNObjectArray, 0, this.children.length);
            this.children = aSNObjectArray;
        }
        this.children[n] = (ASNObject)node;
    }

    public void jjtClose() {
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtOpen() {
    }

    public void jjtSetParent(Node node) {
        this.parent = (ASNObject)node;
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOptional(boolean bl) {
        this.optional = bl;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public String toString() {
        String string = "<ASNObject name=\"" + this.name + "\" type=\"";
        string = String.valueOf(string) + ParserTreeConstants.jjtNodeName[this.id] + "\"";
        string = String.valueOf(string) + " default=\"" + this.defaultValue + "\"";
        string = String.valueOf(string) + " optional=\"" + (this.optional ? "yes" : "no") + "\" />";
        return string;
    }

    public String toString(String string) {
        String string2 = String.valueOf(string) + this.toString();
        return string2;
    }

    private static void trace(String string) {
        if (TRACE) {
            ((PrintWriter)null).println("<=> SimpleNode." + string);
        }
    }

    private static void trace(boolean bl, String string) {
        if (TRACE) {
            ((PrintWriter)null).println(String.valueOf(bl ? "==> " : "<== ") + NAME + "." + string);
        }
    }
}

