/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.app;

import java.io.IOException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.HostPort;
import org.globus.ftp.HostPortList;
import org.globus.ftp.RetrieveOptions;
import org.globus.ftp.app.TransferParams;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.ServerException;

public class Transfer {
    static Logger logger = Logger.getLogger((String)(class$org$globus$ftp$app$Transfer == null ? (class$org$globus$ftp$app$Transfer = Transfer.class$("org.globus.ftp.app.Transfer")) : class$org$globus$ftp$app$Transfer).getName());
    static /* synthetic */ Class class$org$globus$ftp$app$Transfer;

    public static void main(String[] args) {
        String sourceServer = null;
        String sourceDir = null;
        String sourceFile = null;
        String destServer = null;
        String destDir = null;
        String destFile = null;
        int sourcePort = 0;
        int destPort = 0;
        try {
            if (args.length < 8) {
                throw new Exception();
            }
            sourceServer = args[0];
            sourcePort = Integer.parseInt(args[1]);
            sourceDir = args[2];
            sourceFile = args[3];
            destServer = args[4];
            destPort = Integer.parseInt(args[5]);
            destDir = args[6];
            destFile = args[7];
        }
        catch (Exception e) {
            System.err.println("\nUsage:");
            System.err.println("Transfer \\");
            System.err.println("sourceServer sourcePort sourceDir sourceFile \\");
            System.err.println("destServer destPort destDir destFile");
            System.exit(-1);
        }
        try {
            logger.setLevel(Level.INFO);
            logger.info((Object)"starting");
            TransferParams params = new TransferParams();
            Transfer transfer = new Transfer(sourceServer, sourcePort, sourceDir, sourceFile, destServer, destPort, destDir, destFile, params);
        }
        catch (Exception e) {
            System.err.println("\nTransfer failed!\n");
            System.err.println("exception:");
            System.err.println(e.toString());
            System.err.println("\nstack trace:");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public Transfer(String sourceServer, int sourcePort, String sourceDir, String sourceFile, String destServer, int destPort, String destDir, String destFile, TransferParams params) throws IOException, ServerException, ClientException {
        this(sourceServer, sourcePort, sourceDir + "/" + sourceFile, destServer, destPort, destDir + "/" + destFile, params);
    }

    public Transfer(String sourceServer, int sourcePort, String absoluteSourceFile, String destServer, int destPort, String absoluteDestFile, TransferParams params) throws IOException, ServerException, ClientException {
        GridFTPClient passive;
        GridFTPClient active;
        if (params == null) {
            params = new TransferParams();
        }
        GridFTPClient source = new GridFTPClient(sourceServer, sourcePort);
        GridFTPClient dest = new GridFTPClient(destServer, destPort);
        this.setParams(source, params);
        this.setParams(dest, params);
        if (params.serverMode != 1) {
            active = source;
            passive = dest;
        } else {
            active = dest;
            passive = source;
        }
        if (!params.doStriping) {
            HostPort hp = passive.setPassive();
            active.setActive(hp);
        } else {
            HostPortList hpl = passive.setStripedPassive();
            active.setStripedActive(hpl);
        }
        if (params.transferMode != 3) {
            source.transfer(absoluteSourceFile, dest, absoluteDestFile, false, params.markerListener);
        } else {
            source.extendedTransfer(absoluteSourceFile, dest, absoluteDestFile, params.markerListener);
        }
    }

    private void setParams(GridFTPClient client, TransferParams params) throws IOException, ServerException {
        client.authenticate(params.credential);
        if (params.transferType != -1) {
            client.setType(params.transferType);
        }
        if (params.transferMode != -1) {
            client.setMode(params.transferMode);
        }
        if (params.parallel != -1) {
            client.setOptions(new RetrieveOptions(params.parallel));
        }
        if (params.protectionBufferSize != -1) {
            client.setProtectionBufferSize(params.protectionBufferSize);
        }
        if (params.dataChannelAuthentication != null) {
            client.setDataChannelAuthentication(params.dataChannelAuthentication);
        }
        if (params.dataChannelProtection != -1) {
            client.setDataChannelProtection(params.dataChannelProtection);
        }
        if (params.TCPBufferSize != -1) {
            client.setTCPBufferSize(params.TCPBufferSize);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

