/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import org.apache.log4j.Logger;
import org.globus.ftp.dc.Task;

public class TaskThread
implements Runnable {
    static final int MAX_TASK_QUEUE = 100;
    protected static Logger logger = Logger.getLogger((String)(class$org$globus$ftp$dc$TaskThread == null ? (class$org$globus$ftp$dc$TaskThread = TaskThread.class$("org.globus.ftp.dc.TaskThread")) : class$org$globus$ftp$dc$TaskThread).getName());
    protected Buffer buffer = new Buffer(100);
    protected boolean stop;
    protected Thread thread;
    protected boolean running = false;
    static /* synthetic */ Class class$org$globus$ftp$dc$TaskThread;

    public synchronized void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void runTask(Task task) {
        this.start();
        try {
            this.buffer.put(task);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Task getNextTask() {
        try {
            return (Task)this.buffer.get();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void run() {
        this.running = true;
        this.stop = false;
        while (!this.stop) {
            Task task = this.getNextTask();
            if (task == null) break;
            Exception exception = null;
            try {
                logger.debug((Object)"executing task");
                task.execute();
                logger.debug((Object)"finished task");
            }
            catch (Exception e) {
                exception = e;
            }
            task.setComplete(exception);
        }
        logger.debug((Object)"notify that thread is finishing");
        TaskThread taskThread = this;
        synchronized (taskThread) {
            this.running = false;
            this.notify();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public synchronized void stop() {
        this.stop = true;
        this.buffer.release();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Buffer {
        protected Object[] buf;
        protected int in = 0;
        protected int out = 0;
        protected int count = 0;
        protected int size;

        public Buffer(int size) {
            this.size = size;
            this.buf = new Object[size];
        }

        public synchronized void put(Object o) throws InterruptedException {
            while (this.count == this.size) {
                this.wait();
                if (!TaskThread.this.stop) continue;
                return;
            }
            this.buf[this.in] = o;
            ++this.count;
            this.in = (this.in + 1) % this.size;
            this.notify();
        }

        public synchronized Object get() throws InterruptedException {
            while (this.count == 0) {
                this.wait();
                if (!TaskThread.this.stop) continue;
                return null;
            }
            Object o = this.buf[this.out];
            this.buf[this.out] = null;
            --this.count;
            this.out = (this.out + 1) % this.size;
            this.notify();
            return o;
        }

        public synchronized void release() {
            this.notify();
        }
    }
}

