/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.vanilla;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;
import org.globus.common.CoGProperties;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.HostPort;
import org.globus.ftp.Options;
import org.globus.ftp.Session;
import org.globus.ftp.dc.ActiveConnectTask;
import org.globus.ftp.dc.ActiveStartTransferTask;
import org.globus.ftp.dc.DataChannelFactory;
import org.globus.ftp.dc.LocalReply;
import org.globus.ftp.dc.PassiveConnectTask;
import org.globus.ftp.dc.SimpleDataChannelFactory;
import org.globus.ftp.dc.SimpleTransferContext;
import org.globus.ftp.dc.SocketBox;
import org.globus.ftp.dc.Task;
import org.globus.ftp.dc.TaskThread;
import org.globus.ftp.dc.TransferContext;
import org.globus.ftp.exception.FTPReplyParseException;
import org.globus.ftp.exception.ServerException;
import org.globus.ftp.vanilla.BasicClientControlChannel;
import org.globus.ftp.vanilla.BasicServerControlChannel;
import org.globus.ftp.vanilla.Flag;
import org.globus.ftp.vanilla.Reply;

public class FTPServerFacade {
    private static Logger logger = Logger.getLogger((String)(class$org$globus$ftp$vanilla$FTPServerFacade == null ? (class$org$globus$ftp$vanilla$FTPServerFacade = FTPServerFacade.class$("org.globus.ftp.vanilla.FTPServerFacade")) : class$org$globus$ftp$vanilla$FTPServerFacade).getName());
    public static final int ANY_PORT = 0;
    public static final int DEFAULT_QUEUE = 100;
    protected Session session = new Session();
    protected LocalControlChannel localControlChannel = new LocalControlChannel();
    protected DataChannelFactory dataChannelFactory = new SimpleDataChannelFactory();
    protected ServerSocket server;
    protected TaskThread taskThread;
    protected SocketBox socketBox = new SocketBox();
    static /* synthetic */ Class class$org$globus$ftp$vanilla$FTPServerFacade;

    public static void cannotPropagateError(Throwable e) {
        logger.error((Object)("\n\nException occured in the exception handling code, so it cannot be properly propagated to the user:\n " + e.toString()));
        e.printStackTrace();
    }

    public BasicClientControlChannel getControlChannel() {
        return this.localControlChannel;
    }

    public Session getSession() {
        return this.session;
    }

    public void authorize() {
        this.session.authorized = true;
    }

    public void setTransferType(int type) {
        this.session.transferType = type;
    }

    public void setTransferMode(int mode) {
        this.session.transferMode = mode;
    }

    public void setProtectionBufferSize(int size) {
        this.session.protectionBufferSize = size;
    }

    public void setOptions(Options opts) {
    }

    public HostPort setPassive() throws IOException {
        return this.setPassive(0, 100);
    }

    public HostPort setPassive(int port, int queue) throws IOException {
        if (this.server == null) {
            this.server = new ServerSocket(port, queue);
        }
        this.session.serverMode = 1;
        this.session.serverAddress = new HostPort(FTPServerFacade.getLocalHostAddress(), this.server.getLocalPort());
        logger.debug((Object)("started passive server at port " + this.session.serverAddress.getPort()));
        return this.session.serverAddress;
    }

    public void setActive(HostPort hp) throws UnknownHostException, IOException {
        logger.debug((Object)"connecting active socket");
        logger.debug((Object)("host port: " + hp.toFtpCmdArgument()));
        this.session.serverMode = 2;
        this.runTask(this.createActiveConnectTask(hp, this.socketBox));
    }

    protected void exceptionToControlChannel(Throwable e, String msg) {
        FTPServerFacade.exceptionToControlChannel(e, msg, this.localControlChannel);
    }

    public static void exceptionToControlChannel(Throwable e, String msg, BasicServerControlChannel control) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        String stack = writer.toString();
        LocalReply reply = new LocalReply(451, msg + "\n" + e.toString() + "\n" + stack);
        control.write(reply);
    }

    public void store(DataSink sink) {
        try {
            this.localControlChannel.resetReplyCount();
            TransferContext context = this.createTransferContext();
            if (this.session.serverMode == 1) {
                this.runTask(this.createPassiveConnectTask(sink, context));
            } else {
                this.runTask(this.createActiveStartTransferTask(sink, this.socketBox, context));
            }
        }
        catch (Exception e) {
            this.exceptionToControlChannel(e, "ocurred during store()");
        }
    }

    public void retrieve(DataSource source) {
        try {
            this.localControlChannel.resetReplyCount();
            TransferContext context = this.createTransferContext();
            if (this.session.serverMode == 1) {
                this.runTask(this.createPassiveConnectTask(source, context));
            } else {
                this.runTask(this.createActiveStartTransferTask(source, this.socketBox, context));
            }
        }
        catch (Exception e) {
            this.exceptionToControlChannel(e, "ocurred during retrieve()");
        }
    }

    public void abort() throws IOException {
        if (this.socketBox != null && this.socketBox.getSocket() != null) {
            this.socketBox.getSocket().close();
            logger.debug((Object)"data channel socket closed");
        }
    }

    public void close() throws IOException {
        logger.debug((Object)"stop master thread");
        if (this.taskThread != null) {
            this.taskThread.stop();
            logger.debug((Object)"wait for master thread to finish");
            TaskThread taskThread = this.taskThread;
            synchronized (taskThread) {
                try {
                    if (this.taskThread.isRunning()) {
                        this.taskThread.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        logger.debug((Object)"close data channels");
        this.abort();
        logger.debug((Object)"close server socket");
        if (this.server != null) {
            this.server.close();
            logger.debug((Object)"server socket closed");
        }
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception intercepted by finalize():");
            logger.warn((Object)e.toString());
        }
    }

    protected static String getLocalHostAddress() {
        String ipAddr = CoGProperties.getDefault().getIPAddress();
        if (ipAddr == null) {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                return "127.0.0.1";
            }
        }
        return ipAddr;
    }

    protected void runTask(Task task) {
        if (this.taskThread == null) {
            this.taskThread = new TaskThread();
        }
        this.taskThread.runTask(task);
    }

    protected ActiveConnectTask createActiveConnectTask(HostPort hp, SocketBox box) {
        return new ActiveConnectTask(hp, this.localControlChannel, box);
    }

    protected PassiveConnectTask createPassiveConnectTask(DataSource source, TransferContext context) {
        return new PassiveConnectTask(this.server, source, (BasicServerControlChannel)this.localControlChannel, this.session, this.dataChannelFactory, context);
    }

    protected PassiveConnectTask createPassiveConnectTask(DataSink sink, TransferContext context) {
        return new PassiveConnectTask(this.server, sink, (BasicServerControlChannel)this.localControlChannel, this.session, this.dataChannelFactory, context);
    }

    protected ActiveStartTransferTask createActiveStartTransferTask(DataSource source, SocketBox box, TransferContext context) {
        return new ActiveStartTransferTask(source, (BasicServerControlChannel)this.localControlChannel, box, this.session, this.dataChannelFactory, context);
    }

    protected ActiveStartTransferTask createActiveStartTransferTask(DataSink sink, SocketBox box, TransferContext context) {
        return new ActiveStartTransferTask(sink, (BasicServerControlChannel)this.localControlChannel, box, this.session, this.dataChannelFactory, context);
    }

    protected TransferContext createTransferContext() {
        return SimpleTransferContext.getDefault();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class LocalControlChannel
    extends BasicClientControlChannel
    implements BasicServerControlChannel {
        private Reply reply = null;
        private int replyCount = 0;

        protected synchronized void push(Reply newReply) {
            try {
                logger.debug((Object)("push reply:" + newReply.toString()));
                try {
                    while (this.reply != null) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    logger.debug((Object)"interrupted exception ignored");
                }
                this.reply = newReply;
                ++this.replyCount;
                this.notify();
                logger.debug((Object)"pushed");
            }
            catch (Exception e) {
                logger.warn((Object)"Local server error ocurred while writing reply to the local control channel!");
                logger.warn((Object)e.toString());
                logger.warn((Object)"Some information may be lost.");
            }
        }

        protected synchronized Reply pop() {
            logger.debug((Object)"pop reply");
            try {
                while (this.reply == null) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Reply returning = this.reply;
            this.reply = null;
            this.notify();
            logger.debug((Object)"popped");
            return returning;
        }

        public synchronized boolean ready() {
            return this.reply != null;
        }

        public int getReplyCount() {
            return this.replyCount;
        }

        public void resetReplyCount() {
            this.replyCount = 0;
        }

        public Reply read() throws IOException, FTPReplyParseException {
            return this.pop();
        }

        public void write(Reply reply) {
            logger.debug((Object)"writing reply");
            this.push(reply);
            logger.debug((Object)"wrote reply");
        }

        public void waitFor(Flag aborted, int ioDelay, int maxWait) throws ServerException, IOException, InterruptedException {
            int i = 0;
            logger.debug((Object)"waiting for reply in local control channel");
            while (!this.ready()) {
                if (aborted.flag) {
                    throw new InterruptedException();
                }
                logger.debug((Object)("slept " + i));
                Thread.sleep(ioDelay);
                if (maxWait == -1 || (i += ioDelay) < maxWait) continue;
                logger.debug((Object)"timeout");
                throw new ServerException(4);
            }
            logger.debug((Object)"local control channel ready");
        }
    }
}

