/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.vanilla;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.log4j.Logger;
import org.globus.ftp.GridFTPRestartMarker;
import org.globus.ftp.MarkerListener;
import org.globus.ftp.PerfMarker;
import org.globus.ftp.exception.FTPReplyParseException;
import org.globus.ftp.exception.ServerException;
import org.globus.ftp.exception.UnexpectedReplyCodeException;
import org.globus.ftp.vanilla.BasicClientControlChannel;
import org.globus.ftp.vanilla.Flag;
import org.globus.ftp.vanilla.Reply;
import org.globus.ftp.vanilla.TransferState;

public class TransferMonitor
extends Thread {
    public static int LOCAL = 1;
    public static int REMOTE = 2;
    private int side;
    private Logger logger = null;
    private int maxWait;
    private int ioDelay;
    private BasicClientControlChannel controlChannel;
    private TransferState transferState;
    private MarkerListener mListener;
    private TransferMonitor other;
    private boolean abortable;
    private Flag aborted = new Flag();
    static /* synthetic */ Class class$org$globus$ftp$GridFTPClient;

    public TransferMonitor(BasicClientControlChannel controlChannel, TransferState transferState, MarkerListener mListener, int maxWait, int ioDelay, int side) {
        this.logger = Logger.getLogger((String)((class$org$globus$ftp$GridFTPClient == null ? (class$org$globus$ftp$GridFTPClient = TransferMonitor.class$("org.globus.ftp.GridFTPClient")) : class$org$globus$ftp$GridFTPClient).getName() + "." + "thread." + (side == LOCAL ? "local" : "remot")));
        this.controlChannel = controlChannel;
        this.transferState = transferState;
        this.mListener = mListener;
        this.maxWait = maxWait;
        this.ioDelay = ioDelay;
        this.abortable = true;
        this.aborted.flag = false;
        this.side = side;
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setOther(TransferMonitor other) {
        this.other = other;
    }

    public void abort() {
        this.logger.debug((Object)"abort");
        if (!this.abortable) {
            return;
        }
        this.interrupt();
        this.aborted.flag = true;
    }

    public void run() {
        block15: {
            try {
                try {
                    if (this.transferState.hasError()) {
                        this.logger.debug((Object)"the other thread terminated before this one started.");
                        throw new InterruptedException();
                    }
                    Object reply = null;
                    this.logger.debug((Object)("waiting for 1st reply;  maxWait = " + this.maxWait + ", ioDelay = " + this.ioDelay));
                    this.controlChannel.waitFor(this.aborted, this.ioDelay, this.maxWait);
                    this.logger.debug((Object)"reading first reply");
                    Reply firstReply = this.controlChannel.read();
                    if (Reply.isPositivePreliminary(firstReply)) {
                        Reply nextReply;
                        this.transferState.transferStarted();
                        this.logger.debug((Object)("first reply OK: " + firstReply.toString()));
                        while (true) {
                            this.logger.debug((Object)"reading next reply");
                            this.controlChannel.waitFor(this.aborted, this.ioDelay);
                            this.logger.debug((Object)"got next reply");
                            nextReply = this.controlChannel.read();
                            if (nextReply.getCode() == 112) {
                                this.logger.debug((Object)("marker arrived: " + nextReply.toString()));
                                if (this.mListener == null) continue;
                                this.mListener.markerArrived(new PerfMarker(nextReply.getMessage()));
                                continue;
                            }
                            if (nextReply.getCode() != 111) break;
                            this.logger.debug((Object)("marker arrived: " + nextReply.toString()));
                            if (this.mListener == null) continue;
                            this.mListener.markerArrived(new GridFTPRestartMarker(nextReply.getMessage()));
                        }
                        if (nextReply.getCode() == 226) {
                            this.abortable = false;
                            this.logger.debug((Object)("transfer complete: " + nextReply.toString()));
                        } else {
                            this.logger.debug((Object)("unexpected reply: " + nextReply.toString()));
                            this.logger.debug((Object)"exiting the transfer thread");
                            ServerException e = ServerException.embedUnexpectedReplyCodeException(new UnexpectedReplyCodeException(nextReply), "Server reported transfer failure");
                            this.transferState.transferError(e);
                            this.other.abort();
                        }
                    } else {
                        this.logger.debug((Object)("first reply bad: " + firstReply.toString()));
                        this.logger.debug((Object)("category: " + firstReply.getCategory()));
                        this.abortable = false;
                        ServerException e = ServerException.embedUnexpectedReplyCodeException(new UnexpectedReplyCodeException(firstReply));
                        this.transferState.transferError(e);
                        this.other.abort();
                    }
                    this.logger.debug((Object)"thread dying naturally");
                }
                catch (InterruptedException td) {
                    this.logger.debug((Object)"thread dying of InterruptedException.");
                    this.transferState.transferError(td);
                    Object var7_11 = null;
                    this.transferState.transferDone();
                    break block15;
                }
                catch (InterruptedIOException td) {
                    this.logger.debug((Object)"thread dying of InterruptedIOException.");
                    this.transferState.transferError(td);
                    Object var7_12 = null;
                    this.transferState.transferDone();
                    break block15;
                }
                catch (IOException e) {
                    this.logger.debug((Object)"thread dying of IOException");
                    this.transferState.transferError(e);
                    this.other.abort();
                    Object var7_13 = null;
                    this.transferState.transferDone();
                    break block15;
                }
                catch (FTPReplyParseException rpe) {
                    this.logger.debug((Object)"thread dying of FTPReplyParseException");
                    ServerException se = ServerException.embedFTPReplyParseException(rpe);
                    this.transferState.transferError(se);
                    this.other.abort();
                    Object var7_14 = null;
                    this.transferState.transferDone();
                    break block15;
                }
                catch (ServerException e) {
                    this.logger.debug((Object)"thread dying of timeout");
                    this.transferState.transferError(e);
                    this.other.abort();
                    Object var7_15 = null;
                    this.transferState.transferDone();
                }
                Object var7_10 = null;
                this.transferState.transferDone();
            }
            catch (Throwable throwable) {
                Object var7_16 = null;
                this.transferState.transferDone();
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

