/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gram;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.globus.common.ResourceManagerContact;
import org.globus.gram.CallbackHandler;
import org.globus.gram.GramException;
import org.globus.gram.GramJob;
import org.globus.gram.WaitingForCommitException;
import org.globus.gram.internal.GRAMProtocol;
import org.globus.gram.internal.GatekeeperReply;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.globus.gsi.gssapi.auth.IdentityAuthorization;
import org.globus.gsi.gssapi.auth.SelfAuthorization;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.globus.util.GlobusURL;
import org.globus.util.deactivator.DeactivationHandler;
import org.globus.util.deactivator.Deactivator;
import org.globus.util.http.HttpResponse;
import org.globus.util.log4j.CoGLevel;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class Gram {
    private static Logger logger = Logger.getLogger((String)(class$org$globus$gram$Gram == null ? (class$org$globus$gram$Gram = Gram.class$("org.globus.gram.Gram")) : class$org$globus$gram$Gram).getName());
    protected static Hashtable callbackHandlers = new Hashtable();
    static /* synthetic */ Class class$org$globus$gram$Gram;

    private static Socket gatekeeperConnect(GSSCredential cred, ResourceManagerContact rmc, boolean doDel, boolean limitedDelegation) throws GSSException, GramException {
        GSSManager manager = ExtendedGSSManager.getInstance();
        try {
            ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext(null, GSSConstants.MECH_OID, cred, 0);
            context.requestCredDeleg(doDel);
            context.setOption(GSSConstants.DELEGATION_TYPE, limitedDelegation ? GSIConstants.DELEGATION_TYPE_LIMITED : GSIConstants.DELEGATION_TYPE_FULL);
            GssSocketFactory factory = GssSocketFactory.getDefault();
            GssSocket socket = (GssSocket)factory.createSocket(rmc.getHostName(), rmc.getPortNumber(), context);
            String authDN = rmc.getDN();
            if (authDN != null) {
                socket.setAuthorization(new IdentityAuthorization(authDN));
            } else {
                socket.setAuthorization(HostAuthorization.getInstance());
            }
            return socket;
        }
        catch (IOException e) {
            throw new GramException(12, (Throwable)e);
        }
    }

    private static void checkProtocolVersion(int protocolVersion) throws GramException {
        if (protocolVersion != 2) {
            throw new GramException(49);
        }
    }

    private static void checkHttpReply(int code) throws GramException {
        if (code == 200) {
            return;
        }
        if (code == 400) {
            throw new GramException(10);
        }
        if (code == 403) {
            throw new GramException(7);
        }
        if (code == 404) {
            throw new GramException(93);
        }
        if (code == 500) {
            throw new GramException(47);
        }
        throw new GramException(89);
    }

    public static int getActiveJobs() {
        int jobs = 0;
        Enumeration enumeration = callbackHandlers.elements();
        while (enumeration.hasMoreElements()) {
            CallbackHandler handler = (CallbackHandler)enumeration.nextElement();
            jobs += handler.getRegisteredJobsSize();
        }
        return jobs;
    }

    public static int getActiveJobs(GSSCredential cred) {
        if (cred == null) {
            throw new IllegalArgumentException("cred == null");
        }
        CallbackHandler handler = (CallbackHandler)callbackHandlers.get(cred);
        return handler == null ? 0 : handler.getRegisteredJobsSize();
    }

    public static void ping(String resourceManagerContact) throws GramException, GSSException {
        Gram.ping(null, resourceManagerContact);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void ping(GSSCredential cred, String resourceManagerContact) throws GramException, GSSException {
        ResourceManagerContact rmc = new ResourceManagerContact(resourceManagerContact);
        Socket socket = Gram.gatekeeperConnect(cred, rmc, false, false);
        HttpResponse hd = null;
        try {
            try {
                OutputStream out = socket.getOutputStream();
                InputStream in = socket.getInputStream();
                String msg = GRAMProtocol.PING(rmc.getServiceName(), rmc.getHostName());
                out.write(msg.getBytes());
                out.flush();
                Gram.debug("PG SENT:", msg);
                hd = new HttpResponse(in);
            }
            catch (IOException e) {
                throw new GramException(10, (Throwable)e);
            }
            Object var9_9 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                socket.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        socket.close();
        Gram.debug("PG RECEIVED:", hd);
        Gram.checkHttpReply(hd.httpCode);
    }

    public static void request(String resourceManagerContact, GramJob job) throws GramException, GSSException {
        Gram.request(resourceManagerContact, job, false);
    }

    public static void request(String resourceManagerContact, GramJob job, boolean batchJob) throws GramException, GSSException {
        Gram.request(resourceManagerContact, job, batchJob, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void request(String resourceManagerContact, GramJob job, boolean batchJob, boolean limitedDelegation) throws GramException, GSSException {
        GSSCredential cred = Gram.getJobCredentials(job);
        String callbackURL = null;
        CallbackHandler handler = null;
        if (!batchJob) {
            handler = Gram.initCallbackHandler(cred);
            callbackURL = handler.getURL();
            logger.debug((Object)("Callback url: " + callbackURL));
        } else {
            callbackURL = "\"\"";
        }
        ResourceManagerContact rmc = new ResourceManagerContact(resourceManagerContact);
        Socket socket = Gram.gatekeeperConnect(cred, rmc, true, limitedDelegation);
        GatekeeperReply hd = null;
        try {
            try {
                OutputStream out = socket.getOutputStream();
                InputStream in = socket.getInputStream();
                String msg = GRAMProtocol.REQUEST(rmc.getServiceName(), rmc.getHostName(), 65535, callbackURL, job.getRSL());
                out.write(msg.getBytes());
                out.flush();
                Gram.debug("REQ SENT:", msg);
                hd = new GatekeeperReply(in);
            }
            catch (IOException e) {
                throw new GramException(10, (Throwable)e);
            }
            Object var14_15 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            try {
                socket.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        socket.close();
        Gram.debug("REQ RECEIVED:", hd);
        Gram.checkHttpReply(hd.httpCode);
        Gram.checkProtocolVersion(hd.protocolVersion);
        if (hd.status != 0) {
            if (hd.status != 110) throw new GramException(hd.status);
        }
        try {
            job.setID(hd.jobManagerUrl);
        }
        catch (MalformedURLException ex) {
            throw new GramException(80, (Throwable)ex);
        }
        if (!batchJob) {
            handler.registerJob(job);
        }
        if (hd.status != 110) return;
        throw new WaitingForCommitException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static GatekeeperReply jmConnect(GSSCredential cred, GlobusURL jobURL, String msg) throws GramException, GSSException {
        GatekeeperReply reply;
        block7: {
            GSSManager manager = ExtendedGSSManager.getInstance();
            reply = null;
            GssSocket socket = null;
            try {
                try {
                    ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext(null, GSSConstants.MECH_OID, cred, 0);
                    context.setOption(GSSConstants.GSS_MODE, GSIConstants.MODE_SSL);
                    GssSocketFactory factory = GssSocketFactory.getDefault();
                    socket = (GssSocket)factory.createSocket(jobURL.getHost(), jobURL.getPort(), context);
                    socket.setAuthorization(SelfAuthorization.getInstance());
                    OutputStream out = socket.getOutputStream();
                    InputStream in = socket.getInputStream();
                    out.write(msg.getBytes());
                    out.flush();
                    Gram.debug("JM SENT:", msg);
                    reply = new GatekeeperReply(in);
                }
                catch (IOException e) {
                    throw new GramException(12, (Throwable)e);
                }
                Object var11_11 = null;
                if (socket == null) break block7;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (socket == null) throw throwable;
                try {
                    socket.close();
                    throw throwable;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception e) {}
            socket.close();
        }
        Gram.debug("JM RECEIVED:", reply);
        Gram.checkHttpReply(reply.httpCode);
        Gram.checkProtocolVersion(reply.protocolVersion);
        return reply;
    }

    public static void cancel(GramJob job) throws GramException, GSSException {
        GlobusURL jobURL = job.getID();
        if (jobURL == null) {
            throw new GramException(1003);
        }
        GSSCredential cred = Gram.getJobCredentials(job);
        String msg = GRAMProtocol.CANCEL_JOB(jobURL.getURL(), jobURL.getHost());
        GatekeeperReply reply = Gram.jmConnect(cred, jobURL, msg);
    }

    public static void jobStatus(GramJob job) throws GramException, GSSException {
        GlobusURL jobURL = job.getID();
        GSSCredential cred = Gram.getJobCredentials(job);
        String msg = GRAMProtocol.STATUS_POLL(jobURL.getURL(), jobURL.getHost());
        GatekeeperReply hd = null;
        try {
            hd = Gram.jmConnect(cred, jobURL, msg);
        }
        catch (GramException e) {
            if (e.getErrorCode() == 12) {
                job.setError(79);
                e.setErrorCode(79);
            }
            throw e;
        }
        job.setStatus(hd.status);
        job.setError(hd.failureCode);
    }

    public static int jobSignal(GramJob job, int signal, String arg) throws GramException, GSSException {
        GlobusURL jobURL = job.getID();
        GSSCredential cred = Gram.getJobCredentials(job);
        String msg = GRAMProtocol.SIGNAL(jobURL.getURL(), jobURL.getHost(), signal, arg);
        GatekeeperReply hd = null;
        hd = Gram.jmConnect(cred, jobURL, msg);
        switch (signal) {
            case 4: {
                return hd.failureCode;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                if (hd.failureCode != 0 && hd.status == 4) {
                    throw new GramException(hd.failureCode);
                }
                if (hd.failureCode == 0 && hd.jobFailureCode != 0) {
                    job.setError(hd.jobFailureCode);
                    job.setStatus(4);
                    return hd.failureCode;
                }
                job.setStatus(hd.status);
                return 0;
            }
        }
        job.setStatus(hd.status);
        job.setError(hd.failureCode);
        return 0;
    }

    public static void registerListener(GramJob job) throws GramException, GSSException {
        GSSCredential cred = Gram.getJobCredentials(job);
        CallbackHandler handler = Gram.initCallbackHandler(cred);
        Gram.registerListener(job, handler);
    }

    public static void registerListener(GramJob job, CallbackHandler handler) throws GramException, GSSException {
        GSSCredential cred = Gram.getJobCredentials(job);
        String callbackURL = handler.getURL();
        GlobusURL jobURL = job.getID();
        String msg = GRAMProtocol.REGISTER_CALLBACK(jobURL.getURL(), jobURL.getHost(), 65535, callbackURL);
        GatekeeperReply hd = Gram.jmConnect(cred, jobURL, msg);
        if (hd.failureCode != 0) {
            throw new GramException(hd.failureCode);
        }
        handler.registerJob(job);
    }

    public static void unregisterListener(GramJob job) throws GramException, GSSException {
        GSSCredential cred = Gram.getJobCredentials(job);
        CallbackHandler handler = Gram.initCallbackHandler(cred);
        Gram.unregisterListener(job, handler);
    }

    public static void unregisterListener(GramJob job, CallbackHandler handler) throws GramException, GSSException {
        GSSCredential cred = Gram.getJobCredentials(job);
        GlobusURL jobURL = job.getID();
        String msg = GRAMProtocol.UNREGISTER_CALLBACK(jobURL.getURL(), jobURL.getHost(), handler.getURL());
        GatekeeperReply reply = Gram.jmConnect(cred, jobURL, msg);
        handler.unregisterJob(job);
    }

    public static void deactivateAllCallbackHandlers() {
        Hashtable hashtable = callbackHandlers;
        synchronized (hashtable) {
            Enumeration enumeration = callbackHandlers.elements();
            while (enumeration.hasMoreElements()) {
                CallbackHandler handler = (CallbackHandler)enumeration.nextElement();
                handler.shutdown();
            }
            callbackHandlers.clear();
        }
    }

    public static CallbackHandler deactivateCallbackHandler(GSSCredential cred) {
        if (cred == null) {
            return null;
        }
        CallbackHandler handler = (CallbackHandler)callbackHandlers.remove(cred);
        if (handler == null) {
            return null;
        }
        handler.shutdown();
        return handler;
    }

    private static CallbackHandler initCallbackHandler(GSSCredential cred) throws GSSException, GramException {
        if (cred == null) {
            throw new IllegalArgumentException("cred == null");
        }
        CallbackHandler handler = (CallbackHandler)callbackHandlers.get(cred);
        if (handler == null) {
            try {
                handler = new CallbackHandler(cred, 0);
                callbackHandlers.put(cred, handler);
            }
            catch (IOException e) {
                throw new GramException(1000, (Throwable)e);
            }
        }
        return handler;
    }

    private static GSSCredential getJobCredentials(GramJob job) throws GSSException {
        GSSCredential cred = job.getCredentials();
        if (cred == null) {
            GSSManager manager = ExtendedGSSManager.getInstance();
            cred = manager.createCredential(0);
            job.setCredentials(cred);
        }
        return cred;
    }

    private static void debug(String header, GatekeeperReply reply) {
        if (logger.isEnabledFor((Priority)CoGLevel.TRACE)) {
            logger.log((Priority)CoGLevel.TRACE, (Object)header);
            logger.log((Priority)CoGLevel.TRACE, (Object)reply.toString());
        }
    }

    private static void debug(String header, HttpResponse response) {
        if (logger.isEnabledFor((Priority)CoGLevel.TRACE)) {
            logger.log((Priority)CoGLevel.TRACE, (Object)header);
            logger.log((Priority)CoGLevel.TRACE, (Object)response.toString());
        }
    }

    private static void debug(String header, String msg) {
        if (logger.isEnabledFor((Priority)CoGLevel.TRACE)) {
            logger.log((Priority)CoGLevel.TRACE, (Object)header);
            logger.log((Priority)CoGLevel.TRACE, (Object)msg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Deactivator.registerDeactivation(new DeactivationHandler(){

            public void deactivate() {
                Gram.deactivateAllCallbackHandlers();
            }
        });
    }
}

