/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSException;
import org.globus.gsi.gssapi.GlobusGSSManagerImpl;
import org.globus.gsi.gssapi.GlobusGSSName;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class GlobusGSSCredentialImpl
implements ExtendedGSSCredential {
    private int usage = 0;
    private GlobusCredential cred;
    private GSSName name;

    public GlobusGSSCredentialImpl() {
        this.cred = null;
        this.name = new GlobusGSSName();
    }

    public GlobusGSSCredentialImpl(GlobusCredential cred, int usage) throws GSSException {
        if (cred == null) {
            throw new IllegalArgumentException("cred == null");
        }
        this.cred = cred;
        this.usage = usage;
        this.name = new GlobusGSSName(cred.getIdentity());
    }

    public void dispose() throws GSSException {
        this.cred = null;
    }

    public GSSName getName() throws GSSException {
        return this.name;
    }

    public GSSName getName(Oid mech) throws GSSException {
        GlobusGSSManagerImpl.checkMechanism(mech);
        return this.name;
    }

    public void add(GSSName aName, int initLifetime, int acceptLifetime, Oid mech, int usage) throws GSSException {
        throw new GSSException(16);
    }

    public int getUsage() throws GSSException {
        return this.usage;
    }

    public int getUsage(Oid mech) throws GSSException {
        GlobusGSSManagerImpl.checkMechanism(mech);
        return this.usage;
    }

    public int getRemainingLifetime() throws GSSException {
        return this.cred == null ? -1 : (int)this.cred.getTimeLeft();
    }

    public int getRemainingInitLifetime(Oid mech) throws GSSException {
        GlobusGSSManagerImpl.checkMechanism(mech);
        if (this.usage == 1 || this.usage == 0) {
            return this.getRemainingLifetime();
        }
        throw new GSSException(11);
    }

    public int getRemainingAcceptLifetime(Oid mech) throws GSSException {
        GlobusGSSManagerImpl.checkMechanism(mech);
        if (this.usage == 2 || this.usage == 0) {
            return this.getRemainingLifetime();
        }
        throw new GSSException(11);
    }

    public Oid[] getMechs() throws GSSException {
        return GlobusGSSManagerImpl.MECHS;
    }

    public byte[] export(int option) throws GSSException {
        return this.export(option, null);
    }

    /*
     * Unable to fully structure code
     */
    public byte[] export(int option, Oid mech) throws GSSException {
        GlobusGSSManagerImpl.checkMechanism(mech);
        if (this.cred == null) {
            throw new GlobusGSSException(11, 27, "anonCred00");
        }
        switch (option) {
            case 0: {
                bout = new ByteArrayOutputStream();
                try {
                    this.cred.save(bout);
                }
                catch (IOException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                return bout.toByteArray();
            }
            case 1: {
                file = null;
                fout = null;
                try {
                    file = File.createTempFile("x509up_", ".tmp");
                    fout = new FileOutputStream(file);
                    this.cred.save(fout);
                    var8_7 = null;
                    ** if (fout == null) goto lbl-1000
                }
                catch (Throwable var7_13) {
                    var8_8 = null;
                    if (fout != null) {
                        try {
                            fout.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    throw var7_13;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        fout.close();
                    }
                    catch (Exception e) {}
                }
lbl-1000:
                // 2 sources

                {
                    ** GOTO lbl41
                    catch (IOException e) {
                        throw new GlobusGSSException(11, (Throwable)e);
                    }
                }
lbl41:
                // 2 sources

                handle = "X509_USER_PROXY=" + file.getAbsolutePath();
                return handle.getBytes();
            }
        }
        throw new GlobusGSSException(11, 7, "unknownOption", new Object[]{new Integer(option)});
    }

    public GlobusCredential getGlobusCredential() {
        return this.cred;
    }

    public PrivateKey getPrivateKey() {
        return this.cred == null ? null : this.cred.getPrivateKey();
    }

    public X509Certificate[] getCertificateChain() {
        return this.cred == null ? null : this.cred.getCertificateChain();
    }
}

