/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;
import org.globus.common.ChainedIOException;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.SelfAuthorization;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;

public abstract class GssSocket
extends Socket {
    private static Logger logger = Logger.getLogger((String)(class$org$globus$gsi$gssapi$net$GssSocket == null ? (class$org$globus$gsi$gssapi$net$GssSocket = GssSocket.class$("org.globus.gsi.gssapi.net.GssSocket")) : class$org$globus$gsi$gssapi$net$GssSocket).getName());
    protected GSSContext context;
    protected Socket socket;
    protected boolean clientMode;
    protected InputStream in;
    protected OutputStream out;
    protected Authorization authorization = SelfAuthorization.getInstance();
    public static final int SSL_MODE = 1;
    public static final int GSI_MODE = 2;
    protected int mode = -1;
    static /* synthetic */ Class class$org$globus$gsi$gssapi$net$GssSocket;

    public GssSocket(String host, int port, GSSContext context) throws IOException {
        this(new Socket(host, port), context);
    }

    public GssSocket(Socket socket, GSSContext context) {
        this.context = context;
        this.socket = socket;
        this.clientMode = true;
    }

    public void setAuthorization(Authorization auth) {
        this.authorization = auth;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public void setUseClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public boolean getClientMode() {
        return this.clientMode;
    }

    public void setWrapMode(int mode) {
        this.mode = mode;
    }

    public int getWrapMode() {
        return this.mode;
    }

    public GSSContext getContext() {
        return this.context;
    }

    protected abstract void writeToken(byte[] var1) throws IOException;

    protected abstract byte[] readToken() throws IOException;

    protected synchronized void authenticateClient() throws IOException, GSSException {
        byte[] outToken = null;
        byte[] inToken = new byte[]{};
        while (!this.context.isEstablished()) {
            outToken = this.context.initSecContext(inToken, 0, inToken.length);
            if (outToken != null) {
                this.writeToken(outToken);
            }
            if (this.context.isEstablished()) continue;
            inToken = this.readToken();
        }
    }

    protected synchronized void authenticateServer() throws IOException, GSSException {
        byte[] outToken = null;
        byte[] inToken = null;
        while (!this.context.isEstablished()) {
            inToken = this.readToken();
            outToken = this.context.acceptSecContext(inToken, 0, inToken.length);
            if (outToken == null) continue;
            this.writeToken(outToken);
        }
    }

    public synchronized void startHandshake() throws IOException {
        if (this.context.isEstablished()) {
            return;
        }
        logger.debug((Object)"Handshake start");
        try {
            if (this.clientMode) {
                this.authenticateClient();
            } else {
                this.authenticateServer();
            }
        }
        catch (GSSException e) {
            throw new ChainedIOException("Authentication failed", e);
        }
        logger.debug((Object)"Handshake end");
        if (this.authorization != null) {
            logger.debug((Object)"Performing authorization.");
            this.authorization.authorize(this.context, this.getInetAddress().getHostAddress());
        } else {
            logger.debug((Object)"Authorization not set");
        }
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        this.startHandshake();
        return this.out;
    }

    public synchronized InputStream getInputStream() throws IOException {
        this.startHandshake();
        return this.in;
    }

    public void close() throws IOException {
        try {
            try {
                this.context.dispose();
            }
            catch (GSSException e) {
                throw new ChainedIOException("dispose failed.", e);
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.socket.close();
            throw throwable;
        }
        this.socket.close();
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public boolean getKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    public int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.socket.setKeepAlive(on);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.socket.setReceiveBufferSize(size);
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.socket.setSendBufferSize(size);
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.socket.setSoLinger(on, linger);
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.socket.setTcpNoDelay(on);
    }

    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }

    public String toString() {
        return this.socket.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

