/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.proxy.ext;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.globus.gsi.proxy.ext.ProxyPolicy;

public class ProxyCertInfo
implements DEREncodable {
    public static final DERObjectIdentifier OID = new DERObjectIdentifier("1.3.6.1.4.1.3536.1.222");
    private DERInteger pathLenConstraint;
    private ProxyPolicy proxyPolicy;

    public ProxyCertInfo(ASN1Sequence seq) {
        if (seq.size() < 1) {
            throw new IllegalArgumentException("Invalid sequence");
        }
        int seqPos = 0;
        if (seq.getObjectAt(seqPos) instanceof DERInteger) {
            this.pathLenConstraint = (DERInteger)seq.getObjectAt(seqPos);
            ++seqPos;
        }
        ASN1Sequence policy = (ASN1Sequence)seq.getObjectAt(seqPos);
        this.proxyPolicy = new ProxyPolicy(policy);
    }

    public ProxyCertInfo(int pathLenConstraint, ProxyPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException();
        }
        this.pathLenConstraint = new DERInteger(pathLenConstraint);
        this.proxyPolicy = policy;
    }

    public ProxyCertInfo(ProxyPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException();
        }
        this.pathLenConstraint = null;
        this.proxyPolicy = policy;
    }

    public static ProxyCertInfo getInstance(Object obj) {
        if (obj instanceof ProxyCertInfo) {
            return (ProxyCertInfo)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new ProxyCertInfo((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public DERObject getDERObject() {
        DEREncodableVector vec = new DEREncodableVector();
        if (this.pathLenConstraint != null) {
            vec.add(this.pathLenConstraint);
        }
        vec.add(this.proxyPolicy.getDERObject());
        return new DERSequence(vec);
    }

    public ProxyPolicy getProxyPolicy() {
        return this.proxyPolicy;
    }

    public int getPathLenConstraint() {
        if (this.pathLenConstraint != null) {
            return this.pathLenConstraint.getValue().intValue();
        }
        return Integer.MAX_VALUE;
    }
}

