/*
 * Decompiled with CFR 0.152.
 */
package org.globus.io.streams;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.globus.io.gass.client.internal.GASSProtocol;
import org.globus.io.streams.GlobusInputStream;
import org.globus.util.http.HTTPChunkedInputStream;
import org.globus.util.http.HttpResponse;
import org.globus.util.log4j.CoGLevel;

public class HTTPInputStream
extends GlobusInputStream {
    private static Logger logger = Logger.getLogger((String)(class$org$globus$io$streams$HTTPInputStream == null ? (class$org$globus$io$streams$HTTPInputStream = HTTPInputStream.class$("org.globus.io.streams.HTTPInputStream")) : class$org$globus$io$streams$HTTPInputStream).getName());
    protected InputStream input;
    protected Socket socket;
    protected int size = -1;
    static /* synthetic */ Class class$org$globus$io$streams$HTTPInputStream;

    protected HTTPInputStream() {
    }

    public HTTPInputStream(String host, int port, String file) throws IOException {
        this.init(host, port, file);
    }

    protected void init(String host, int port, String file) throws IOException {
        this.socket = new Socket(host, port);
        this.get(host, file);
    }

    protected void get(String host, String file) throws IOException {
        this.input = this.socket.getInputStream();
        OutputStream out = this.socket.getOutputStream();
        HttpResponse hd = null;
        String msg = GASSProtocol.GET(file, host);
        try {
            out.write(msg.getBytes());
            out.flush();
            if (logger.isEnabledFor((Priority)CoGLevel.TRACE)) {
                logger.log((Priority)CoGLevel.TRACE, (Object)("SENT: " + msg));
            }
            hd = new HttpResponse(this.input);
        }
        catch (IOException e) {
            this.abort();
            throw e;
        }
        if (hd.httpCode != 200) {
            this.abort();
            if (hd.httpCode == 404) {
                throw new FileNotFoundException("File " + file + " not found on the server.");
            }
            throw new IOException("Failed to retrieve file from server.  Server returned error: " + hd.httpMsg + " (" + hd.httpCode + ")");
        }
        if (hd.chunked) {
            this.input = new HTTPChunkedInputStream(this.input);
        } else if (hd.contentLength > 0) {
            this.size = hd.contentLength;
        } else {
            this.abort();
            throw new IOException("Failed to retrieve the file. Invalid reply received.");
        }
    }

    public void abort() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getSize() {
        return this.size;
    }

    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public int read(byte[] msg) throws IOException {
        return this.input.read(msg);
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        return this.input.read(buf, off, len);
    }

    public int read() throws IOException {
        return this.input.read();
    }

    public int available() throws IOException {
        return this.input.available();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

