/*
 * Decompiled with CFR 0.152.
 */
package org.globus.io.urlcopy;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.globus.ftp.DataChannelAuthentication;
import org.globus.ftp.FTPClient;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.exception.FTPException;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.globus.gsi.gssapi.auth.SelfAuthorization;
import org.globus.io.streams.FTPInputStream;
import org.globus.io.streams.FTPOutputStream;
import org.globus.io.streams.GassInputStream;
import org.globus.io.streams.GassOutputStream;
import org.globus.io.streams.GlobusFileInputStream;
import org.globus.io.streams.GlobusFileOutputStream;
import org.globus.io.streams.GlobusInputStream;
import org.globus.io.streams.GlobusOutputStream;
import org.globus.io.streams.GridFTPInputStream;
import org.globus.io.streams.GridFTPOutputStream;
import org.globus.io.streams.HTTPInputStream;
import org.globus.io.streams.HTTPOutputStream;
import org.globus.io.urlcopy.UrlCopyException;
import org.globus.io.urlcopy.UrlCopyListener;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;

public class UrlCopy
implements Runnable {
    private static Logger logger = Logger.getLogger((String)(class$org$globus$io$urlcopy$UrlCopy == null ? (class$org$globus$io$urlcopy$UrlCopy = UrlCopy.class$("org.globus.io.urlcopy.UrlCopy")) : class$org$globus$io$urlcopy$UrlCopy).getName());
    public static final int BUFF_SIZE = 2048;
    protected int bufferSize = 2048;
    protected GSSCredential srcCreds = null;
    protected Authorization srcAuth = null;
    protected GSSCredential dstCreds = null;
    protected Authorization dstAuth = null;
    protected boolean dcau = true;
    protected boolean appendMode = false;
    protected GlobusURL srcUrl = null;
    protected GlobusURL dstUrl = null;
    protected boolean canceled = false;
    protected boolean thirdParty = true;
    protected List listeners = null;
    static /* synthetic */ Class class$org$globus$io$urlcopy$UrlCopy;

    public void setDCAU(boolean dcau) {
        this.dcau = dcau;
    }

    public boolean getDCAU() {
        return this.dcau;
    }

    public void setCredentials(GSSCredential credentials) {
        this.setSourceCredentials(credentials);
        this.setDestinationCredentials(credentials);
    }

    public void setSourceCredentials(GSSCredential srcCredentials) {
        this.srcCreds = srcCredentials;
    }

    public void setDestinationCredentials(GSSCredential dstCredentials) {
        this.dstCreds = dstCredentials;
    }

    public void setSourceAuthorization(Authorization auth) {
        this.srcAuth = auth;
    }

    public void setDestinationAuthorization(Authorization auth) {
        this.dstAuth = auth;
    }

    public GSSCredential getSourceCredentials() {
        return this.srcCreds;
    }

    public GSSCredential getDestinationCredentials() {
        return this.dstCreds;
    }

    public Authorization getSourceAuthorization() {
        return this.srcAuth;
    }

    public Authorization getDestinationAuthorization() {
        return this.dstAuth;
    }

    public void addUrlCopyListener(UrlCopyListener listener) {
        if (this.listeners == null) {
            this.listeners = new LinkedList();
        }
        this.listeners.add(listener);
    }

    public void removeUrlCopyListener(UrlCopyListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setAppendMode(boolean appendMode) {
        this.appendMode = appendMode;
    }

    public boolean isAppendMode() {
        return this.appendMode;
    }

    private void checkUrl(GlobusURL url) throws UrlCopyException {
        String urlPath = url.getPath();
        if (urlPath == null || urlPath.length() == 0) {
            throw new UrlCopyException("The '" + url.getURL() + "' url does not specify the file location.");
        }
    }

    public void setSourceUrl(GlobusURL source) throws UrlCopyException {
        if (source == null) {
            throw new IllegalArgumentException("Source url cannot be null");
        }
        this.checkUrl(source);
        this.srcUrl = source;
    }

    public GlobusURL getSourceUrl() {
        return this.srcUrl;
    }

    public void setDestinationUrl(GlobusURL dest) throws UrlCopyException {
        if (dest == null) {
            throw new IllegalArgumentException("Desitination url cannot be null");
        }
        this.checkUrl(dest);
        this.dstUrl = dest;
    }

    public GlobusURL getDestinationUrl() {
        return this.dstUrl;
    }

    public void setUseThirdPartyCopy(boolean thirdParty) {
        this.thirdParty = thirdParty;
    }

    public void cancel() {
        this.canceled = true;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Iterator iter3;
        try {
            block10: {
                Iterator iter2;
                Exception e2;
                block11: {
                    try {
                        this.copy();
                    }
                    catch (Exception e2) {
                        if (this.listeners == null) break block10;
                        iter2 = this.listeners.iterator();
                        break block11;
                    }
                    Object var4_1 = null;
                    if (this.listeners == null) return;
                    Iterator iter3 = this.listeners.iterator();
                    while (iter3.hasNext()) {
                        ((UrlCopyListener)iter3.next()).transferCompleted();
                    }
                    return;
                }
                while (true) {
                    if (!iter2.hasNext()) {
                        break;
                    }
                    ((UrlCopyListener)iter2.next()).transferError(e2);
                }
            }
            Object var4_2 = null;
            if (this.listeners == null) return;
            Iterator iter3 = this.listeners.iterator();
            while (iter3.hasNext()) {
                ((UrlCopyListener)iter3.next()).transferCompleted();
            }
            return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (this.listeners == null) throw throwable;
            iter3 = this.listeners.iterator();
        }
        while (true) {
            if (!iter3.hasNext()) {
                throw throwable;
            }
            ((UrlCopyListener)iter3.next()).transferCompleted();
        }
    }

    public void copy() throws UrlCopyException {
        if (this.srcUrl == null) {
            throw new UrlCopyException("Source url is not specified");
        }
        if (this.dstUrl == null) {
            throw new UrlCopyException("Destination url is not specified");
        }
        String fromP = this.srcUrl.getProtocol();
        String toP = this.dstUrl.getProtocol();
        if (this.thirdParty && fromP.endsWith("ftp") && toP.endsWith("ftp")) {
            this.thirdPartyTransfer();
            return;
        }
        GlobusInputStream in = null;
        GlobusOutputStream out = null;
        boolean rs = false;
        try {
            in = this.getInputStream();
            int size = in.getSize();
            if (size == -1) {
                logger.info((Object)"Source size: unknown");
            } else {
                logger.info((Object)("Source size: " + size));
            }
            out = this.getOutputStream(size);
            rs = this.transfer(size, in, out);
            in.close();
            out.close();
        }
        catch (Exception e) {
            if (out != null) {
                out.abort();
            }
            if (in != null) {
                in.abort();
            }
            throw new UrlCopyException("UrlCopy transfer failed.", e);
        }
        if (!rs && this.isCanceled()) {
            throw new UrlCopyException("Transfer Aborted");
        }
    }

    protected GlobusInputStream getInputStream() throws Exception {
        GlobusInputStream in = null;
        String fromP = this.srcUrl.getProtocol();
        String fromFile = this.srcUrl.getPath();
        if (fromP.equalsIgnoreCase("file")) {
            in = new GlobusFileInputStream(fromFile);
        } else if (fromP.equalsIgnoreCase("ftp")) {
            in = new FTPInputStream(this.srcUrl.getHost(), this.srcUrl.getPort(), this.srcUrl.getUser(), this.srcUrl.getPwd(), fromFile);
        } else if (fromP.equalsIgnoreCase("gsiftp") || fromP.equalsIgnoreCase("gridftp")) {
            Authorization auth = this.getSourceAuthorization();
            if (auth == null) {
                auth = HostAuthorization.getInstance();
            }
            in = new GridFTPInputStream(this.getSourceCredentials(), auth, this.srcUrl.getHost(), this.srcUrl.getPort(), fromFile, this.getDCAU());
        } else if (fromP.equalsIgnoreCase("https")) {
            Authorization auth = this.getSourceAuthorization();
            if (auth == null) {
                auth = SelfAuthorization.getInstance();
            }
            in = new GassInputStream(this.getSourceCredentials(), auth, this.srcUrl.getHost(), this.srcUrl.getPort(), fromFile);
        } else if (fromP.equalsIgnoreCase("http")) {
            in = new HTTPInputStream(this.srcUrl.getHost(), this.srcUrl.getPort(), fromFile);
        } else {
            throw new Exception("Source protocol: " + fromP + " not supported!");
        }
        return in;
    }

    protected GlobusOutputStream getOutputStream(int size) throws Exception {
        GlobusOutputStream out = null;
        String toP = this.dstUrl.getProtocol();
        String toFile = this.dstUrl.getPath();
        if (toP.equalsIgnoreCase("file")) {
            out = new GlobusFileOutputStream(toFile, this.appendMode);
        } else if (toP.equalsIgnoreCase("ftp")) {
            out = new FTPOutputStream(this.dstUrl.getHost(), this.dstUrl.getPort(), this.dstUrl.getUser(), this.dstUrl.getPwd(), toFile, this.appendMode);
        } else if (toP.equalsIgnoreCase("gsiftp") || toP.equalsIgnoreCase("gridftp")) {
            Authorization auth = this.getDestinationAuthorization();
            if (auth == null) {
                auth = HostAuthorization.getInstance();
            }
            out = new GridFTPOutputStream(this.getDestinationCredentials(), auth, this.dstUrl.getHost(), this.dstUrl.getPort(), toFile, this.appendMode, this.getDCAU());
        } else if (toP.equalsIgnoreCase("https")) {
            Authorization auth = this.getDestinationAuthorization();
            if (auth == null) {
                auth = SelfAuthorization.getInstance();
            }
            out = new GassOutputStream(this.getDestinationCredentials(), auth, this.dstUrl.getHost(), this.dstUrl.getPort(), toFile, size, this.appendMode);
        } else if (toP.equalsIgnoreCase("http")) {
            out = new HTTPOutputStream(this.dstUrl.getHost(), this.dstUrl.getPort(), toFile, size, this.appendMode);
        } else {
            throw new Exception("Destination protocol: " + toP + " not supported!");
        }
        return out;
    }

    /*
     * Unable to fully structure code
     */
    private boolean transfer(int total, GlobusInputStream in, GlobusOutputStream out) throws IOException {
        block5: {
            buffer = new byte[this.bufferSize];
            bytes = 0;
            totalBytes = total;
            transferedBytes = 0;
            if (total != -1) ** GOTO lbl25
            while ((bytes = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytes);
                out.flush();
                if (this.listeners != null) {
                    this.fireUrlTransferProgressEvent(totalBytes, transferedBytes += bytes);
                }
                if (!this.isCanceled()) continue;
                return false;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                bytes = this.bufferSize;
                if (total < this.bufferSize) {
                    bytes = total;
                }
                bytes = in.read(buffer);
                out.write(buffer, 0, bytes);
                out.flush();
                total -= bytes;
                if (this.listeners != null) {
                    this.fireUrlTransferProgressEvent(totalBytes, transferedBytes += bytes);
                }
                if (!this.isCanceled()) continue;
                return false;
lbl25:
                // 2 sources

                ** while (total != 0)
            }
        }
        return true;
    }

    private void fireUrlTransferProgressEvent(int totalBytes, int transferedBytes) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((UrlCopyListener)iter.next()).transfer(transferedBytes, totalBytes);
        }
    }

    /*
     * Loose catch block
     */
    private void thirdPartyTransfer() throws UrlCopyException {
        block15: {
            Exception ee22;
            FTPClient dstFTP;
            FTPClient srcFTP;
            block14: {
                logger.info((Object)"Trying third party transfer...");
                srcFTP = null;
                dstFTP = null;
                srcFTP = this.createFTPConnection(this.srcUrl, true);
                dstFTP = this.createFTPConnection(this.dstUrl, false);
                this.negotiateDCAU(srcFTP, dstFTP);
                srcFTP.setType(1);
                srcFTP.setMode(1);
                dstFTP.setType(1);
                dstFTP.setMode(1);
                if (this.listeners != null) {
                    this.fireUrlTransferProgressEvent(-1, -1);
                }
                srcFTP.transfer(this.srcUrl.getPath(), dstFTP, this.dstUrl.getPath(), false, null);
                Object var5_3 = null;
                if (srcFTP == null) break block14;
                try {
                    srcFTP.close();
                }
                catch (Exception ee22) {
                    // empty catch block
                }
            }
            if (dstFTP != null) {
                try {
                    dstFTP.close();
                }
                catch (Exception ee22) {}
            }
            break block15;
            {
                catch (Exception e) {
                    throw new UrlCopyException("UrlCopy third party transfer failed.", e);
                }
            }
            catch (Throwable throwable) {
                Exception ee22;
                Object var5_4 = null;
                if (srcFTP != null) {
                    try {
                        srcFTP.close();
                    }
                    catch (Exception ee22) {
                        // empty catch block
                    }
                }
                if (dstFTP != null) {
                    try {
                        dstFTP.close();
                    }
                    catch (Exception ee22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    protected void negotiateDCAU(FTPClient src, FTPClient dst) throws IOException, FTPException {
        if (src instanceof GridFTPClient) {
            if (dst instanceof GridFTPClient) {
                GridFTPClient s = (GridFTPClient)src;
                GridFTPClient d = (GridFTPClient)dst;
                if (src.isFeatureSupported("DCAU") && dst.isFeatureSupported("DCAU")) {
                    UrlCopy.setDCAU(s, this.getDCAU());
                    UrlCopy.setDCAU(d, this.getDCAU());
                } else {
                    UrlCopy.setDCAU(s, false);
                    UrlCopy.setDCAU(d, false);
                    this.setDCAU(false);
                }
            } else {
                UrlCopy.setDCAU((GridFTPClient)src, false);
                this.setDCAU(false);
            }
        } else {
            if (dst instanceof GridFTPClient) {
                UrlCopy.setDCAU((GridFTPClient)dst, false);
            }
            this.setDCAU(false);
        }
    }

    private static void setDCAU(GridFTPClient c, boolean dcau) throws IOException, FTPException {
        if (c.isFeatureSupported("DCAU")) {
            if (!dcau) {
                c.setDataChannelAuthentication(DataChannelAuthentication.NONE);
            }
        } else if (dcau) {
            throw new IOException("DCAU not supported but DCAU requested");
        }
    }

    private FTPClient createFTPConnection(GlobusURL ftpURL, boolean srcSide) throws Exception {
        String protocol = ftpURL.getProtocol();
        if (protocol.equalsIgnoreCase("ftp")) {
            FTPClient ftp = new FTPClient(ftpURL.getHost(), ftpURL.getPort());
            ftp.authorize(ftpURL.getUser(), ftpURL.getPwd());
            return ftp;
        }
        GridFTPClient ftp = new GridFTPClient(ftpURL.getHost(), ftpURL.getPort());
        if (srcSide) {
            ftp.setAuthorization(this.getSourceAuthorization());
            ftp.authenticate(this.getSourceCredentials());
        } else {
            ftp.setAuthorization(this.getDestinationAuthorization());
            ftp.authenticate(this.getDestinationCredentials());
        }
        return ftp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

