/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.gsi.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.mds.gsi.common.SaslInputStream;
import org.globus.mds.gsi.common.SaslOutputStream;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public class GSIMechanism {
    private static Logger logger = Logger.getLogger((String)(class$org$globus$mds$gsi$common$GSIMechanism == null ? (class$org$globus$mds$gsi$common$GSIMechanism = GSIMechanism.class$("org.globus.mds.gsi.common.GSIMechanism")) : class$org$globus$mds$gsi$common$GSIMechanism).getName());
    public static final String SECURITY_CREDENTIALS = "org.globus.gsi.credentials";
    public static final String NAME2 = "GSS-GSI";
    public static final String NAME = "GSS-OWNYQ6NTEOAUVGWG";
    public static final String MAX_SEND_BUF = "javax.security.sasl.sendmaxbuffer";
    public static final String MAX_BUFFER = "javax.security.sasl.maxbuffer";
    public static final String STRENGTH = "javax.security.sasl.strength";
    public static final String QOP = "javax.security.sasl.qop";
    public static final String PROXY = "org.globus.mds.gsi.proxy";
    protected static final byte NO_PROTECTION = 1;
    protected static final byte INTEGRITY_ONLY_PROTECTION = 2;
    protected static final byte PRIVACY_PROTECTION = 4;
    protected static final byte LOW_STRENGTH = 1;
    protected static final byte MEDIUM_STRENGTH = 2;
    protected static final byte HIGH_STRENGTH = 4;
    private static final byte[] DEFAULT_QOP = new byte[]{1};
    private static final String[] QOP_TOKENS = new String[]{"auth-conf", "auth-int", "auth"};
    private static final byte[] QOP_MASKS = new byte[]{4, 2, 1};
    private static final byte[] DEFAULT_STRENGTH = new byte[]{4, 2, 1};
    private static final String[] STRENGTH_TOKENS = new String[]{"low", "medium", "high"};
    private static final byte[] STRENGTH_MASKS = new byte[]{1, 2, 4};
    protected GSSContext context = null;
    protected boolean completed = false;
    protected byte[] qop;
    protected byte allQop;
    protected byte[] strength;
    protected boolean privacy = false;
    protected boolean integrity = false;
    protected int sendMaxBufSize = 0;
    protected int recvMaxBufSize = 65536;
    static /* synthetic */ Class class$org$globus$mds$gsi$common$GSIMechanism;

    public String getMechanismName() {
        return NAME;
    }

    public boolean isComplete() {
        return this.completed;
    }

    protected void init(String serverName, Map props) throws Exception {
        GSSCredential cred = null;
        Object tmp = props.get(SECURITY_CREDENTIALS);
        if (tmp != null) {
            if (tmp instanceof GSSCredential) {
                cred = (GSSCredential)tmp;
            } else {
                throw new Exception("Invalid credential type passed");
            }
        }
        GSSManager manager = ExtendedGSSManager.getInstance();
        GSSName target = manager.createName("ldap@" + serverName, GSSName.NT_HOSTBASED_SERVICE);
        this.context = manager.createContext(target, GSSConstants.MECH_OID, cred, 0);
        this.context.requestCredDeleg(false);
        this.init(props);
    }

    private void init(Map props) throws Exception {
        int i;
        if (props == null) {
            return;
        }
        this.qop = this.parseQop((String)props.get(QOP));
        this.allQop = GSIMechanism.combineMasks(this.qop);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"client protections: ");
            i = 0;
            while (i < this.qop.length) {
                logger.debug((Object)(" " + this.qop[i]));
                ++i;
            }
        }
        this.setQOP(this.qop);
        this.strength = this.parseStrength((String)props.get(STRENGTH));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"cipher strengths: ");
            i = 0;
            while (i < this.strength.length) {
                logger.debug((Object)(" " + this.strength[i]));
                ++i;
            }
        }
        logger.debug((Object)("client allQop: " + this.allQop));
    }

    private void initContext() {
        logger.debug((Object)("client allQop: " + this.allQop));
        if ((this.allQop & 2) != 0) {
            logger.debug((Object)"client requested integrity protection");
        }
        if ((this.allQop & 4) != 0) {
            logger.debug((Object)"client requested privacy protection");
        }
    }

    protected static byte combineMasks(byte[] in) {
        byte answer = 0;
        int i = 0;
        while (i < in.length) {
            answer = (byte)(answer | in[i]);
            ++i;
        }
        return answer;
    }

    protected byte[] parseQop(String qop) throws Exception {
        return this.parseQop(qop, null, false);
    }

    protected byte[] parseQop(String qop, String[] saveTokens, boolean ignore) throws Exception {
        if (qop == null) {
            return DEFAULT_QOP;
        }
        return this.parseProp(QOP, qop, QOP_TOKENS, QOP_MASKS, saveTokens, ignore);
    }

    protected byte[] parseStrength(String strength) throws Exception {
        if (strength == null) {
            return DEFAULT_STRENGTH;
        }
        return this.parseProp(STRENGTH, strength, STRENGTH_TOKENS, STRENGTH_MASKS, null, false);
    }

    protected byte[] parseProp(String propName, String propVal, String[] vals, byte[] masks, String[] tokens, boolean ignore) throws Exception {
        int j;
        StringTokenizer parser = new StringTokenizer(propVal, ", \t\n");
        byte[] answer = new byte[vals.length];
        int i = 0;
        while (parser.hasMoreTokens() && i < answer.length) {
            String token = parser.nextToken();
            boolean found = false;
            j = 0;
            while (!found && j < vals.length) {
                if (token.equalsIgnoreCase(vals[j])) {
                    found = true;
                    answer[i++] = masks[j];
                    if (tokens != null) {
                        tokens[j] = token;
                    }
                }
                ++j;
            }
            if (found || ignore) continue;
            throw new Exception("Invalid token in " + propName + ": " + propVal);
        }
        j = i;
        while (j < answer.length) {
            answer[j] = 0;
            ++j;
        }
        return answer;
    }

    public static byte findPreferredMask(byte pref, byte[] in) {
        int i = 0;
        while (i < in.length) {
            if ((in[i] & pref) != 0) {
                return in[i];
            }
            ++i;
        }
        return 0;
    }

    public static void intToNetworkByteOrder(int num, byte[] buf, int start, int count) {
        if (count > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        int i = count - 1;
        while (i >= 0) {
            buf[start + i] = (byte)(num & 0xFF);
            num >>>= 8;
            --i;
        }
    }

    public static int networkByteOrderToInt(byte[] buf, int start, int count) {
        if (count > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        int answer = 0;
        int i = 0;
        while (i < count) {
            answer <<= 8;
            answer |= buf[start + i] & 0xFF;
            ++i;
        }
        return answer;
    }

    public OutputStream getOutputStream(OutputStream dest) throws IOException {
        if (!this.isComplete()) {
            throw new IOException("Not completed.");
        }
        if (this.isNotProtected()) {
            logger.debug((Object)"getOutputStream - current");
            return dest;
        }
        logger.debug((Object)"getOutputStream - new");
        return new SaslOutputStream(dest, this.context);
    }

    public InputStream getInputStream(InputStream src) throws IOException {
        if (!this.isComplete()) {
            throw new IOException("Not completed.");
        }
        if (this.isNotProtected()) {
            logger.debug((Object)"getInputStream - current");
            return src;
        }
        logger.debug((Object)"getInputStream - new");
        return new SaslInputStream(src, this.context);
    }

    public byte[] exchangeData(byte[] challengeData) throws GSSException, Exception {
        logger.debug((Object)"exchangeData");
        byte[] token = null;
        if (this.context.isEstablished()) {
            token = this.context.unwrap(challengeData, 0, challengeData.length, null);
            if (token.length != 4) {
                throw new Exception("Invalid protection buffer");
            }
            this.negotiateProtections(token);
            token = this.context.wrap(token, 0, token.length, null);
            this.completed = true;
        } else {
            token = this.context.initSecContext(challengeData, 0, challengeData.length);
        }
        return token;
    }

    public void setQOP(byte[] qop) throws GSSException {
        this.context.requestConf(true);
        if ((qop[0] & 2) != 0) {
            logger.debug((Object)"Requested integrity protection");
            this.context.requestConf(false);
        }
        if ((qop[0] & 4) != 0) {
            logger.debug((Object)"Requested privacy protection");
            this.context.requestConf(true);
        }
        logger.debug((Object)("Requested encryption: " + this.context.getConfState()));
    }

    public byte[] negotiateProtections(byte[] sf) throws Exception {
        logger.debug((Object)("Server protections: " + sf[0]));
        byte selectedQop = GSIMechanism.findPreferredMask(sf[0], this.qop);
        if (selectedQop == 0) {
            throw new Exception("No common protection layer between client and server");
        }
        if ((selectedQop & 4) != 0) {
            this.privacy = true;
            this.integrity = true;
        } else if ((selectedQop & 2) != 0) {
            this.privacy = false;
            this.integrity = true;
        }
        int srvMaxBufSize = GSIMechanism.networkByteOrderToInt(sf, 1, 3);
        this.sendMaxBufSize = this.sendMaxBufSize == 0 ? srvMaxBufSize : Math.min(this.sendMaxBufSize, srvMaxBufSize);
        logger.debug((Object)("client max recv size: " + this.recvMaxBufSize));
        logger.debug((Object)("server max recv size: " + srvMaxBufSize));
        sf[0] = selectedQop;
        logger.debug((Object)("Client selected protection: " + selectedQop));
        logger.debug((Object)("Privacy: " + this.privacy));
        logger.debug((Object)("Integrity: " + this.integrity));
        GSIMechanism.intToNetworkByteOrder(this.recvMaxBufSize, sf, 1, 3);
        return sf;
    }

    public boolean isPrivacyQop() {
        return this.privacy;
    }

    public boolean isIntegrityQop() {
        return this.integrity;
    }

    public boolean isNotProtected() {
        return !this.privacy && !this.integrity;
    }

    public int getSendMaxBufSize() {
        return this.sendMaxBufSize;
    }

    public int getRecvMaxBufSize() {
        return this.recvMaxBufSize;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

