/*
 * Decompiled with CFR 0.152.
 */
package org.globus.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.SelfAuthorization;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.globus.net.AbstractServerDeactivator;
import org.globus.net.ServerSocketFactory;
import org.globus.util.Util;
import org.globus.util.deactivator.Deactivator;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public abstract class BaseServer
implements Runnable {
    private static Logger logger = Logger.getLogger((String)(class$org$globus$net$BaseServer == null ? (class$org$globus$net$BaseServer = BaseServer.class$("org.globus.net.BaseServer")) : class$org$globus$net$BaseServer).getName());
    public static final int SO_TIMEOUT = 300000;
    protected boolean accept;
    protected ServerSocket _server = null;
    private boolean secure = true;
    protected String url = null;
    private Thread serverThread = null;
    protected GSSCredential credentials = null;
    protected Authorization authorization = null;
    protected Integer gssMode = GSIConstants.MODE_SSL;
    protected AbstractServerDeactivator deactivator = null;
    static /* synthetic */ Class class$org$globus$net$BaseServer;

    public BaseServer() throws IOException {
        this(null, 0);
    }

    public BaseServer(int port) throws IOException {
        this(null, port);
    }

    public BaseServer(GSSCredential cred, int port) throws IOException {
        this.credentials = cred;
        this._server = ServerSocketFactory.getDefault().createServerSocket(port);
        this.secure = true;
        this.initialize();
    }

    public BaseServer(boolean secure, int port) throws IOException {
        this.credentials = null;
        this._server = ServerSocketFactory.getDefault().createServerSocket(port);
        this.secure = secure;
        this.initialize();
    }

    protected void initialize() {
        this.setAuthorization(SelfAuthorization.getInstance());
        this.start();
    }

    protected void start() {
        if (this.serverThread == null) {
            this.accept = true;
            this.serverThread = new Thread(this);
            this.serverThread.start();
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void shutdown() {
        this.accept = false;
        try {
            this._server.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        Socket s = null;
        s = new Socket(this.getHostname(), this.getPort());
        s.getInputStream();
        Object var4_3 = null;
        if (s == null) return;
        try {
            s.close();
            return;
        }
        catch (Exception e2) {}
        return;
        {
            catch (Exception e) {
                Object var4_4 = null;
                if (s == null) return;
                try {
                    s.close();
                    return;
                }
                catch (Exception e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (s == null) throw throwable;
            try {
                s.close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public GSSCredential getCredentials() {
        return this.credentials;
    }

    public String getProtocol() {
        return this.secure ? "https" : "http";
    }

    public String getURL() {
        if (this.url == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getProtocol()).append("://").append(this.getHostname()).append(":").append(String.valueOf(this.getPort()));
            this.url = buf.toString();
        }
        return this.url;
    }

    public int getPort() {
        return this._server.getLocalPort();
    }

    public String getHostname() {
        return Util.getLocalHostAddress();
    }

    public void run() {
        Socket socket = null;
        while (this.accept) {
            try {
                socket = this._server.accept();
                if (!this.accept) break;
                socket.setSoTimeout(300000);
            }
            catch (IOException e) {
                if (!this.accept) break;
                logger.error((Object)("Server died: " + e.getMessage()), (Throwable)e);
                break;
            }
            if (this.secure) {
                try {
                    socket = this.wrapSocket(socket);
                }
                catch (GSSException e) {
                    logger.error((Object)"Failed to secure the socket", (Throwable)e);
                    break;
                }
            }
            this.handleConnection(socket);
        }
        this.serverThread = null;
        this._server = null;
        logger.debug((Object)"server thread stopped");
    }

    protected Socket wrapSocket(Socket socket) throws GSSException {
        GSSManager manager = ExtendedGSSManager.getInstance();
        ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext(this.credentials);
        context.setOption(GSSConstants.GSS_MODE, this.gssMode);
        GssSocketFactory factory = GssSocketFactory.getDefault();
        GssSocket gsiSocket = (GssSocket)factory.createSocket(socket, null, 0, context);
        gsiSocket.setUseClientMode(false);
        gsiSocket.setAuthorization(this.authorization);
        return gsiSocket;
    }

    public void setGssMode(Integer mode) {
        this.gssMode = mode;
    }

    public void setAuthorization(Authorization auth) {
        this.authorization = auth;
    }

    protected abstract void handleConnection(Socket var1);

    public void registerDefaultDeactivator() {
        if (this.deactivator == null) {
            this.deactivator = new AbstractServerDeactivator(this);
        }
        Deactivator.registerDeactivation(this.deactivator);
    }

    public void unregisterDefaultDeactivator() {
        if (this.deactivator == null) {
            return;
        }
        Deactivator.unregisterDeactivation(this.deactivator);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

