/*
 * Decompiled with CFR 0.152.
 */
package org.globus.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.globus.net.PortRange;
import org.globus.net.PrServerSocket;

public class ServerSocketFactory {
    private static ServerSocketFactory factory = null;
    private PortRange portRange = null;

    protected ServerSocketFactory() {
    }

    public static synchronized ServerSocketFactory getDefault() {
        if (factory == null) {
            factory = new ServerSocketFactory();
        }
        return factory;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return this.createServerSocket(port, 50, null);
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return this.createServerSocket(port, backlog, null);
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        if (this.portRange == null) {
            this.portRange = PortRange.getInstance();
        }
        if (this.portRange.isEnabled() && port == 0) {
            return this.createServerSocket(backlog, bindAddr);
        }
        return new ServerSocket(port, backlog, bindAddr);
    }

    private ServerSocket createServerSocket(int backlog, InetAddress binAddr) throws IOException {
        PrServerSocket server = null;
        int port = 0;
        while (true) {
            port = this.portRange.getFreePort(port);
            try {
                server = new PrServerSocket(port, backlog, binAddr);
                this.portRange.setUsed(port);
                return server;
            }
            catch (IOException e) {
                ++port;
                continue;
            }
            break;
        }
    }
}

