/*
 * Decompiled with CFR 0.152.
 */
package org.globus.rsl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.globus.rsl.AbstractRslNode;
import org.globus.rsl.Bindings;
import org.globus.rsl.NameOpValue;
import org.globus.rsl.RslEvaluationException;

public class ListRslNode
extends AbstractRslNode {
    protected List _relations = null;
    protected List _bindings = null;

    public ListRslNode() {
    }

    public ListRslNode(int operator) {
        super(operator);
    }

    public boolean add(Bindings bindings) {
        if (this._bindings == null) {
            this._bindings = new LinkedList();
        }
        return this._bindings.add(bindings);
    }

    public boolean add(NameOpValue relation) {
        if (this._relations == null) {
            this._relations = new LinkedList();
        }
        return this._relations.add(relation);
    }

    public NameOpValue getParam(String attribute) {
        if (this._relations == null || attribute == null) {
            return null;
        }
        Iterator iter = this._relations.iterator();
        String canonAttrib = AbstractRslNode.canonicalize(attribute);
        String tmpCanonAttrib = null;
        while (iter.hasNext()) {
            NameOpValue nv = (NameOpValue)iter.next();
            tmpCanonAttrib = AbstractRslNode.canonicalize(nv.getAttribute());
            if (!tmpCanonAttrib.equalsIgnoreCase(canonAttrib)) continue;
            return nv;
        }
        return null;
    }

    public Bindings getBindings(String attribute) {
        if (this._bindings == null || attribute == null) {
            return null;
        }
        Iterator iter = this._bindings.iterator();
        String canonAttrib = AbstractRslNode.canonicalize(attribute);
        String tmpCanonAttrib = null;
        while (iter.hasNext()) {
            Bindings bind = (Bindings)iter.next();
            tmpCanonAttrib = AbstractRslNode.canonicalize(bind.getAttribute());
            if (!tmpCanonAttrib.equalsIgnoreCase(canonAttrib)) continue;
            return bind;
        }
        return null;
    }

    public Bindings removeBindings(String attribute) {
        if (this._bindings == null || attribute == null) {
            return null;
        }
        Iterator iter = this._bindings.iterator();
        String canonAttrib = AbstractRslNode.canonicalize(attribute);
        String tmpCanonAttrib = null;
        while (iter.hasNext()) {
            Bindings bind = (Bindings)iter.next();
            tmpCanonAttrib = AbstractRslNode.canonicalize(bind.getAttribute());
            if (!tmpCanonAttrib.equalsIgnoreCase(canonAttrib)) continue;
            iter.remove();
            return bind;
        }
        return null;
    }

    public NameOpValue removeParam(String attribute) {
        if (this._relations == null || attribute == null) {
            return null;
        }
        Iterator iter = this._relations.iterator();
        String canonAttrib = AbstractRslNode.canonicalize(attribute);
        String tmpCanonAttrib = null;
        while (iter.hasNext()) {
            NameOpValue nv = (NameOpValue)iter.next();
            tmpCanonAttrib = AbstractRslNode.canonicalize(nv.getAttribute());
            if (!tmpCanonAttrib.equalsIgnoreCase(canonAttrib)) continue;
            iter.remove();
            return nv;
        }
        return null;
    }

    public void mergeTo(AbstractRslNode dstNode) {
        Iterator iter = null;
        super.mergeTo(dstNode);
        if (this._relations != null) {
            iter = this._relations.iterator();
            while (iter.hasNext()) {
                NameOpValue tmpNov = (NameOpValue)iter.next();
                NameOpValue nov = dstNode.getParam(tmpNov.getAttribute());
                if (nov == null) {
                    dstNode.add(tmpNov);
                    continue;
                }
                nov.merge(tmpNov);
            }
        }
        if (this._bindings != null) {
            iter = this._bindings.iterator();
            while (iter.hasNext()) {
                Bindings tmpBind = (Bindings)iter.next();
                Bindings bind = dstNode.getBindings(tmpBind.getAttribute());
                if (bind == null) {
                    dstNode.add(tmpBind);
                    continue;
                }
                bind.merge(tmpBind);
            }
        }
    }

    public List getRelations() {
        return this._relations;
    }

    public List getBindings() {
        return this._bindings;
    }

    public AbstractRslNode evaluate(Map symbolTable) throws RslEvaluationException {
        if (symbolTable == null) {
            symbolTable = new HashMap();
        }
        HashMap localSymbolTable = null;
        Iterator iter = null;
        ListRslNode finalRsl = new ListRslNode(this.getOperator());
        if (this._bindings != null && this._bindings.size() > 0) {
            iter = this._bindings.iterator();
            localSymbolTable = new HashMap(symbolTable);
            while (iter.hasNext()) {
                Bindings binds = (Bindings)iter.next();
                finalRsl.add(binds.evaluate(localSymbolTable));
            }
        } else {
            localSymbolTable = symbolTable;
        }
        if (this._relations != null && this._relations.size() > 0) {
            iter = this._relations.iterator();
            while (iter.hasNext()) {
                NameOpValue nov = (NameOpValue)iter.next();
                finalRsl.add(nov.evaluate(localSymbolTable));
            }
        }
        if (this._specifications != null && this._specifications.size() > 0) {
            iter = this._specifications.iterator();
            while (iter.hasNext()) {
                AbstractRslNode node = (AbstractRslNode)iter.next();
                finalRsl.add(node.evaluate(localSymbolTable));
            }
        }
        return finalRsl;
    }

    public void toRSL(StringBuffer buf, boolean explicitConcat) {
        Iterator iter;
        buf.append(this.getOperatorAsString());
        if (this._bindings != null && this._bindings.size() > 0) {
            iter = this._bindings.iterator();
            while (iter.hasNext()) {
                Bindings binds = (Bindings)iter.next();
                binds.toRSL(buf, explicitConcat);
            }
        }
        if (this._relations != null && this._relations.size() > 0) {
            iter = this._relations.iterator();
            while (iter.hasNext()) {
                NameOpValue nov = (NameOpValue)iter.next();
                nov.toRSL(buf, explicitConcat);
            }
        }
        if (this._specifications != null && this._specifications.size() > 0) {
            iter = this._specifications.iterator();
            while (iter.hasNext()) {
                AbstractRslNode node = (AbstractRslNode)iter.next();
                buf.append(" (");
                node.toRSL(buf, explicitConcat);
                buf.append(" )");
            }
        }
    }
}

