/*
 * Decompiled with CFR 0.152.
 */
package org.globus.rsl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.globus.rsl.Binding;
import org.globus.rsl.Bindings;
import org.globus.rsl.NameOpValue;
import org.globus.rsl.ParseException;
import org.globus.rsl.RSLParser;
import org.globus.rsl.RslNode;
import org.globus.rsl.Value;

public class RslAttributes {
    protected RslNode rslTree;

    public RslAttributes() {
        this.rslTree = new RslNode();
    }

    public RslAttributes(RslNode rslTree) {
        this.rslTree = rslTree;
    }

    public RslAttributes(String rsl) throws ParseException {
        this.rslTree = RSLParser.parse(rsl);
    }

    public RslNode getRslNode() {
        return this.rslTree;
    }

    public String getSingle(String attribute) {
        NameOpValue nv = this.rslTree.getParam(attribute);
        if (nv == null || nv.getOperator() != 1) {
            return null;
        }
        Object obj = nv.getFirstValue();
        if (obj != null && obj instanceof Value) {
            return ((Value)obj).getCompleteValue();
        }
        return null;
    }

    public List getMulti(String attribute) {
        NameOpValue nv = this.rslTree.getParam(attribute);
        if (nv == null || nv.getOperator() != 1) {
            return null;
        }
        List values = nv.getValues();
        LinkedList<String> list = new LinkedList<String>();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof Value)) continue;
            list.add(((Value)obj).getCompleteValue());
        }
        return list;
    }

    public Map getMap(String attribute) {
        NameOpValue nv = this.rslTree.getParam(attribute);
        if (nv == null || nv.getOperator() != 1) {
            return null;
        }
        List values = nv.getValues();
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            List list;
            Object obj = iter.next();
            if (!(obj instanceof List) || (list = (List)obj).size() != 2 || !((obj = list.get(0)) instanceof Value)) continue;
            String key = ((Value)obj).getCompleteValue();
            obj = list.get(1);
            if (!(obj instanceof Value)) continue;
            String value = ((Value)obj).getCompleteValue();
            map.put(key, value);
        }
        return map;
    }

    public Map getVariables(String attribute) {
        Bindings binds = this.rslTree.getBindings(attribute);
        if (binds == null) {
            return null;
        }
        List values = binds.getValues();
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            Binding binding = (Binding)iter.next();
            map.put(binding.getName(), binding.getValue().getCompleteValue());
        }
        return map;
    }

    public void addVariable(String attribute, String varName, String value) {
        Bindings binds = this.rslTree.getBindings(attribute);
        if (binds == null) {
            binds = new Bindings(attribute);
            this.rslTree.put(binds);
        }
        binds.add(new Binding(varName, value));
    }

    public boolean removeVariable(String attribute, String varName) {
        Bindings binds = this.rslTree.getBindings(attribute);
        if (binds == null) {
            return false;
        }
        return binds.removeVariable(varName);
    }

    public void remove(String attribute) {
        this.rslTree.removeParam(attribute);
    }

    public boolean remove(String attribute, String value) {
        NameOpValue nv = this.rslTree.getParam(attribute);
        if (nv == null || nv.getOperator() != 1) {
            return false;
        }
        return nv.remove(new Value(value));
    }

    public boolean removeMap(String attribute, String key) {
        NameOpValue nv = this.rslTree.getParam(attribute);
        if (nv == null || nv.getOperator() != 1) {
            return false;
        }
        List values = nv.getValues();
        Iterator iter = values.iterator();
        int i = 0;
        int found = -1;
        while (iter.hasNext()) {
            Object var;
            List vr;
            Object obj = iter.next();
            if (obj instanceof List && (vr = (List)obj).size() > 0 && (var = vr.get(0)) instanceof Value && ((Value)var).getValue().equals(key)) {
                found = i;
                break;
            }
            ++i;
        }
        if (found != -1) {
            values.remove(found);
            return true;
        }
        return false;
    }

    protected NameOpValue getRelation(String attribute) {
        NameOpValue nv = this.rslTree.getParam(attribute);
        if (nv == null) {
            nv = new NameOpValue(attribute, 1);
            this.rslTree.put(nv);
        }
        return nv;
    }

    public void set(String attribute, String value) {
        NameOpValue nv = this.getRelation(attribute);
        nv.clear();
        nv.add(new Value(value));
    }

    public void add(String attribute, String value) {
        NameOpValue nv = this.getRelation(attribute);
        nv.add(new Value(value));
    }

    public void setMulti(String attribute, String[] values) {
        NameOpValue nv = this.getRelation(attribute);
        nv.clear();
        LinkedList<Value> list = new LinkedList<Value>();
        int i = 0;
        while (i < values.length) {
            list.add(new Value(values[i]));
            ++i;
        }
        nv.add(list);
    }

    public void addMulti(String attribute, String[] values) {
        NameOpValue nv = this.getRelation(attribute);
        LinkedList<Value> list = new LinkedList<Value>();
        int i = 0;
        while (i < values.length) {
            list.add(new Value(values[i]));
            ++i;
        }
        nv.add(list);
    }

    public String getFirstValue(String attribute) {
        return this.getSingle(attribute);
    }

    public List get(String attribute) {
        return this.getMulti(attribute);
    }

    public String toRSL() {
        return this.rslTree.toRSL(true);
    }
}

