/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools;

import java.io.File;
import org.globus.common.CoGProperties;
import org.globus.util.Util;

public class ProxyDestroy {
    private static final String message = "\nSyntax: java ProxyDestroy [-dryrun] [file1...]\n        java ProxyDestroy -help\n\n\tOptions\n\t-help | -usage\n\t\tDisplays usage\n\t-dryrun\n\t\tPrints what files would have been destroyed\n\tfile1 file2 ...\n\t\tDestroys files listed\n\n";

    public static void main(String[] args) {
        boolean dryrun = false;
        boolean error = false;
        boolean debug = false;
        File file = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-dryrun")) {
                dryrun = true;
            } else if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-usage")) {
                System.err.println(message);
                System.exit(1);
            } else {
                file = new File(args[i]);
                if (dryrun) {
                    System.out.println("Would remove " + file.getAbsolutePath());
                } else {
                    Util.destroy(file);
                }
            }
            ++i;
        }
        String fn = CoGProperties.getDefault().getProxyFile();
        if (fn == null) {
            return;
        }
        file = new File(fn);
        if (dryrun) {
            System.out.println("Would remove " + file.getAbsolutePath());
            return;
        }
        Util.destroy(file);
    }
}

