/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpOutputStream;
import HTTPClient.Log;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.URI;
import HTTPClient.Util;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Hashtable;

class RedirectionModule
implements HTTPClientModule {
    private static Hashtable perm_redir_cntxt_list = new Hashtable();
    private static Hashtable deferred_redir_list = new Hashtable();
    private int level = 0;
    private URI lastURI = null;
    private boolean new_con;
    private Request saved_req = null;

    RedirectionModule() {
    }

    public int requestHandler(Request request, Response[] responseArray) {
        URI uRI;
        HTTPConnection hTTPConnection = request.getConnection();
        HttpOutputStream httpOutputStream = request.getStream();
        if (httpOutputStream != null && deferred_redir_list.get(httpOutputStream) != null) {
            this.copyFrom((RedirectionModule)deferred_redir_list.remove(httpOutputStream));
            request.copyFrom(this.saved_req);
            if (this.new_con) {
                return 5;
            }
            return 1;
        }
        try {
            uRI = new URI(new URI(hTTPConnection.getProtocol(), hTTPConnection.getHost(), hTTPConnection.getPort(), null), request.getRequestURI());
        }
        catch (ParseException parseException) {
            throw new Error("HTTPClient Internal Error: unexpected exception '" + parseException + "'");
        }
        Hashtable hashtable = Util.getList(perm_redir_cntxt_list, request.getConnection().getContext());
        URI uRI2 = (URI)hashtable.get(uRI);
        if (uRI2 != null) {
            String string = uRI2.getPathAndQuery();
            request.setRequestURI(string);
            try {
                this.lastURI = new URI(uRI2, string);
            }
            catch (ParseException parseException) {}
            Log.write(32, "RdirM: matched request in permanent redirection list - redoing request to " + this.lastURI.toExternalForm());
            if (!hTTPConnection.isCompatibleWith(uRI2)) {
                try {
                    hTTPConnection = new HTTPConnection(uRI2);
                }
                catch (Exception exception) {
                    throw new Error("HTTPClient Internal Error: unexpected exception '" + exception + "'");
                }
                hTTPConnection.setSSLSocketFactory(request.getConnection().getSSLSocketFactory());
                hTTPConnection.setContext(request.getConnection().getContext());
                request.setConnection(hTTPConnection);
                return 5;
            }
            return 1;
        }
        return 0;
    }

    public void responsePhase1Handler(Response response, RoRequest roRequest) throws IOException {
        int n = response.getStatusCode();
        if ((n < 301 || n > 307 || n == 304) && this.lastURI != null) {
            response.setEffectiveURI(this.lastURI);
        }
    }

    public int responsePhase2Handler(Response response, Request request) throws IOException {
        int n = response.getStatusCode();
        switch (n) {
            case 302: {
                if (request.getMethod().equals("POST") || request.getMethod().equals("PUT")) {
                    Log.write(32, "RdirM: Received status: " + n + " " + response.getReasonLine() + " - treating as 303");
                    n = 303;
                }
            }
            case 301: 
            case 303: 
            case 307: {
                Log.write(32, "RdirM: Handling status: " + n + " " + response.getReasonLine());
                if (!request.getMethod().equals("GET") && !request.getMethod().equals("HEAD") && n != 303) {
                    Log.write(32, "RdirM: not redirected because method is neither HEAD nor GET");
                    if (n == 301 && response.getHeader("Location") != null) {
                        RedirectionModule.update_perm_redir_list(request, this.resLocHdr(response.getHeader("Location"), request));
                    }
                    response.setEffectiveURI(this.lastURI);
                    return 10;
                }
            }
            case 305: 
            case 306: {
                String string;
                HTTPConnection hTTPConnection;
                if (n == 305 || n == 306) {
                    Log.write(32, "RdirM: Handling status: " + n + " " + response.getReasonLine());
                }
                if (n == 305 && request.getConnection().getProxyHost() != null) {
                    Log.write(32, "RdirM: 305 ignored because a proxy is already in use");
                    response.setEffectiveURI(this.lastURI);
                    return 10;
                }
                if (this.level >= 15 || response.getHeader("Location") == null) {
                    if (this.level >= 15) {
                        Log.write(32, "RdirM: not redirected because of too many levels of redirection");
                    } else {
                        Log.write(32, "RdirM: not redirected because no Location header was present");
                    }
                    response.setEffectiveURI(this.lastURI);
                    return 10;
                }
                ++this.level;
                URI uRI = this.resLocHdr(response.getHeader("Location"), request);
                this.new_con = false;
                if (n == 305) {
                    hTTPConnection = new HTTPConnection(request.getConnection().getProtocol(), request.getConnection().getHost(), request.getConnection().getPort());
                    hTTPConnection.setCurrentProxy(uRI.getHost(), uRI.getPort());
                    hTTPConnection.setSSLSocketFactory(request.getConnection().getSSLSocketFactory());
                    hTTPConnection.setContext(request.getConnection().getContext());
                    this.new_con = true;
                    string = request.getRequestURI();
                    request.setMethod("GET");
                    request.setData(null);
                    request.setStream(null);
                } else {
                    if (n == 306) {
                        return 10;
                    }
                    if (request.getConnection().isCompatibleWith(uRI)) {
                        hTTPConnection = request.getConnection();
                        string = uRI.getPathAndQuery();
                    } else {
                        try {
                            hTTPConnection = new HTTPConnection(uRI);
                            string = uRI.getPathAndQuery();
                        }
                        catch (Exception exception) {
                            if (request.getConnection().getProxyHost() == null || !uRI.getScheme().equalsIgnoreCase("ftp")) {
                                return 10;
                            }
                            hTTPConnection = new HTTPConnection("http", request.getConnection().getProxyHost(), request.getConnection().getProxyPort());
                            hTTPConnection.setCurrentProxy(null, 0);
                            string = uRI.toExternalForm();
                        }
                        hTTPConnection.setSSLSocketFactory(request.getConnection().getSSLSocketFactory());
                        hTTPConnection.setContext(request.getConnection().getContext());
                        this.new_con = true;
                    }
                    if (n == 303) {
                        if (!request.getMethod().equals("HEAD")) {
                            request.setMethod("GET");
                        }
                        request.setData(null);
                        request.setStream(null);
                    } else {
                        if (request.getStream() != null) {
                            if (!HTTPConnection.deferStreamed) {
                                Log.write(32, "RdirM: status " + n + " not handled - request " + "has an output stream");
                                return 10;
                            }
                            this.saved_req = (Request)request.clone();
                            deferred_redir_list.put(request.getStream(), this);
                            request.getStream().reset();
                            response.setRetryRequest(true);
                        }
                        if (n == 301) {
                            try {
                                RedirectionModule.update_perm_redir_list(request, new URI(uRI, string));
                            }
                            catch (ParseException parseException) {
                                throw new Error("HTTPClient Internal Error: unexpected exception '" + parseException + "'");
                            }
                        }
                    }
                    NVPair[] nVPairArray = request.getHeaders();
                    int n2 = 0;
                    while (n2 < nVPairArray.length) {
                        if (nVPairArray[n2].getName().equalsIgnoreCase("Referer")) {
                            HTTPConnection hTTPConnection2 = request.getConnection();
                            nVPairArray[n2] = new NVPair("Referer", String.valueOf(hTTPConnection2) + request.getRequestURI());
                            break;
                        }
                        ++n2;
                    }
                }
                request.setConnection(hTTPConnection);
                request.setRequestURI(string);
                try {
                    response.getInputStream().close();
                }
                catch (IOException iOException) {}
                if (n != 305 && n != 306) {
                    try {
                        this.lastURI = new URI(uRI, string);
                    }
                    catch (ParseException parseException) {}
                    Log.write(32, "RdirM: request redirected to " + this.lastURI.toExternalForm() + " using method " + request.getMethod());
                } else {
                    Log.write(32, "RdirM: resending request using proxy " + hTTPConnection.getProxyHost() + ":" + hTTPConnection.getProxyPort());
                }
                if (request.getStream() != null) {
                    return 10;
                }
                if (this.new_con) {
                    return 15;
                }
                return 13;
            }
        }
        return 10;
    }

    public void responsePhase3Handler(Response response, RoRequest roRequest) {
    }

    public void trailerHandler(Response response, RoRequest roRequest) {
    }

    private static void update_perm_redir_list(RoRequest roRequest, URI uRI) {
        HTTPConnection hTTPConnection = roRequest.getConnection();
        URI uRI2 = null;
        try {
            uRI2 = new URI(new URI(hTTPConnection.getProtocol(), hTTPConnection.getHost(), hTTPConnection.getPort(), null), roRequest.getRequestURI());
        }
        catch (ParseException parseException) {}
        if (!uRI2.equals(uRI)) {
            Hashtable hashtable = Util.getList(perm_redir_cntxt_list, hTTPConnection.getContext());
            hashtable.put(uRI2, uRI);
        }
    }

    private URI resLocHdr(String string, RoRequest roRequest) throws ProtocolException {
        try {
            URI uRI = new URI(roRequest.getConnection().getProtocol(), roRequest.getConnection().getHost(), roRequest.getConnection().getPort(), null);
            uRI = new URI(uRI, roRequest.getRequestURI());
            URI uRI2 = new URI(uRI, string);
            if (uRI2.getHost() == null) {
                throw new ProtocolException("Malformed URL in Location header: `" + string + "' - missing host field");
            }
            return uRI2;
        }
        catch (ParseException parseException) {
            throw new ProtocolException("Malformed URL in Location header: `" + string + "' - exception was: " + parseException.getMessage());
        }
    }

    private void copyFrom(RedirectionModule redirectionModule) {
        this.level = redirectionModule.level;
        this.lastURI = redirectionModule.lastURI;
        this.saved_req = redirectionModule.saved_req;
    }
}

