/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.utilities;

import edu.ucsb.nceas.utilities.UtilException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static int DOES_NOT_EXIST = 0;
    public static int EXISTS_ONLY = 1;
    public static int EXISTS_READABLE = 2;
    public static int EXISTS_READ_WRITABLE = 3;
    private static Character FILE_SEPARATOR = null;
    private static int DEFAULT_BUFFER_SIZE = 4096;

    private FileUtil() {
    }

    public static char getFS() {
        if (FILE_SEPARATOR == null) {
            FILE_SEPARATOR = Character.valueOf(File.separatorChar);
        }
        return FILE_SEPARATOR.charValue();
    }

    public static int getFileStatus(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            if (file.canRead()) {
                if (file.canWrite()) {
                    return EXISTS_READ_WRITABLE;
                }
                return EXISTS_READABLE;
            }
            return EXISTS_ONLY;
        }
        return DOES_NOT_EXIST;
    }

    public static long getFileSize(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return -1L;
        }
        return file.length();
    }

    public static boolean isDirectory(String path) {
        File file = new File(path);
        return file.isDirectory();
    }

    public static void createDirectory(String dirPath) throws UtilException {
        File file = new File(dirPath);
        if (file.exists() && file.isDirectory()) {
            return;
        }
        if (!file.mkdirs()) {
            throw new UtilException("Could not create directory: " + dirPath);
        }
    }

    public static void createFile(String filePath) throws UtilException {
        File file = new File(filePath);
        if (file.exists() && !file.isDirectory()) {
            return;
        }
        try {
            if (!file.createNewFile()) {
                throw new UtilException("Could not create file: " + filePath);
            }
        }
        catch (IOException ioe) {
            throw new UtilException("Could not create file: " + filePath + " : " + ioe.getMessage());
        }
    }

    public static void deleteFile(String filePath) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException("Could not find and delete file: " + filePath);
        }
        if (!file.delete()) {
            throw new IOException("Could not delete file: " + filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceInFile(String filePath, Hashtable<String, String> replacementList) throws IOException {
        if (FileUtil.getFileStatus(filePath) != EXISTS_READ_WRITABLE) {
            throw new IOException("File: " + filePath + " is not writeable.");
        }
        Vector<String> fileLines = new Vector<String>();
        FileInputStream fin = null;
        try {
            String fileLine;
            fin = new FileInputStream(filePath);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fin));
            while ((fileLine = reader.readLine()) != null) {
                Enumeration<String> enumer = replacementList.keys();
                while (enumer.hasMoreElements()) {
                    String newLine;
                    String oldValue = enumer.nextElement();
                    String newValue = replacementList.get(oldValue);
                    fileLine = newLine = fileLine.replace(oldValue, newValue);
                }
                fileLines.add(fileLine);
            }
        }
        finally {
            fin.close();
        }
        PrintWriter output = null;
        try {
            output = new PrintWriter(new BufferedWriter(new FileWriter(filePath)));
            Iterator iter = fileLines.iterator();
            while (iter.hasNext()) {
                output.println((String)iter.next());
            }
        }
        finally {
            output.close();
        }
    }

    public static void writeNewFile(String filePath, String content) throws UtilException {
        FileUtil.writeNewFile(filePath, content, null);
    }

    public static void writeNewFile(String filePath, String content, String charset) throws UtilException {
        if (FileUtil.getFileStatus(filePath) != DOES_NOT_EXIST) {
            throw new UtilException("Cannot create file: " + filePath + ". File already exists.");
        }
        PrintWriter output = null;
        try {
            FileUtil.createFile(filePath);
            output = charset != null ? new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), charset))) : new PrintWriter(new BufferedWriter(new FileWriter(filePath, false)));
            output.print(content);
        }
        catch (IOException ioe) {
            throw new UtilException("I/O error while writing new file : " + filePath + " : " + ioe.getMessage());
        }
        finally {
            output.close();
        }
    }

    public static void writeFile(String filePath, String content) throws UtilException {
        FileUtil.writeFile(filePath, content, null);
    }

    public static void writeFile(String filePath, InputStream inputStream, String charset) throws UtilException {
        FileUtil.writeFile(filePath, inputStream, charset, DEFAULT_BUFFER_SIZE);
    }

    public static void writeFile(String filePath, InputStream inputStream, String charset, int bufferSize) throws UtilException {
        FileOutputStream outputStream = null;
        try {
            if (FileUtil.getFileStatus(filePath) == DOES_NOT_EXIST) {
                FileUtil.createFile(filePath);
            }
            outputStream = new FileOutputStream(filePath);
            byte[] byteBuffer = new byte[bufferSize];
            int b = 0;
            while ((b = inputStream.read(byteBuffer)) != -1) {
                outputStream.write(byteBuffer, 0, b);
            }
        }
        catch (IOException ioe) {
            throw new UtilException("I/O error while trying to write file: " + filePath + " : " + ioe.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ioe) {}
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public static void writeFile(String filePath, String content, String charset) throws UtilException {
        if (content == null || content.equals("")) {
            throw new UtilException("Attempting to write a file with no content: " + filePath);
        }
        PrintWriter output = null;
        File file = null;
        try {
            file = new File(filePath);
            file.createNewFile();
            output = null;
            output = charset != null ? new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset))) : new PrintWriter(new BufferedWriter(new FileWriter(file, false)));
            output.print(content);
        }
        catch (IOException ioe) {
            file.delete();
            throw new UtilException("I/O error while trying to write file: " + filePath);
        }
        finally {
            output.close();
        }
    }

    public static String readFileToString(String filePath) throws UtilException {
        return FileUtil.readFileToString(filePath, null);
    }

    public static String readFileToString(String filePath, String charset) throws UtilException {
        if (FileUtil.getFileStatus(filePath) < EXISTS_READABLE) {
            throw new UtilException("Cannot read file: " + filePath);
        }
        File file = new File(filePath);
        int fileLength = new Long(file.length()).intValue();
        BufferedReader input = null;
        StringBuffer contents = null;
        contents = fileLength >= 0 ? new StringBuffer(fileLength) : new StringBuffer(100000);
        try {
            String nextLine;
            input = charset != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), charset)) : new BufferedReader(new FileReader(filePath));
            boolean firstLine = true;
            while ((nextLine = input.readLine()) != null) {
                if (!firstLine) {
                    contents.append("\n");
                } else {
                    firstLine = false;
                }
                contents.append(nextLine);
            }
        }
        catch (IOException ioe) {
            throw new UtilException("I/O error while trying to read file: " + filePath);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException ioe) {}
        }
        if (contents.equals("")) {
            return null;
        }
        return contents.toString();
    }

    public static String normalizePath(String path) {
        return path.replace('/', FileUtil.getFS());
    }

    public static JarEntry getJarEntry(String jarFilePath, String entryName) throws UtilException {
        if (FileUtil.getFileStatus(jarFilePath) < EXISTS_READABLE) {
            throw new UtilException("Could not find jar file to get content names: " + jarFilePath);
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarFilePath);
        }
        catch (IOException ioe) {
            throw new UtilException("I/O problem while trying to get contents of jar: " + jarFilePath + " : " + ioe.getMessage());
        }
        return jarFile.getJarEntry(entryName);
    }

    public static Vector<JarEntry> getJarInfoList(String jarFilePath) throws UtilException {
        if (FileUtil.getFileStatus(jarFilePath) < EXISTS_READABLE) {
            throw new UtilException("Could not find jar file to get content names: " + jarFilePath);
        }
        Vector<JarEntry> infoList = new Vector<JarEntry>();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarFilePath);
        }
        catch (IOException ioe) {
            throw new UtilException("I/O problem while trying to get contents of jar: " + jarFilePath + " : " + ioe.getMessage());
        }
        Enumeration<JarEntry> jarEntryEnum = jarFile.entries();
        while (jarEntryEnum.hasMoreElements()) {
            infoList.add(jarEntryEnum.nextElement());
        }
        return infoList;
    }

    public static void extractJarFile(String jarFilePath, String destinationPath) throws UtilException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarFilePath);
            Enumeration<JarEntry> jarEntryEnum = jarFile.entries();
            while (jarEntryEnum.hasMoreElements()) {
                int lastFS;
                JarEntry jarEntry = jarEntryEnum.nextElement();
                String entryName = jarEntry.getName();
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                if (jarEntry.isDirectory()) {
                    FileUtil.createDirectory(destinationPath + FileUtil.getFS() + entryName);
                    continue;
                }
                String filePath = destinationPath + FileUtil.getFS() + entryName;
                String fileDir = filePath.substring(0, lastFS = filePath.lastIndexOf(FileUtil.getFS()));
                if (!FileUtil.isDirectory(fileDir)) {
                    FileUtil.createDirectory(fileDir);
                }
                FileUtil.writeFile(destinationPath + FileUtil.getFS() + entryName, inputStream, null);
            }
        }
        catch (IOException ioe) {
            throw new UtilException("I/O problem while trying to get contents of jar: " + jarFilePath + " : " + ioe.getMessage());
        }
    }

    public static BufferedReader getJarEntryReader(String jarFilePath, String jarEntryName) throws UtilException {
        BufferedReader bufferedReader = null;
        try {
            JarFile jarFile = new JarFile(jarFilePath);
            JarEntry jarEntry = jarFile.getJarEntry(jarEntryName);
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
        }
        catch (IOException ioe) {
            throw new UtilException("I/O problem while trying to get jar entry reader for entry " + jarEntryName + " in jar file " + jarFilePath + " : " + ioe.getMessage());
        }
        return bufferedReader;
    }
}

