/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid.metacat.put;

import edu.ucsb.nceas.metacat.client.MetacatClient;
import edu.ucsb.nceas.metacat.client.MetacatFactory;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;
import org.ecoinformatics.ecogrid.put.stub.PutServiceElementType;
import org.ecoinformatics.ecogrid.put.stub.PutServicePortType;
import org.ecoinformatics.ecogrid.put.stub.PutServiceResponseElementType;

public class MetacatPutImpl
implements PutServicePortType {
    private static String uploadMetacatURL = "http://indus.nceas.ucsb.edu/knb-oracle/metacat";
    private static Logger logMetacat = Logger.getLogger((Class)MetacatPutImpl.class);

    public PutServiceResponseElementType put(PutServiceElementType putServiceElementType) throws RemoteException {
        PutServiceResponseElementType putServiceResponseElementType = null;
        byte[] byArray = putServiceElementType.getObjData();
        String string = putServiceElementType.getObjectId();
        String string2 = putServiceElementType.getObjectName();
        int n = putServiceElementType.getObjType();
        String string3 = putServiceElementType.getSessionId();
        logMetacat.info((Object)("server side metcat put is called. session Id is: " + string3));
        logMetacat.info((Object)("metacat URL for put(): " + uploadMetacatURL + "\n"));
        if (n == 1) {
            this.UploadMetacatData(byArray, string, string2, string3);
            logMetacat.info((Object)"Uploading data succeeded.");
        } else if (n == 2) {
            this.UploadMetacatMetadata(byArray, string, string3);
            logMetacat.info((Object)"Uploading metadata succeeded.");
        } else {
            logMetacat.warn((Object)"Metacat put(): Unknown Ecogrid data type. The data type is 'data' or 'metadata'.");
            throw new RemoteException("Unknown Ecogrid data type. The data type is 'data' or 'metadata'.");
        }
        return putServiceResponseElementType;
    }

    private void UploadMetacatData(byte[] byArray, String string, String string2, String string3) throws RemoteException {
        logMetacat.info((Object)"UploadMetacatData()");
        int n = byArray.length;
        try {
            String string4;
            MetacatClient metacatClient = (MetacatClient)MetacatFactory.createMetacatConnection((String)uploadMetacatURL);
            metacatClient.setSessionId(string3);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
            if (string2 == null || string2.length() == 0) {
                string2 = "rawdata";
            }
            if ((string4 = metacatClient.upload(string, string2, (InputStream)byteArrayInputStream, n)).indexOf("<success>") == -1 || string4.indexOf(string) == -1) {
                logMetacat.warn((Object)("UploadMetacatData() exception: " + string4));
                throw new RemoteException(string4);
            }
        }
        catch (Exception exception) {
            logMetacat.warn((Object)("UploadMetacatData() exception: " + exception.getMessage()));
            throw new RemoteException(exception.getMessage());
        }
    }

    private void UploadMetacatMetadata(byte[] byArray, String string, String string2) throws RemoteException {
        logMetacat.info((Object)"UploadMetacatMetadata()");
        try {
            MetacatClient metacatClient = (MetacatClient)MetacatFactory.createMetacatConnection((String)uploadMetacatURL);
            metacatClient.setSessionId(string2);
            String string3 = new String(byArray);
            int n = this.getRev(string);
            String string4 = null;
            if (n == 1) {
                string4 = metacatClient.insert(string, (Reader)new StringReader(string3), null);
            } else if (n > 1) {
                try {
                    string4 = metacatClient.update(string, (Reader)new StringReader(string3), null);
                }
                catch (Exception exception) {
                    string4 = metacatClient.insert(string, (Reader)new StringReader(string3), null);
                }
            } else {
                throw new RemoteException("Specified docid is incorrect");
            }
            if (string4.indexOf("<success>") == -1 || string4.indexOf(string) == -1) {
                logMetacat.warn((Object)("UploadMetacatMetadata() exception: " + string4));
                throw new RemoteException(string4);
            }
        }
        catch (Exception exception) {
            logMetacat.warn((Object)("UploadMetacatMetadata() exception: " + exception.getMessage()));
            throw new RemoteException(exception.getMessage());
        }
    }

    private int getRev(String string) throws RemoteException {
        int n = -1;
        String string2 = null;
        if (string == null) {
            throw new RemoteException("Specified docid couldn't be null");
        }
        String string3 = ".";
        int n2 = string.lastIndexOf(string3);
        string2 = string.substring(n2 + 1, string.length());
        n = Integer.parseInt(string2);
        logMetacat.info((Object)("after parsing accessionnumber, rev is " + n));
        return n;
    }

    static {
        try {
            String string = SystemUtil.getServletURL();
            if (string != null && string.length() > 0) {
                uploadMetacatURL = string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

