/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.AbstractQueue;
import edu.emory.mathcs.backport.java.util.Queue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConcurrentLinkedQueue
extends AbstractQueue
implements Queue,
Serializable {
    private static final long serialVersionUID = 196745693267521676L;
    private final Object headLock;
    private final Object tailLock;
    private volatile transient Node head;
    private volatile transient Node tail;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean casTail(Node cmp, Node val) {
        Object object = this.tailLock;
        synchronized (object) {
            if (this.tail == cmp) {
                this.tail = val;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean casHead(Node cmp, Node val) {
        Object object = this.headLock;
        synchronized (object) {
            if (this.head == cmp) {
                this.head = val;
                return true;
            }
            return false;
        }
    }

    public boolean add(Object e) {
        return this.offer(e);
    }

    public boolean offer(Object e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Node n = new Node(e, null);
        while (true) {
            Node t = this.tail;
            Node s = t.getNext();
            if (t != this.tail) continue;
            if (s == null) {
                if (!t.casNext(s, n)) continue;
                this.casTail(t, n);
                return true;
            }
            this.casTail(t, s);
        }
    }

    public Object poll() {
        Object item;
        Node first;
        while (true) {
            Node h = this.head;
            Node t = this.tail;
            first = h.getNext();
            if (h != this.head) continue;
            if (h == t) {
                if (first == null) {
                    return null;
                }
                this.casTail(t, first);
                continue;
            }
            if (this.casHead(h, first) && (item = first.getItem()) != null) break;
        }
        first.setItem(null);
        return item;
    }

    public Object peek() {
        while (true) {
            Node h = this.head;
            Node t = this.tail;
            Node first = h.getNext();
            if (h != this.head) continue;
            if (h == t) {
                if (first == null) {
                    return null;
                }
                this.casTail(t, first);
                continue;
            }
            Object item = first.getItem();
            if (item != null) {
                return item;
            }
            this.casHead(h, first);
        }
    }

    Node first() {
        while (true) {
            Node h = this.head;
            Node t = this.tail;
            Node first = h.getNext();
            if (h != this.head) continue;
            if (h == t) {
                if (first == null) {
                    return null;
                }
                this.casTail(t, first);
                continue;
            }
            if (first.getItem() != null) {
                return first;
            }
            this.casHead(h, first);
        }
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.first() == null) {
            bl = true;
        }
        return bl;
    }

    public int size() {
        int count = 0;
        Node p = this.first();
        while (p != null) {
            if (p.getItem() != null && ++count == Integer.MAX_VALUE) break;
            p = p.getNext();
        }
        return count;
    }

    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        Node p = this.first();
        while (p != null) {
            Object item = p.getItem();
            if (item != null && o.equals(item)) {
                return true;
            }
            p = p.getNext();
        }
        return false;
    }

    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        Node p = this.first();
        while (p != null) {
            Object item = p.getItem();
            if (item != null && o.equals(item) && p.casItem(item, null)) {
                return true;
            }
            p = p.getNext();
        }
        return false;
    }

    public Object[] toArray() {
        ArrayList<Object> al = new ArrayList<Object>();
        Node p = this.first();
        while (p != null) {
            Object item = p.getItem();
            if (item != null) {
                al.add(item);
            }
            p = p.getNext();
        }
        return al.toArray();
    }

    public Object[] toArray(Object[] a) {
        int k = 0;
        Node p = this.first();
        while (p != null && k < a.length) {
            Object item = p.getItem();
            if (item != null) {
                a[k++] = item;
            }
            p = p.getNext();
        }
        if (p == null) {
            if (k < a.length) {
                a[k] = null;
            }
            return a;
        }
        ArrayList<Object> al = new ArrayList<Object>();
        Node q = this.first();
        while (q != null) {
            Object item = q.getItem();
            if (item != null) {
                al.add(item);
            }
            q = q.getNext();
        }
        return al.toArray(a);
    }

    public Iterator iterator() {
        return new Itr();
    }

    private final void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Node p = this.first();
        while (p != null) {
            Object item = p.getItem();
            if (item != null) {
                s.writeObject(item);
            }
            p = p.getNext();
        }
        s.writeObject(null);
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object item;
        s.defaultReadObject();
        this.tail = this.head = new Node(null, null);
        while ((item = s.readObject()) != null) {
            this.offer(item);
        }
    }

    private final /* synthetic */ void this() {
        this.headLock = new SerializableLock();
        this.tailLock = new SerializableLock();
        this.tail = this.head = new Node(null, null);
    }

    public ConcurrentLinkedQueue() {
        this.this();
    }

    public ConcurrentLinkedQueue(Collection c) {
        this.this();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    private static class Node {
        private volatile Object item;
        private volatile Node next;

        Object getItem() {
            return this.item;
        }

        synchronized boolean casItem(Object cmp, Object val) {
            if (this.item == cmp) {
                this.item = val;
                return true;
            }
            return false;
        }

        synchronized void setItem(Object val) {
            this.item = val;
        }

        Node getNext() {
            return this.next;
        }

        synchronized boolean casNext(Node cmp, Node val) {
            if (this.next == cmp) {
                this.next = val;
                return true;
            }
            return false;
        }

        synchronized void setNext(Node val) {
            this.next = val;
        }

        Node(Object x) {
            this.item = x;
        }

        Node(Object x, Node n) {
            this.item = x;
            this.next = n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Itr
    implements Iterator {
        private Node nextNode;
        private Object nextItem;
        private Node lastRet;

        private final Object advance() {
            Node p;
            this.lastRet = this.nextNode;
            Object x = this.nextItem;
            Node node = p = this.nextNode == null ? ConcurrentLinkedQueue.this.first() : this.nextNode.getNext();
            while (true) {
                if (p == null) {
                    this.nextNode = null;
                    this.nextItem = null;
                    return x;
                }
                Object item = p.getItem();
                if (item != null) {
                    this.nextNode = p;
                    this.nextItem = item;
                    return x;
                }
                p = p.getNext();
            }
        }

        public boolean hasNext() {
            boolean bl = false;
            if (this.nextNode != null) {
                bl = true;
            }
            return bl;
        }

        public Object next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            return this.advance();
        }

        public void remove() {
            Node l = this.lastRet;
            if (l == null) {
                throw new IllegalStateException();
            }
            l.setItem(null);
            this.lastRet = null;
        }

        Itr() {
            this.advance();
        }
    }

    private static class SerializableLock
    implements Serializable {
        private SerializableLock() {
        }
    }
}

