/**
 *  '$RCSfile: EcogridUtilsNamedNodeIterator.java,v $'
 *  Copyright: 2004 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *  Purpose: To test the MetaCatURL class by JUnit
 *    Authors: @Rod Spears@
 *    Release: @release@
 *
 *   '$Author: rspears $'
 *     '$Date: 2004-10-21 17:54:09 $'
 * '$Revision: 1.1 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.ecoinformatics.ecogrid;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import java.util.*;

/**
 * Utility class that enables the iteration of all the nodes of the same name for a given parent node
 */
public class EcogridUtilsNamedNodeIterator
{
    private Vector mNodeList = new Vector();
    private int    mInx      = 0;
    
    /**
     * Constructor
     * @param aParent the parent to be searched
     * @param aNodeName the name of the nodes to iterator over
     */
    public EcogridUtilsNamedNodeIterator(Node aParent, String aNodeName)
    {
        NodeList list = aParent.getChildNodes();
        if (list != null)
        {
            for (int i=0;i<list.getLength();i++) 
            {
                Node child = list.item(i);
                if (child != null)
                {
                    if (aNodeName.equals(child.getNodeName()))
                    {
                        mNodeList.addElement(child);
                    }
                }
            }
        }
    }
    
    /**
     * 
     * @return whether there are anymore nodes
     */
    public boolean hasMoreNodes()
    {
      return mNodeList.size() > 0 && mInx < mNodeList.size();
    }
    
    /**
     * 
     * @return Returns the next node in the iteration
     */
    public Node nextNode()
    {
        return (Node)mNodeList.elementAt(mInx++);
    }
}
