/**
 *    '$RCSfile: AuthenticatedQueryServiceClient.java,v $'
 *
 *     '$Author: leinfelder $'
 *       '$Date: 2008-01-17 23:08:49 $'
 *   '$Revision: 1.1 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2003 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.ecoinformatics.ecogrid.authenticatedqueryservice;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;

import org.ecoinformatics.ecogrid.authenticatedqueryservice.stub.AuthenticatedQueryService;
import org.ecoinformatics.ecogrid.authenticatedqueryservice.stub.AuthenticatedQueryServiceLocator;
import org.ecoinformatics.ecogrid.authenticatedqueryservice.stub.AuthenticatedQueryServicePortType;
import org.ecoinformatics.ecogrid.authenticatedqueryservice.stub.GetElementType;
import org.ecoinformatics.ecogrid.authenticatedqueryservice.stub.QueryElementType;

import org.ecoinformatics.ecogrid.queryservice.util.EcogridQueryParser;
import org.ecoinformatics.ecogrid.queryservice.util.EcogridResultsetTransformer;

import org.ecoinformatics.ecogrid.queryservice.query.QueryType;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author tao
 * 
 * This client will connect to ecogrid query factory service and performed query
 * and get method
 */
public class AuthenticatedQueryServiceClient {
	private AuthenticatedQueryServicePortType ecogrid;

	static Log log = LogFactory.getLog(AuthenticatedQueryServiceClient.class);

	/**
	 * Constructor create ecogrid client to connect given service url
	 * 
	 * @param serviceURL
	 * @throws Exception
	 */
	public AuthenticatedQueryServiceClient(URL serviceURL) throws Exception {

		// Get a reference to the EcoGridQueryLevelOneService Factory
		long startFactory = System.currentTimeMillis();

		AuthenticatedQueryServiceLocator loc = new AuthenticatedQueryServiceLocator();

		ecogrid = loc.getQuery(serviceURL);

		org.apache.axis.client.Stub stub = (org.apache.axis.client.Stub) ecogrid;

		stub.setTimeout(10000000);
		long endInstance = System.currentTimeMillis();

		log.debug("The time to create instance is =========== "
				+ (endInstance - startFactory) / 1000);

	}

	/**
	 * Constructor create ecogrid client to connect given service url
	 * 
	 * @param serviceURL
	 * @throws Exception
	 */
	public AuthenticatedQueryServiceClient(String serviceURL) throws Exception {
		this(new URL(serviceURL));
	}

	public static QueryType reader2QueryType(Reader queryText) {
		QueryType query = null;
		try {
			// create a parser
			EcogridQueryParser parser = new EcogridQueryParser(queryText);
			// get ecogrid query java object
			parser.parseXML();
			query = parser.getEcogridQuery();
		} catch (Exception e) {
			log.error("Error parsing the reader into QueryType object!  "
					+ e.getMessage());
			e.printStackTrace();
		}
		return query;
	}

	public ResultsetType query(QueryType query, String sessionId)
			throws Exception {
		QueryElementType aqet = new QueryElementType(query, sessionId);

		ResultsetType result = null;
		if (ecogrid != null) {
			long startQuery = System.currentTimeMillis();
			result = ecogrid.query(aqet);
			long endQuery = System.currentTimeMillis();
			log.debug("The authQuery time is =============="
					+ (endQuery - startQuery) / 1000);
		}
		return result;
	}

	public static void main(String[] args) {
		// if (args.length != 2 && args.length != 3)
		if (args.length < 2) {

			System.out
					.println("Usage: java  AuthenticatedQueryServiceClient <service url> <query_filename> (outputfile) [sessionId]");
			System.exit(0);
		}
		String GSH = args[0];
		String command = args[1];
		String outputfile = null;
		String sessionId = null;
		if (args.length == 3) {
			outputfile = args[2];
		}
		if (args.length == 4) {
			sessionId = args[3];
		}
		try {

			AuthenticatedQueryServiceClient client = 
				new AuthenticatedQueryServiceClient(GSH);

			String resultStr = null;

			File queryXMLFile = new File(command);
			FileReader xmlReader = new FileReader(queryXMLFile);

			ResultsetType result = null;
			if (sessionId != null) {
				result = client.query(
						AuthenticatedQueryServiceClient.reader2QueryType(xmlReader),
						sessionId);
			}

			System.out.println("Result done");

			// print out the result set
			resultStr = EcogridResultsetTransformer.toXMLString(result);
			System.out.println(resultStr);

			if (outputfile != null) {
				System.out.println("Creating outputfile: " + outputfile);
				File outFile = new File(outputfile);
				FileWriter outWriter = new FileWriter(outFile);
				PrintWriter w = new PrintWriter(outWriter);
				w.println(resultStr);
				w.flush();
				w.close();
			}

		} catch (Exception e) {
			System.err.println("Exception in main : " + e.getMessage());
			e.printStackTrace();
		}

	}// main
}
