/**
 *    '$RCSfile: EcogridFactoryPutClient.java,v $'
 *
 *     '$Author: berkley $'
 *       '$Date: 2007-09-07 18:02:37 $'
 *   '$Revision: 1.2 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2007 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.ecogrid.client;

import java.io.FileInputStream;
import java.net.URL;

import org.ecoinformatics.ecogrid.EcogridObjType;
import org.ecoinformatics.ecogrid.EcogridUtils;
import org.ecoinformatics.ecogrid.stub.EcoGridPutInterfaceLevelOnePortType;
import org.ecoinformatics.ecogrid.stub.service.EcoGridAuthInterfaceLevelOneServiceGridLocator;
import org.ecoinformatics.ecogrid.stub.service.EcoGridPutInterfaceLevelOneServiceGridLocator;
import org.globus.ogsa.utils.GridServiceFactory;
import org.gridforum.ogsi.Factory;
import org.gridforum.ogsi.LocatorType;
import org.gridforum.ogsi.OGSIServiceGridLocator;

/**
 * @author     tao 
 * This class is client to access a put service factory.
 */
public class EcogridFactoryPutClient
{
  private final static int QUERY_OPERATION = 1;
  private final static int GET_OPERATION = 2;

  private URL serviceURL = null;
  private EcoGridPutInterfaceLevelOnePortType ecogrid = null;

  /**
   *  The main program for the EcogridFactoryPutClient class
   *
   *@param  args  The command line arguments
   */
  public static void main(String[] args)
  {
    if(args.length < 5)
    {
      // System.out.println("Usage: java org.ecoinformatics.ecogrid.client.EcogridPutClient quer|get filename GSH");
      System.out.println("Usage: java org.ecoinformatics.ecogrid.client.EcogridPutClient obj_type filename ecogrid_obj_id sessionId GSH");
      System.out.println("       where obj_type is \"data\" or \"metadata\".");
      System.exit(0);
    }


    int objType = EcogridObjType.DATA;
    String strObjType = args[0];
    if(strObjType.compareToIgnoreCase("data") == 0)
    {
      objType = EcogridObjType.DATA;
    }
    else if(strObjType.compareToIgnoreCase("metadata") == 0)
    {
      objType = EcogridObjType.METADATA;
    }
    else
    {
      System.out.println("Unknow object type ==> " + args[0] + ". The object type is either \"data\" or \"metadata\".");
      System.exit(0);
    }

    try
    {
      // get argument
      String fileName = args[1];
      String ecogridObjId = args[2];
      String sessionId = args[3];
      URL GSH = new URL(args[4]);

      System.out.println("datatype is: " + objType);
      System.out.println("localfilename is: " + fileName);
      System.out.println("ecogrid object ID is:" + ecogridObjId);
      System.out.println("GSH is: " + GSH);

      // create a client object
      EcogridFactoryPutClient client = new EcogridFactoryPutClient(GSH);
      System.out.println("after creating client object");

      client.put(fileName, ecogridObjId, objType, sessionId);
      client.destroy();
    }
    catch(Exception e)
    {
      // System.out.println("Exception in main : "+ e.getMessage());
      e.printStackTrace();
    }

  }
  //main

  /**
   *  Consctuctor which will generate the port type
   *
   *@param  serviceGSH
   *@exception  Exception  Description of the Exception
   */
  public EcogridFactoryPutClient(URL serviceGSH)
    throws Exception
  {
//    this.serviceURL = serviceGSH;
    EcogridUtils.setDebug(true);
    // Get a reference to the EcoGridQueryLevelOneService Factory
    long startFactory = System.currentTimeMillis();
    OGSIServiceGridLocator gridLocator = new
        OGSIServiceGridLocator();
    Factory factory = gridLocator.getFactoryPort(serviceGSH);
    GridServiceFactory ecogridFactory = new
        GridServiceFactory(factory);
    long endFacotry = System.currentTimeMillis();
    EcogridUtils.debugMessage("The time to create factory is ============= " +
        (endFacotry - startFactory) / 1000, 30);
    // Create a new EcoGridQueryLevelOneService instance and get a reference
    // to its getEcoGridQueryLevelOneServicePort
    LocatorType locator = ecogridFactory.createService();
    EcoGridPutInterfaceLevelOneServiceGridLocator loc = new
        EcoGridPutInterfaceLevelOneServiceGridLocator();
    ecogrid = loc.getEcoGridPutInterfaceLevelOnePort(locator);
    org.apache.axis.client.Stub stub = (org.apache.axis.client.Stub)ecogrid;
    stub.setTimeout(10000000);
    long endInstance = System.currentTimeMillis();
    EcogridUtils.debugMessage("The time to create instance is =========== " +
        (endInstance - endFacotry) / 1000, 30);
  }

  /**
   *  Method to put a document which come from a file to ecogrid
   *
   *@param  fileName
   *@param  ecogridOgjId
   *@param  objType
   *@param  sessionId
   *@throws  Exception
   */
  public void put(String fileName, String ecogridOgjId, int objType, String sessionId)
    throws Exception
  {
    byte[] bytes;

    bytes = GetBytesFromFile(fileName);
    if(ecogrid != null)
    {
      ecogrid.put(bytes, ecogridOgjId, objType, sessionId);
    }
  }

  /**
   *  Method to put a document which comes from a byte array to ecogrid service
   *
   *@param  bytes
   *@param  ecogridOgjId
   *@param  objType
   *@param  sessionId
   *@throws  Exception
   */
  public void put(byte[] bytes, String ecogridOgjId, int objType, String sessionId)
    throws Exception
  {
    if(ecogrid != null)
    {
      ecogrid.put(bytes, ecogridOgjId, objType, sessionId);
    }
  }

  /**
   *  Method to destory the port type.
   *
   *@throws  Exception
   */
  public void destroy()
    throws Exception
  {
    if(ecogrid != null)
    {
      ecogrid.destroy();
    }
  }

  /*
   *  Method to get a byte arrary from a given file location
   */
  /**
   *@param  fileName  Description of the Parameter
   *@return           Description of the Return Value
   */
  private byte[] GetBytesFromFile(String fileName)
  {
    byte[] readBytes = new byte[2000];
    int n;
    int i;

    byte[] total_bytes = null;
    byte[] tmp_bytes = null;
    int cur_byte_cnt;
    try
    {
      FileInputStream file = new FileInputStream(fileName);
      n = file.read(readBytes, 0, 2000);
      cur_byte_cnt = 0;
      while(n > 0)
      {
        if(total_bytes == null)
        {
          total_bytes = new byte[n];
          for(i = 0; i < n; i++)
          {
            total_bytes[i] = readBytes[i];
          }
        }
        else
        {
          tmp_bytes = new byte[total_bytes.length];
          for(i = 0; i < total_bytes.length; i++)
          {
            tmp_bytes[i] = total_bytes[i];
          }

          total_bytes = null;
          total_bytes = new byte[tmp_bytes.length + n];
          for(i = 0; i < tmp_bytes.length; i++)
          {
            total_bytes[i] = tmp_bytes[i];
          }
          for(i = 0; i < n; i++)
          {
            total_bytes[tmp_bytes.length + i] = readBytes[i];
          }

          tmp_bytes = null;
        }

        n = file.read(readBytes, 0, 2000);
      }

      file.close();
    }
    catch(Exception e)
    {
      System.out.println("Exception in reading data from file: " + e.getMessage());
      System.exit(1);
    }

    return total_bytes;
  }


}

