package org.ecoinformatics.ecogrid.digir.impl.digirquery;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Vector;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.httpclient.DefaultMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import org.ecoinformatics.ecogrid.EcogridUtils;

import org.ecoinformatics.ecogrid.digir.impl.providerinfo.DigirSchemaMapping;
import org.ecoinformatics.ecogrid.digir.impl.providerinfo.ProviderInfo;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;

public class QueryFromDigirProvider implements Runnable {

   HttpClient client;
   ProviderInfo provider;
   String queryString;
   DigirResultsetTransformer resultsetTransformer;
   CountDownLatch latch;
    
   static Log logger = LogFactory.getLog(QueryFromDigirProvider.class.getName());

   public QueryFromDigirProvider( HttpClient client, ProviderInfo provider, String queryString, DigirResultsetTransformer resultsetTransformer, CountDownLatch latch ) {
        this.client = client;
        this.provider = provider;        
        this.queryString = queryString;
        this.resultsetTransformer = resultsetTransformer;
        this.latch = latch;
    }

    /* (non-Javadoc)
     * @see java.lang.Runnable#run()
     */
    public void run() {

       String url = provider.getUrl();

       logger.debug("query string: " + queryString);
        PostMethod method = new PostMethod( url );
        DefaultMethodRetryHandler retries = new DefaultMethodRetryHandler();
        retries.setRetryCount(2);
        method.setMethodRetryHandler( retries );

        NameValuePair[] postData = {
           new NameValuePair( "doc", queryString )
        };
        method.setRequestBody( postData );
        
        try {
           client.executeMethod( method );
            
           InputStream is = method.getResponseBodyAsStream();
           
           DocumentBuilderFactory parserFactory = DocumentBuilderFactory.newInstance();
           // I want a namespace aware dom so I can use getLocalName().
           parserFactory.setNamespaceAware( true );
           DocumentBuilder parser = parserFactory.newDocumentBuilder();
           
           Document d;
           d = parser.parse( is );
           d.normalize();
           
           NodeList records = d.getElementsByTagName( "record" );
           if ( records == null ) {
              return;
           }
           
           String system = provider.getUrl() + "?resource=" + provider.getResourceCode();
           String systemId = resultsetTransformer.addSystem( system );
           
           for ( int i = 0; i< records.getLength(); i++ ) {
              logger.debug("Extracting record number " + i );
              Node recordNode = records.item(i);
              
              String institutionCode = "";
              String collectionCode = "";
              String catalogNumber = "";
              
              HashMap returnFields = new HashMap();
              
              NodeList values = recordNode.getChildNodes();
              for ( int j=0; j<values.getLength();j++ ) {
                 Node recChildNode = values.item(j);
                 
                 if ( recChildNode == null || recChildNode.getNodeType() != Node.ELEMENT_NODE ) {
                    continue;
                 }
                 
                 String nodeLocalName = getNonNullStr( recChildNode.getLocalName() );
                 String nodePrefix = getNonNullStr( recChildNode.getPrefix() );
                 
                 String value = getNonNullStr(EcogridUtils.getNodeValue( recChildNode ));
                 
                 if ( nodeLocalName.equals( "InstitutionCode" ) ) {
                    institutionCode = value;
                 }
                 else if ( nodeLocalName.equals( "CollectionCode" ) ) {
                    collectionCode = value;
                 }
                 else if ( nodeLocalName.equals( "CatalogNumber" ) ) {
                    if ( catalogNumber.length() == 0 )
                       catalogNumber = value;
                 }
                 else if ( nodeLocalName.equals( "CatalogNumberText" ) ) {
                    if ( catalogNumber.length() == 0 )
                       catalogNumber = value;
                 }
                 
                 returnFields.put(nodeLocalName, value );
                 
              }
              
              String uniqueId = institutionCode + ":" + collectionCode + ":" + catalogNumber;
              
              resultsetTransformer.addRecord( systemId, uniqueId, returnFields );
              
           }
            
        }
        catch ( Exception e) {
           logger.fatal( "Exception occurred contacting url " + url, e );
        }
        finally {
        	logger.debug("Finished");
        	latch.countDown();
        	method.releaseConnection();
        }
        
    }
   /**
    * Simple helper to always return a non-null string for the name
    * @param aStr string to be returned
    */
   private static String getNonNullStr(String aStr)
   {
      if (aStr != null) {
         return aStr;
      }
      return "";
   }
  
}
