/**
 *  '$RCSfile: EcogridJavaToGEONJavaQueryTransformer.java,v $'
 *    Authors: Efrat Jaeger
 *
 *   '$Author: ruland $'
 *     '$Date: 2005-12-15 21:46:19 $'
 * '$Revision: 1.2 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ecoinformatics.ecogrid.geon.impl;

//import java.util.Hashtable;
import java.util.Vector;
//import java.util.Set;
//import java.util.TreeSet;
//import java.util.*;

//import org.apache.axis.types.URI;
import org.apache.log4j.Logger;

import org.ecoinformatics.ecogrid.queryservice.query.ANDType;
import org.ecoinformatics.ecogrid.queryservice.query.ConditionType;
//import org.ecoinformatics.ecogrid.queryservice.query.LimitedXPathExpression;
import org.ecoinformatics.ecogrid.queryservice.query.OperatorType;
import org.ecoinformatics.ecogrid.queryservice.query.ORType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryTypeNamespace;

public class EcogridJavaToGEONJavaQueryTransformer
{

	private static Logger logger = Logger.getLogger("EcogridJavaToGEONJavaQueryTransformer");

  public EcogridJavaToGEONJavaQueryTransformer() {
  }
  /** Transform ecogrid query to geon query format.
   * 
   * @param ecogridQuery
   * @return
   * @throws Exception
   */
  public String[] transform(QueryType ecogridQuery) throws Exception {
    logger.warn("in the begin of transform");
    StringBuffer header = new StringBuffer();
    header.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
    header.append(
      "<query xmlns=\"http://www.sdsc.geongrid.org/services/search\" >\n");
    StringBuffer formats = new StringBuffer();
    getReturnFormats(ecogridQuery, formats); 
    String keyword = null;
    logger.warn("before getCondition");
    if (ecogridQuery.getCondition () != null) {
      ConditionType condition = ecogridQuery.getCondition();
      keyword = condition.get_value();
      logger.warn("keyword = " + keyword);
    } else {
       logger.warn("Wrong query format no condition specified");
       return null;
    }
    logger.warn("after getCondition");
    Vector queriesVec = new Vector();
    StringBuffer queryStr = new StringBuffer();
    if (keyword != null && !keyword.equals("")) {
      if (keyword.equals("%")) keyword = ""; // search for everything.
      logger.warn("handle keywod condition");
      queryStr.append(header.toString());
      queryStr.append(formats.toString());
      queryStr.append("    <keywords>\n");
      queryStr.append("        <keyword>" + keyword + "</keyword>\n");
      queryStr.append("    </keywords>\n");
      queryStr.append("</query>\n");
      logger.warn("after handling keywod condition");
      queriesVec.add(queryStr.toString());

      logger.warn("handle subjects condition");
      String subjects[] = _subjects;
      if (!keyword.equals("")) { // if the search term is not empty search for substrings of subjects
        subjects = getMatchingSubjects(keyword);
      }
      if (subjects.length > 0) {
        queryStr = new StringBuffer();
        queryStr.append(header.toString());
        queryStr.append(formats.toString());
        queryStr.append("    <subjects>\n");
        for (int i=0; i<subjects.length; i++)
          queryStr.append("        <subject>" + subjects[i] + "</subject>\n");
        queryStr.append("    </subjects>\n");
        queryStr.append("</query>\n");
        logger.warn("after handling keywod condition");
        queriesVec.add(queryStr.toString());
      }
      String queries[] = new String[queriesVec.size()];
      queriesVec.toArray(queries);
      return queries;
    } else {
      logger.warn("Condition is null");
      return null;
    }
  }

  /** get DLESE ADN subjects matching keyword.*/
  private String[] getMatchingSubjects(String keyword) {
    logger.warn("get matching subjects");
    keyword.toLowerCase();
    //search whether the key word is contained within any of the subjects
    Vector subjects = new Vector();
    for (int i=0; i<_subjects.length; i++) {
      int ind = _subjects[i].toLowerCase().indexOf(keyword);
      if (ind > -1) {
        subjects.add(_subjects[i]);
      }
    }
    String subjArr[] = new String[subjects.size()];
    subjects.toArray(subjArr);
    return subjArr;
  }

    // set up return fields
  /** Get dataset formats to query for */ 
  private void getReturnFormats(QueryType ecogridQuery, StringBuffer formats) {
    logger.warn("get return formats");
    String formatList[] = ecogridQuery.getReturnField();
    if (formatList.length > 0) {
      formats.append("    <formats>\n");
      for (int i=0; i<formatList.length; i++)
        formats.append("        <format>" + formatList[i] + "</format>\n");
      formats.append("    </formats>\n");
    }
  }

  /** DLESE ADN 0.6.50 predefined subjects
   */
  private static final String _subjects[] = {"DLESE:Agricultural science",
      "DLESE:Atmospheric science","DLESE:Biological oceanography",
      "DLESE:Biology","DLESE:Chemical oceanography","DLESE:Chemistry",
      "DLESE:Climatology","DLESE:Cryology","DLESE:Ecology",
      "DLESE:Educational theory and practice","DLESE:Environmental science",
      "DLESE:Forestry","DLESE:Geochemistry","DLESE:Geologic time",
      "DLESE:Geology","DLESE:Geophysics",
      "DLESE:History and philosophy of science","DLESE:Human geography",
      "DLESE:Hydrology","DLESE:Mathematics","DLESE:Mineralogy or petrology",
      "DLESE:Natural hazards","DLESE:Other","DLESE:Paleontology",
      "DLESE:Physical geography","DLESE:Physical oceanography","DLESE:Physics",
      "DLESE:Policy issues","DLESE:Soil science","DLESE:Space science",
      "DLESE:Structural geology","DLESE:Technology"};
}
