/**
 *  '$RCSfile: GEONJavaToEcogridJavaResultsetTransformer.java,v $'
 *    Purpose: A Class that translates GEON query response to ecogrid format.
 *    Authors: Efrat Jaeger
 *    Release: @release@
 *
 *   '$Author: ruland $'
 *     '$Date: 2005-12-15 21:46:19 $'
 * '$Revision: 1.2 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ecoinformatics.ecogrid.geon.impl;

import org.apache.axis.types.URI;
import org.apache.xpath.XPathAPI;

import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeRecord;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadata;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeRecordReturnField;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadataRecordStructure;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadataRecordStructureReturnField;
//import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadataSystem;
//import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadataRecordStructure;
//import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadataRecordStructureReturnField;


import org.ecoinformatics.ecogrid.EcogridUtils;
import org.ecoinformatics.ecogrid.queryservice.util.EcogridResultsetFactory;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

import java.io.StringReader;
//import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
//import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
//import java.util.Hashtable;
import java.util.TreeSet;
//import java.util.Vector;

import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.log4j.Logger;

/**
 *  This class will transform a result set
 *  to ecogrid result set java object
 */
public class GEONJavaToEcogridJavaResultsetTransformer
{

	private TimeZone local;
	private static final String SYSTEM = "http://www.geongrid.org";
	private static Logger logger = Logger.getLogger("GEONJavaToEcogridJavaResultsetTransformer");
	private Map fieldNameIdMap;
	private int fieldCounter = 0;

	/**
	 * default constructor
	 */
	public GEONJavaToEcogridJavaResultsetTransformer()
	{
		EcogridUtils.setDebug(true);
		fieldNameIdMap = new HashMap();
		logger.warn("*** GEONJavaToEcogridJavaResultsetTransformer was created ****");
	}

   /**
    * method to transform geon result set java obejct to ecogrid result set
    * object.
    * @param geonResults  array of xml result contents
    */
   public ResultsetType transform(String[] geonResults) throws Exception
   {
      if (geonResults == null)
      {
      	logger.warn("*** Error - metacatResultset is NULL!");
        return null;
      }

      ResultsetType ecogridResult = new ResultsetType();
      // set system
      ecogridResult.setSystem(new URI("http://www.geongrid.org"));
      // set resultsetId  //FIXME:???
      ecogridResult.setResultsetId("adn0650");

      logger.warn("Set metadata");

      // set meta data
      ResultsetTypeResultsetMetadata metadata =
                                         new ResultsetTypeResultsetMetadata();
      // set send time
      local = TimeZone.getTimeZone(System.getProperty("user.timezone"));
      Calendar calendar = Calendar.getInstance(local);
      Date now = new Date();
      calendar.setTime(now);
      metadata.setSendTime(calendar);

      ResultsetTypeRecord recordList[] = createResultsetRecords(geonResults);
      // set record array to ecogrid result objec
      logger.warn("Set ecogrid record list.");
      ecogridResult.setRecord(recordList);

      //get result size
      int size = recordList.length;
      logger.warn("Query returned " + size + " records.");
     // if size is zero, it start 0
      if ( size == 0)
      {
         metadata.setStartRecord(size);
      }
      else
      {
        metadata.setStartRecord(1);
      }
      metadata.setEndRecord(size);
      metadata.setRecordCount(size);
      
      // Populate Metadata Structure with Field Mappings.
      ResultsetTypeResultsetMetadataRecordStructure recordStructure = new ResultsetTypeResultsetMetadataRecordStructure();
      Iterator fieldsIt = fieldNameIdMap.keySet().iterator();
      ResultsetTypeResultsetMetadataRecordStructureReturnField[] fields = new ResultsetTypeResultsetMetadataRecordStructureReturnField[ fieldNameIdMap.size() ];
      for( int i=0; i< fieldNameIdMap.size(); i++ ) {
         String key = (String) fieldsIt.next();
         fields[i] = EcogridResultsetFactory.createRecordStructReturnField( (String)fieldNameIdMap.get(key),
                                                                            null, key);
         logger.warn("name=" + key + ", id=" + (String)fieldNameIdMap.get(key));
      }
      recordStructure.setReturnField(fields);
      
      metadata.setRecordStructure(recordStructure);
      
      ecogridResult.setResultsetMetadata(metadata);

      return ecogridResult;
   } //transform


   /** Create result set records from the query results
    * @param geonResults
    * @return
    */
    private ResultsetTypeRecord[] createResultsetRecords(String[] geonResults) {
        Set ids = new TreeSet();
     	List resultRecords = new ArrayList();
     	for (int i=0; i<geonResults.length; i++) {
     		String xmlRes = geonResults[i];
     		try {
	     		DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
	     		dfactory.setNamespaceAware(false);
	     		InputSource in = new InputSource(new StringReader(xmlRes));
	     		Document doc = dfactory.newDocumentBuilder().parse(in);
	     		NodeList items = XPathAPI.selectNodeList(doc, "//item");
	     		for (int j=0; j<items.getLength(); j++) {
	     			ResultsetTypeRecord record = parseItem(items.item(j), ids);
	     			if (record != null) {
	     				resultRecords.add(record);
	     			}
	     		}
     		} catch (Exception ex) {
     			ex.printStackTrace();
     		}
     	}
     	ResultsetTypeRecord records[] = new ResultsetTypeRecord[resultRecords.size()];
     	for (int i=0; i<resultRecords.size(); i++) {
     		records[i] = (ResultsetTypeRecord)resultRecords.get(i);
     	}
     	return records;
     } // end of createResultsetRecords

    /** parse each result node to get id, title, and format
     *
     * @param item
     * @return
     */
    private ResultsetTypeRecord parseItem(Node item, Set ids) {

    	if (item == null) return null;
     	ResultsetTypeRecord record = new ResultsetTypeRecord();
        logger.warn("get item id");
        String identifier = ((Element)item).getAttribute("id");
        // check wheter this id was already process, if so return null.
        if (ids.contains(identifier)) {
        	logger.warn("already processed identifier " + identifier);
        	return null;
        }
        // if id was not yet processed add it to the list and process record.
        ids.add(identifier);
        record.setIdentifier(identifier);
        logger.warn("item id is " + identifier);

        ResultsetTypeRecordReturnField retFields[] = new ResultsetTypeRecordReturnField[3];
        logger.warn("get title " + identifier);
		NodeList titles = ((Element)item).getElementsByTagName("title");
		Node titleNode = titles.item(0).getFirstChild();
		String title = titleNode.getNodeValue();
		String fieldId = getFieldId("title");
		retFields[0] = EcogridResultsetFactory.createRecordReturnField(fieldId, title);

        logger.warn("get description " + identifier);
		NodeList descriptions = ((Element)item).getElementsByTagName("description");
		Node descriptionNode = descriptions.item(0).getFirstChild();
		String desc = descriptionNode.getNodeValue();
		fieldId = getFieldId("description");
        retFields[1] = EcogridResultsetFactory.createRecordReturnField(fieldId, desc);

        logger.warn("get format " + identifier);
        String format = ((Element)item).getAttribute("format");
		fieldId = getFieldId("format");
        retFields[2] = EcogridResultsetFactory.createRecordReturnField(fieldId, format);

        record.setReturnField(retFields);

     	//setting up record metadata
        // Setup system
        record.setSystem(SYSTEM);
        // set up identifier

  	  	Calendar calendar = Calendar.getInstance(local);
  	  	Date now = new Date();
  	  	calendar.setTime(now);

  	  	//set creation time to now..
  	  	record.setCreationDate(calendar);
  	  	//set modification time to now..
  	  	record.setLastModifiedDate(calendar);

  	  	return record;
    } //end of parseItem

    public String getFieldId(String fieldName)
    {
    	String fieldId = (String)fieldNameIdMap.get(fieldName);
    	if (fieldId == null) {
    		fieldId = "f" + fieldCounter;
    		fieldNameIdMap.put(fieldName, fieldId);
    		fieldCounter++;
      }
      return fieldId;
    }
    

}
