/**
 *  '$RCSfile: MetacatImpl.java,v $'
 *    Purpose: A Class that implements replication for metacat
 *  Copyright: 2000 Regents of the University of California and the
 *             National Center for Ecological Analysis and Synthesis
 *    Authors: Chad Berkley
 *    Release: @release@
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008-10-02 18:11:16 $'
 * '$Revision: 1.24 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ecoinformatics.ecogrid.metacat.impl;

import edu.ucsb.nceas.metacat.DBQuery;
import edu.ucsb.nceas.metacat.DBUtil;
import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.QuerySpecification;
import edu.ucsb.nceas.metacat.properties.PropertyService;

import org.apache.log4j.Logger;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType;
import org.ecoinformatics.ecogrid.queryservice.stub.QueryServicePortType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryTypeNamespace;



import java.io.File;
import java.io.FileInputStream;
import java.rmi.RemoteException;

import java.io.PrintWriter;
import java.io.StringReader;

 /**
  * The class implements ecogrid query and get method for metacat
  */
public class MetacatImpl implements QueryServicePortType
{

  //  path to store the xml document
  private static final String XMLFILEPATH = "@xml.file.path@";
  private static final String DATAFILEPATH = "@data.file.path@";
  private static Logger logMetacat = Logger.getLogger(MetacatImpl.class);
  public MetacatImpl()
  {
                //super("Simple Metacat Factory Service");
  }

  /**
   * Implementation of query type
   */
   public ResultsetType query(QueryType query)
                             throws RemoteException
   {
      logMetacat.warn("start query method in grid service");
      ResultsetType records = new ResultsetType();

    try
    {
      // create a query transfer
      EcogridJavaToMetacatJavaQueryTransformer queryTransformer = new
                          EcogridJavaToMetacatJavaQueryTransformer();
      logMetacat.warn("before transforming query");
      QuerySpecification metacatQuery = queryTransformer.transform(query);
      logMetacat.warn("after transforming query");
      // run metacat query
      logMetacat.warn("before creating a DBQuery object");
       //DBQuery metacat = new DBQuery(saxparser);
      DBQuery metacat = new DBQuery();
      logMetacat.warn("before DBQuery object searching metacat");
      boolean useXMLIndex = (new Boolean(PropertyService.getProperty("database.usexmlindex")))
               .booleanValue();
      String xmlquery = "query"; // we don't care the query in resultset,
                                 // the query can be anything
      PrintWriter out = null;   // we don't want the result print out, so set
                                // out null
      String user = "public";   // now only search for public
      String[] groups = null;
      // parameter: queryspecification, user, group, usingIndexOrNot
      StringBuffer result = metacat.createResultDocument(xmlquery, metacatQuery,
                                                out, user, groups, useXMLIndex);

      logMetacat.warn("after DBQuery object searching meatacat");
      // create result set tansfer
      /*MetacatJavaToEcogridJavaResultsetTransformer resultTransformer =
                       new MetacatJavaToEcogridJavaResultsetTransformer();*/
      String saxparser = PropertyService.getProperty("xml.saxparser");
      QueryTypeNamespace[] namespaces = query.getNamespace();
		String[] namespaceStrings = new String[namespaces.length];
		for (int i = 0; i < namespaces.length; i++) {
			namespaceStrings[i] = namespaces[i].get_value();
		}
      MetacatResultsetParser parser = new MetacatResultsetParser(
                                new StringReader(result.toString()), saxparser, namespaceStrings);
      records = parser.getEcogridResult();
      //records = resultTransformer.transform(result);
      logMetacat.warn("after searching result transforming to" +
                                " ecogrid result java object");
    }//try
    catch (Exception e)
    {
      logMetacat.warn("The exception is: " + e.getMessage());
      throw new RemoteException(e.getMessage());
    }//catch
    return records;
  }//query

  /**
   * Implementation of get method
   */
  public byte[] get(String identifier) throws RemoteException
  {
    byte[] output;

    if (identifier == null)
    {
      throw new RemoteException("Please sepcify the identifier");
    }
    logMetacat.warn("in get method");
    logMetacat.warn("identifier is " + identifier);

    // get credential
    try
    {
      //modify the source host for metacat
      String user = "public";
      String[] groups = null;
      output = getOuputArrayFromMetacat(identifier, user, groups);
      //instantial a transfer object
      logMetacat.warn("after get output array");
      }//try
    catch (Exception e)
    {
      logMetacat.warn("in exception e" + e.getMessage());
      throw new RemoteException(e.getMessage());
    }//catch
    // start copy
    return output;
  }//get

  /*
   * Read a docid from metacat and write it to output stream
   */
  private byte[] getOuputArrayFromMetacat(String docid, String user,
                                        String[] groups)
                                        throws Exception
  {
    byte[] content = null;
    try
    {
      DocumentImpl doc = new DocumentImpl(docid);
      //check the permission for read
      if (!DocumentImpl.hasReadPermission(user, groups, docid))
      {
        Exception e = new Exception("User " + user + " does not have permission"
                       +" to read the document with the docid " + docid);
        throw e;
      }

      if ( doc.getRootNodeID() == 0 )
      {
        // this is data file
        logMetacat.warn("In data file path");
        String filepath = PropertyService.getProperty("application.datafilepath");
        if(!filepath.endsWith("/"))
        {
          filepath += "/";
        }
        String filename = filepath + docid;
        File dataFile = new File(filename);
        int length = (new Long(dataFile.length())).intValue();
        logMetacat.warn("The size of file is: "+ length);
        content = new byte[length];
        FileInputStream fin = null;
        fin = new FileInputStream(dataFile);
        fin.read(content);
      }//if
      else
      {
        // write the document to the file
        logMetacat.warn("In xml path");
        boolean withInlineData = true;
        String xml = doc.toString(user, groups, withInlineData);
        content = xml.getBytes();
      }

    }
    catch (Exception except)
    {
      throw except;
    }
    return content;
  }
}
