/**
 *  '$RCSfile: EcogridResultsetTransformer.java,v $'
 *    Purpose: A Class that loads eml-access.xml file containing ACL 
 *             for a metadata document into relational DB
 *  Copyright: 2000 Regents of the University of California and the
 *             National Center for Ecological Analysis and Synthesis
 *    Authors: Jivka Bojilova
 *    Release: @release@
 *
 *   '$Author: ruland $'
 *     '$Date: 2005-12-15 21:18:45 $'
 * '$Revision: 1.8 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.ecoinformatics.ecogrid.queryservice.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

import javax.xml.namespace.QName;

import org.xml.sax.helpers.AttributesImpl;

import org.apache.axis.encoding.SerializationContext;

import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType;

/**
 * This class will transform Ecogrid Resultset object to xml string
 */
public class EcogridResultsetTransformer
{
  
  /**
   * Creates an XML document as a string from a resultset object
   * @param aRS
   * @return XML document as a string that represents the resultset
   */
  public static String toXMLString(ResultsetType resultset) throws IOException {
	  StringWriter w = new StringWriter();
	  toXMLString( resultset, w );
	  return w.toString();
  }

  public static void toXMLString( ResultsetType resultset, Writer w ) throws IOException {

	  SerializationContext ctx = new SerializationContext( w );
	  ctx.setPretty(true);
	  QName rootElement = ResultsetType.getTypeDesc().getXmlType();
	  AttributesImpl a = new AttributesImpl();
	  a.addAttribute("","xmlns","xmlns","xsd:string",rootElement.getNamespaceURI());
	  ctx.serialize( new QName( "","resultset"), a, resultset, null, new Boolean(true), new Boolean(false) );
	  w.flush();
	  w.close();

  }

}  //class
