/**
 *  '$RCSfile: RegistryEntryTypeParser.java,v $'
 *    Purpose: Parses Registry Entry objects from XML
 *  Copyright: 2008 Regents of the University of California and the
 *             National Center for Ecological Analysis and Synthesis
 *    Authors: Rod Spears
 *    Release: @release@
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008-01-27 21:59:23 $'
 * '$Revision: 1.1 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ecoinformatics.ecogrid.registry.util;

import java.io.Reader;

import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.ser.BeanDeserializer;
import org.apache.axis.message.SOAPHandler;

import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import org.ecoinformatics.ecogrid.registry.stub.RegistryEntryType;

/**
 * Converts a RegistryEntryType from XML to an object
 * 
 * @author Ben Leinfelder, based on R. Spears
 */

public class RegistryEntryTypeParser {

	/**
	 * Consumes the XML from a file and returns RegistryEntryType Object
	 * 
	 * @param aFileName
	 *            XML File representing the resultset
	 * @return RegistryEntryType
	 */
	public static RegistryEntryType parseXMLFile(String aFileName)
			throws SAXException {
		InputSource is = new InputSource(aFileName);
		return parse(is);
	}

	public static RegistryEntryType parseXML(Reader reader) throws SAXException {
		InputSource is = new InputSource(reader);
		return parse(is);
	}

	public static RegistryEntryType parse(InputSource is) throws SAXException {
		MessageContext mctx = new MessageContext(new AxisClient());
		DeserializationContext dctx = new DeserializationContext(is, mctx,
				"RegistryEntry");
		RegistryEntryTypeBuilder builder = new RegistryEntryTypeBuilder();
		dctx.replaceElementHandler(builder);
		dctx.parse();
		return builder.getRegistryEntryType();
	}

	/**
	 * For Testing
	 */
	public static void main(String[] args) throws Exception {
		RegistryEntryType entry = parseXMLFile(args[0]);
		entry.setDescription("I WAS CHANGED FROM THE CODE!!!!");
		String rsStr = RegistryEntryTypeTransformer.toXMLString(entry);
		System.out.println(rsStr);
	}
}

class RegistryEntryTypeBuilder extends SOAPHandler {

	private BeanDeserializer handler;

	public RegistryEntryTypeBuilder() {
	}

	public SOAPHandler onStartChild(String namespace, String localName,
			String prefix, Attributes attributes, DeserializationContext ctx)
			throws SAXException {

		// Should test that namespace and localName are both correct.

		handler = (BeanDeserializer) RegistryEntryType.getDeserializer("",
				RegistryEntryType.class, RegistryEntryType.getTypeDesc()
						.getXmlType());

		return handler;
	}

	public RegistryEntryType getRegistryEntryType() {
		return (RegistryEntryType) handler.getValue();
	}
}
