/**
 *  '$RCSfile: RegistryEntryTypeTransformer.java,v $'
 *    Purpose: Generates XML represenation of RegistryEntryType objects
 *             for a metadata document into relational DB
 *  Copyright: 2008 Regents of the University of California and the
 *             National Center for Ecological Analysis and Synthesis
 *    Authors: Ben Leinfelder
 *    Release: @release@
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008-01-30 22:05:54 $'
 * '$Revision: 1.2 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.ecoinformatics.ecogrid.registry.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

import javax.xml.namespace.QName;

import org.xml.sax.helpers.AttributesImpl;

import org.apache.axis.encoding.SerializationContext;

import org.ecoinformatics.ecogrid.registry.stub.RegistryEntryType;

/**
 * This class will transform RegistryEntryType object to xml string
 */
public class RegistryEntryTypeTransformer
{
  
  /**
   * Creates an XML document as a string from a RegistryEntryType object
   * @param aRS
   * @return XML document as a string that represents the RegistryEntryType
   */
  public static String toXMLString(RegistryEntryType entry) throws IOException {
	  StringWriter w = new StringWriter();
	  toXMLString( entry, w );
	  return w.toString();
  }

  public static void toXMLString( RegistryEntryType entry, Writer w ) throws IOException {

	  SerializationContext ctx = new SerializationContext( w );
	  ctx.setPretty(true);
	  QName rootElement = RegistryEntryType.getTypeDesc().getXmlType();
	  AttributesImpl a = new AttributesImpl();
	  a.addAttribute("","xmlns","xmlns:reg","xsd:string",rootElement.getNamespaceURI());
	  ctx.serialize( new QName( "","reg:RegistryEntry"), a, entry, null, new Boolean(true), new Boolean(false) );
	  w.flush();
	  w.close();

  }

}  //class
