<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>
<%@ page contentType="text/html" %>
<%@ page import="java.net.URL" %>
<%@ page import="java.net.MalformedURLException" %>
<%@ page import="java.util.Vector" %>
<%@ page import="org.w3c.dom.Document" %>
<%@ page import="org.w3c.dom.Node" %>
<%@ page import="org.w3c.dom.NodeList" %>

<%@ page import="org.ecoinformatics.ecogrid.EcogridUtils" %>
<%@ page import="org.ecoinformatics.ecogrid.registry.impl.EcogridJSPBeanFactory" %>
<%@ page import="org.ecoinformatics.ecogrid.registry.impl.EcogridJSPBeanIFace" %>
<%@ page import="org.ecoinformatics.ecogrid.registry.EcoRegInterface" %>
<%@ page import="org.ecoinformatics.ecogrid.registry.RegEntry" %>
<%@ page import="org.ecoinformatics.ecogrid.ResultsetType" %>

<jsp:useBean id="ecogridBeanFactory" class="org.ecoinformatics.ecogrid.registry.impl.EcogridJSPBeanFactory">
  <jsp:setProperty name="ecogridBeanFactory" property="*" />
</jsp:useBean>

<jsp:useBean id="regEntryBean" class="org.ecoinformatics.ecogrid.registry.RegEntry">
  <jsp:setProperty name="regEntryBean" property="*" />
</jsp:useBean>

<%
  EcogridJSPBeanIFace ecogridBean = ecogridBeanFactory.createEcogridJSPBean("GLOBUS");
  String urlStr = "http://kuecogrid.ittc.ku.edu:8080/ogsa/services/org/ecoinformatics/ecogrid/registry/EcoRegInterfaceService"; // testing only
  String siteStr = "kuecogrid.ittc.ku.edu";
  String srvPath = "ogsa";
  //String gUrl = "kuecogrid.ittc.ku.edu:8080/ogsa";

  //String siteStr = "localhost";
  //String srvPath = "axis";
  //String urlStr = "http://" + siteStr + ":8080/axis/services/EcoRegInterface";

  // This used in the form element for the "action"
  String gUrl = siteStr + ":8080" + "/" + srvPath;
%>

<c:set var="isProcessing" value="true" />
<c:if test="${empty param.process}">
  <c:set var="isProcessing" value="false" />
</c:if>

<%
  ResultsetType resultset = null;
  String tableStr         = "";
  String queryStr         = request == null ? "" : (String)request.getParameter("queryStr"); 
  String resourceName     = request == null ? "" : (String)request.getParameter("resource"); 

  String qTitle    = request == null ? "" : (String)request.getParameter("title");
  String qNSPrefix = request == null ? "" : (String)request.getParameter("namespace_prefix");
  String qNameSpace = request == null ? "" : (String)request.getParameter("namespace");

  boolean isFirstTime     = queryStr == null || queryStr.length() == 0;

  resourceName = resourceName == null ? "" : resourceName;
  queryStr     = queryStr     == null ? "" : queryStr;
  qTitle       = qTitle       == null ? "" : qTitle;
  qNSPrefix    = qNSPrefix    == null ? "" : qNSPrefix;
  qNameSpace   = qNameSpace   == null ? "" : qNameSpace;


  StringBuffer fieldNameStr   = new StringBuffer();
  StringBuffer fieldValueStr  = new StringBuffer();
  StringBuffer comparatorStr  = new StringBuffer();
  StringBuffer conditionStr   = new StringBuffer();
  StringBuffer returnFieldStr = new StringBuffer();


  if (request != null) {
    String numCondsStr = (String)request.getParameter("numConds");
    int numConds = Integer.parseInt(numCondsStr == null ? "0" : numCondsStr);
    fieldNameStr.append( "var fieldNamesArray = [");
    fieldValueStr.append("var fieldValueArray = [");
    comparatorStr.append("var comparatorArray = [");
    conditionStr.append( "var conditionArray  = [");

    for (int i=0;i<numConds;i++) {
      String fieldName  = (String)request.getParameter("fieldNames_"+i);
      if (i > 0) {
        fieldNameStr.append(", ");
      }
      fieldNameStr.append("\"");
      fieldNameStr.append(fieldName == null ? "" : fieldName);
      fieldNameStr.append("\"");

      String fieldValue = (String)request.getParameter("fieldValues_"+i);
      if (i > 0) {
        fieldValueStr.append(", ");
      }
      fieldValueStr.append("\"");
      fieldValueStr.append(fieldValue == null ? "" : fieldValue);
      fieldValueStr.append("\"");

      String comparator = (String)request.getParameter("comparators_"+i);
      if (i > 0) {
        comparatorStr.append(", ");
      }
      comparatorStr.append("\"");
      comparatorStr.append(comparator == null ? "" : comparator);
      comparatorStr.append("\"");

      String condition = (String)request.getParameter("conditions_"+i);
      if (i > 0) {
        conditionStr.append(", ");
      }
      conditionStr.append("\"");
      conditionStr.append(condition == null ? "" : condition);
      conditionStr.append("\"");

    }

    fieldNameStr.append("];");
    fieldValueStr.append("];");
    comparatorStr.append("];");
    conditionStr.append("];");

    String numReturnsStr = (String)request.getParameter("numReturns");
    int numReturns = Integer.parseInt(numReturnsStr == null ? "0" : numReturnsStr);
    returnFieldStr.append("var returnFieldsArray = [");
    for (int i=0;i<numReturns;i++) {
      String returnField = (String)request.getParameter("returnFields_"+i);
      if (i > 0) {
        returnFieldStr.append(", ");
      }
      returnFieldStr.append("\"");
      returnFieldStr.append(returnField == null ? "" : returnField);
      returnFieldStr.append("\"");
    }
    returnFieldStr.append("];");
  }

%>
<c:if test="${param.process eq 'XXX'}">
<%
  tableStr = "<table width=\"100%\"><tr><td bgcolor=\"#5B89BB\"><span class=titlebar>Query Results:</span></td></tr></table><br>";

  boolean retVal = ecogridBean.getEntry(urlStr, resourceName, regEntryBean);
  if (retVal)
  {
    // XXX resultset = null;
    resultset = ecogridBean.query(regEntryBean.getRegAddr(), queryStr);
    if (resultset == null) {
      tableStr += "<span style=\"color:red;font-weight:bold\">Error performing query - resultset was NULL!<br>";
      tableStr += "  " + ecogridBean.getErrorMsg() + "</span><br>";

    } else {
      //tableStr += "Query succeeded!<br><br>";
      tableStr += ecogridBean.formatResultsetToHTMLTable(resultset);
    }
  }
  else
  {
    tableStr += "<span style=\"color:red;font-weight:bold\">Registry Entry was null for some reason!</span>";
  }
  tableStr += "<br><br><table width=\"100%\"><tr><td bgcolor=\"#5B89BB\"><span class=titlebar>End Query Results</span></td></tr></table><br>";
%>
</c:if>
<%
  StringBuffer resSelect = new StringBuffer();
  resSelect.append( "var resourceSelectArray = [");

  // XXX String       xmlStr  = "<listing><name>Digir</name></listing>";
  String       xmlStr  = ecogridBean.getXMLListing(urlStr);
  Document     dom     = EcogridUtils.convertXMLStr2DOM(xmlStr);

  int numEntries = 0;
  if (dom != null)
  {
    Node listing = EcogridUtils.findNode(dom, "listing");
    if (listing != null) 
    {
      NodeList list = listing.getChildNodes();
      numEntries = list.getLength();
    }
  }


  boolean ok = false;
  int selectedIndex = -1;
  int cnt = 0;

  if (dom != null)
  {
    Node listing = EcogridUtils.findNode(dom, "listing");
    if (listing != null) 
    {
      NodeList list = listing.getChildNodes();
      ok = list.getLength() > 0;
      for (int i=0;i<list.getLength();i++) 
      {
        Node child = list.item(i);
        if (child != null && child.getNodeType() != Node.TEXT_NODE)
        {
          String name = EcogridUtils.findNodeValue(child, "name");

          String selected = "";
          if (resourceName.compareTo(name) == 0) {
            selectedIndex = i;
          }
          if (cnt > 0) {
            resSelect.append(", ");
          }
          resSelect.append("\""+name+"\"");
          cnt++;
        }
      }
    }
  }

  resSelect.append("];\nvar selectedIndex = " + selectedIndex + ";");
%>

<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<style>
  body     { font-family:arial; font-size:10pt;}
  fieldset table td { font-family:arial; font-size:10pt;}
  legend   { font-family:arial; font-size:10pt;}
  span.req { font-family:arial; font-size:8pt;color:gray; }
  span.titlebar { font-size:11pt; color:white; font-weight:bold;}
</style>
<title>Ecogrid Query Builder</title>
<script language="JavaScript">
var isFirstTime = "<%= isFirstTime %>";
<%= fieldNameStr.toString() %>
<%= fieldValueStr.toString() %>
<%= comparatorStr.toString() %>
<%= conditionStr.toString() %>
<%= returnFieldStr.toString() %>
<%= resSelect.toString() %>

</script>
<script language="JavaScript" src="searchScripts.js"></script>
</head>

<body onload="init('<%= qTitle %>',
                   '<%= qNameSpace %>', 
                   '<%= qNSPrefix %>',
                   '<%= gUrl %>');">

<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr>
    <td bgcolor="#314963" width=60><a href="http://pbi.ecoinformatics.org/"><img border="0" src="pbi_world.png"></a></td>
    <td bgcolor="#314963" align=center><a href="http://pbi.ecoinformatics.org/"><img border="0" src="seeklogo.png"></a></td>
    <td bgcolor="#314963" width=60>&nbsp;</td>
  </tr>
</table>
<br>
<br>
<!-- kuecogrid.ittc.ku.edu -->
  <center><font size=+2 color="#314963"><b>Ecogrid Query Builder</b></font></center>
<div id="boxes" style="position:relative;"></div>
<!-- <textarea id=debug cols=120 rows=30></textarea> -->
<%= tableStr %><br><br><br><br>
<a href="http://<%= siteStr %>:8080/<%= srvPath %>/query.jsp">Ecogrid Query Text Entry Form</a><br>
<a href="http://<%= siteStr %>:8080/<%= srvPath %>/registry.jsp">View/Edit the Ecogrid Registry.</a>


</body>
</html>
