<?xml version="1.0"?> 
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns="http://www.w3.org/TR/REC-html40" 
                version="1.0">

<xsl:output method="html" media-type="text/html" version="4.0" indent="yes"/>

<xsl:template match="*[local-name()='resultset']">
    <table border="1">
      <xsl:apply-templates select="resultsetMetadata"/>
    </table>
    <BR/>
    <table border="1">
      <xsl:apply-templates select="record"/>
    </table>
</xsl:template>

<xsl:template match="resultsetMetadata">
   <xsl:if test="position() = 1">
     <tr>
       <xsl:for-each select="*">
         <td align="center"><b><xsl:value-of select="name()"/></b></td>
       </xsl:for-each>
     </tr>
   </xsl:if>
  <tr>
     <xsl:for-each select="*">
       <td align="center"><xsl:value-of select="."/></td>
     </xsl:for-each>
  </tr>
</xsl:template>

<xsl:template match="record">

   <xsl:if test="position() = 1">
     <xsl:if test="count(*) > 0">
		   <tr>
         <xsl:for-each select="*">
           <td align="center"><b><xsl:value-of select="name()"/></b></td>
         </xsl:for-each>
       </tr>
     </xsl:if>
     <xsl:if test="count(*) = 0">
       <tr>
					<td align="center"><b>Record Number</b></td>
					<td align="center"><b>Identifer</b></td>
			 </tr>
			 <tr>
			 	 <td align="center"><xsl:value-of select="@number"/></td>
				 <td align="center"><xsl:value-of select="@identifier"/></td>
       </tr>
     </xsl:if>
   </xsl:if>

   <xsl:if test="position() != 1">
     <xsl:if test="count(*) > 0">
       <tr>
				 <xsl:for-each select="*">
						 <td align="center"><xsl:value-of select="."/></td>
				 </xsl:for-each>
       </tr>
     </xsl:if>
     <xsl:if test="count(*) = 0">
			 <tr>
			 	 <td align="center"><xsl:value-of select="@number"/></td>
				 <td align="center"><xsl:value-of select="@identifier"/></td>
       </tr>
     </xsl:if>
   </xsl:if>

</xsl:template>

</xsl:stylesheet>
