/**
 *  '$RCSfile: TestQueryAndResults.java,v $'
 *  Copyright: 2004 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *  Purpose: To test the MetaCatURL class by JUnit
 *    Authors: @Rod SPears@
 *    Release: @release@
 *
 *   '$Author: rspears $'
 *     '$Date: 2004-07-26 22:43:45 $'
 * '$Revision: 1.5 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
//package org.ecoinformatics.ecogrid.ecogridtest;

import edu.ucsb.nceas.metacat.*;
import junit.framework.TestCase;

import java.io.*;
import java.util.*;

import org.ecoinformatics.ecogrid.metacat.impl.EcogridJavaToMetacatJavaQueryTransformer;
//import org.ecoinformatics.ecogrid.metacat.impl.MetacatJavaToEcogridJavaResultsetTransformer;
import org.ecoinformatics.ecogrid.metacat.impl.MetacatResultsetParser;

import org.ecoinformatics.ecogrid.EcogridResultsetTransformer;
import org.ecoinformatics.ecogrid.digir.impl.EcogridJavaToDigirJavaQueryTransformer;
import org.ecoinformatics.ecogrid.digir.impl.DigirJavaToEcogridJavaResultsetTransformer;

//import org.ecoinformatics.ecogrid.srb.impl.SeekXMLQueryDocSRBParser;
//import org.ecoinformatics.ecogrid.srb.impl.SRB2ResultsetType;
//import org.ecoinformatics.ecogrid.srb.impl.SrbEcogridQuery;

import org.ecoinformatics.ecogrid.QueryType;
import org.ecoinformatics.ecogrid.ResultsetType;

import org.ecoinformatics.ecogrid.EcogridUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;


/**
 * A JUnit test for testing Query and Resultset Transforms
 */
public class TestQueryAndResults extends TestCase
{

    private boolean _doTests = true;//@DO.QUERYRESULTS.TESTS@;

    //MetaCatUtil.setSkipDBAdapterSetup(true);

    /**
      * Reads a ecogrid query, transforms it into a metacat query
      * @param aFileName Name of XML file containing EcoGrid Query
      */
    public boolean checkMetacatQuery(String aFileName) {
      try
      {
        QueryType query = EcogridUtils.readEcogridXMLQuery(aFileName);

        EcogridJavaToMetacatJavaQueryTransformer ecogrid2MetacatTransformer = new EcogridJavaToMetacatJavaQueryTransformer();
        QuerySpecification querySpec = ecogrid2MetacatTransformer.transform(query);

        System.out.println("\nMetacat------------------------------------------");
        System.out.println(querySpec.toString());
        System.out.println("-------------------------------------------------");
        System.out.println(querySpec.printSQL(true));
        System.out.println("-------------------------------------------------");

        // Need to create a DOM tree from the QuerySpecification and
        // compare that to a DOM tree to verify correctness
        //
        // do that <here>

      } 
      catch (Exception e) {
        System.out.println(e);
        return false;
      }

      return true;
    }

    /**
      * Reads a Metacat resultset, transforms it into a ecogrid resultset
      * @param aFileName Name of XML file containing Metacat Resultset
      */
    public boolean checkMetacatResultset(String aFileName, String aVerifyFileName) {
      try
      {
        // here we need to read in or construct a hashtable representing
        // a metacat resultset.
        Hashtable metacatResultset = null; // <create hashtable here>;

        String metacatResultsetStr = EcogridUtils.readXMLFile2Str(aFileName);
        System.out.println("\nMetacat's (native) resultset "+aFileName+" --------------------------------");
        System.out.println(metacatResultsetStr);
        System.out.println("-------------------------------------------------");

        String saxparser = "org.apache.xerces.parsers.SAXParser";
        MetacatResultsetParser parser = new MetacatResultsetParser(
                                new StringReader(metacatResultsetStr), saxparser);
        ResultsetType resultset = null;
        try {
          resultset = parser.getEcogridResult();
        } catch (Exception e) {
          e.printStackTrace();
        }

        if (resultset != null) 
        {
          System.out.println("\nMetacat's EcoGrid resultset--------------------------------------------");
          System.out.println(EcogridResultsetTransformer.toXMLString(resultset));
          System.out.println("-------------------------------------------------");
        }
        else
        {
          return false;
        }

        // The resultset should be turned into a DOM and compared to some 
        // XML file to verify that it is correct.

        // Create resultset DOM
        String xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        xmlString += EcogridResultsetTransformer.toXMLString(resultset);
        Document dom1 = EcogridUtils.convertXMLStr2DOM(xmlString);


        // Fix this
        //Document dom2 = EcogridUtils.readXMLFile2DOM(aVerifyFileName);
        //return EcogridUtils.compareDOMs(dom1, dom2, 0);

      } 
      catch (Exception e) {
        System.out.println(e);
        e.printStackTrace();
        return false;
      }

      return true;
    }

    /**
      * Reads a ecogrid query, transforms it into a SRB query
      * @param aFileName Name of XML file containing SRB query
      */
    /*public boolean checkSRBQuery(String aFileName) {
      try
      {
        QueryType query = EcogridUtils.readEcogridXMLQuery(aFileName);

        SeekXMLQueryDocSRBParser ecogrid2SRBTransformer = new SeekXMLQueryDocSRBParser();
        SrbEcogridQuery srbQuery = ecogrid2SRBTransformer.ParseQueryType(query);

        //System.out.println("\nSRB------------------------------------------");
        //System.out.println(srbQuery.toString());
        //System.out.println("-------------------------------------------------");

        // Need to create a DOM tree from the SrbEcogridQuery and
        // compare that to a DOM tree to verify correctness
        //
        // do that <here>

      } 
      catch (Exception e) {
        System.out.println(e);
        return false;
      }

      return true;
    }*/

    /**
      * Reads a SRB resultset, transforms it into a ecogrid resultset
      * @param aFileName Name of XML file containing SRB resultset
      */
    /*public boolean checkSRBResultset(String aFileName, String aVerifyFileName) {
      try
      {
        // here we need to read in or construct a hashtable representing
        // a SRB resultset.
        String[] srbResultset = null; // <create string array here>;

        SRB2ResultsetType srb2EcogridTransformer = new SRB2ResultsetType();
        ResultsetType resultset = srb2EcogridTransformer.transform(srbResultset);
        if (resultset != null) 
        {
          System.out.println("\nSRB's EcoGrid resultset--------------------------------------------");
          System.out.println(EcogridResultsetTransformer.toXMLString(resultset));
          System.out.println("-------------------------------------------------");
        }
        else
        {
          return false;
        }

        // The resultset should be turned into a DOM and compared to some 
        // XML file to verify that it is correct.

        // Create resultset DOM
        String xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        xmlString += EcogridResultsetTransformer.toXMLString(resultset);;
        Document dom1 = EcogridUtils.convertXMLStr2DOM(xmlString);


        // Fix this
        //Document dom2 = EcogridUtils.readXMLFile2DOM(aVerifyFileName);
        //return EcogridUtils.compareDOMs(dom1, dom2, 0);

      } 
      catch (Exception e) {
        System.out.println(e);
        return false;
      }

      return true;
    }*/

    /**
      * Reads a ecogrid query, transforms it into a digir query, then
      * comapres it to a known vaild query to make sure it is the same
      * @param aFileName Name of XML file containing EcoGrid Query
      * @param aVerifyFileName Name of XML file containing Digir Query
      */
    public boolean checkDigirQuery(String aFileName, String aVerifyFileName) {
      try
      {
        // Read in Ecogrid Query and transform it to a Digir Query
        QueryType query = EcogridUtils.readEcogridXMLQuery(aFileName);
        EcogridJavaToDigirJavaQueryTransformer ecogrid2DigirTransformer = new EcogridJavaToDigirJavaQueryTransformer();
        String digirQuery = ecogrid2DigirTransformer.transform(query);

        System.out.println("\nDigir --------------------------------------------");
        System.out.println(digirQuery);
        System.out.println("--------------------------------------------");

        String tmpFileName = "testfiles/query-digir-tmp.xml";

        File fin = new File(tmpFileName);
        FileWriter out = new FileWriter(fin);
        out.write(digirQuery, 0, digirQuery.length());
        out.close();

        return EcogridUtils.compareDOMs(aVerifyFileName, tmpFileName);
      } 
      catch (Exception e) {
        System.out.println(e);
      }
      return false;
    }

    /**
      * Reads a digir resultset, transforms it into a ecogrid resultset, then
      * comapres it to a known vaild resultset to make sure it is the same
      * @param aFileName Name of XML file containing EcoGrid Query
      * @param aVerifyFileName Name of XML file containing Digir Query
      */
    public boolean checkDigirResultset(String aInputFileName, String aVerifyFileName) {
      try
      {
        // Read in Ecogrid Query and transform it to a Digir Query
        String digirResultsetString = EcogridUtils.readXMLFile2Str(aInputFileName);

        //System.out.println("\nDigir Resultset --------------------------------------------");
        //System.out.println(digirResultsetString);
        //System.out.println("-------------------------------------------------");

        DigirJavaToEcogridJavaResultsetTransformer ecogrid2ResultTransformer = new DigirJavaToEcogridJavaResultsetTransformer();
        ResultsetType resultset = ecogrid2ResultTransformer.transform(digirResultsetString);

        if (resultset != null) 
        {
          System.out.println("\nDigir's EcoGrid resultset--------------------------------------------");
          System.out.println(EcogridResultsetTransformer.toXMLString(resultset));
          System.out.println("-------------------------------------------------");
        }
        else
        {
          return false;
        }

        String tmpFileName = "testfiles/resultset-digir-tmp.xml";

        String xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        xmlString += EcogridResultsetTransformer.toXMLString(resultset);;

        Document dom1 = EcogridUtils.convertXMLStr2DOM(xmlString);

        Document dom2 = EcogridUtils.readXMLFile2DOM(aVerifyFileName);

        return EcogridUtils.compareDOMs(dom1, dom2, 0, false);
      } 
      catch (Exception e) {
        System.out.println("***** checkDigirResultset: " + e);
      }
      return false;
    }

    
    /** Tests the Metacat Query Parser */
    public void testEcogridMetacatParser() 
    {
      if (_doTests)  
        assertTrue(checkMetacatQuery("testfiles/query-test.xml"));
    }

    /**  Checks to make sure the Metacat Query Parser fails */
    /*public void testEcogridMetacatParserError() 
    {
        
      if (_doTests)  
        assertFalse(checkMetacatQuery("testfiles/query-test-err.xml"));
    }*/

    /**  Checks to make sure the Metacat Resultset Transform works */
    /*public void testEcogridMetacatResultParser() 
    {
      if (_doTests)  
        assertTrue(checkMetacatResultset("testfiles/metacatresultset-test.xml", "<file name goes here>"));
    }*/

    /** Tests the Digir Query Parser */
    public void testEcogridDigirQueryParser() 
    {
      if (_doTests)  
        assertTrue(checkDigirQuery("testfiles/query-digir.xml", 
                                   "testfiles/digir-query-verify.xml"));
    }

    /**  Test to make sure the Digir Resultset transforms correctly*/
    public void testEcogridDigirResultParser() 
    {
        
      if (_doTests)  
        assertTrue(checkDigirResultset("testfiles/digir-resultset.xml", 
                                       "testfiles/resultset-digir-v2-verify.xml"));
    }

}
