/**
 *  '$RCSfile: PutServiceClientTest.java,v $'
 *  Copyright: 2004 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008-10-31 18:33:23 $'
 * '$Revision: 1.5 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.ecoinformatics.ecogrid.client;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.ecoinformatics.ecogrid.EcogridObjType;
import org.ecoinformatics.ecogrid.queryservice.QueryServiceGetToStreamClient;

/**
 * A JUnit test for testing the indexing routines for XML Paths
 */
public class PutServiceClientTest extends TestCase {
	private String username = "uid=test,o=NCEAS,dc=ecoinformatics,dc=org";
	private String password = "test";
	private String prefix = "test";
	private String authenURL = "http://dev.nceas.ucsb.edu/knb/services/AuthenticationService";
	private String putURL = "http://dev.nceas.ucsb.edu/knb/services/PutService";
	private String queryURL = "http://dev.nceas.ucsb.edu/knb/services/QueryService";
	private String sessionId = null;
	private String metadataFileName = "tests/testfiles/eml-sample-2.1.0.xml";
	private String dataFileName = "tests/testfiles/dataset.txt";
	private String metadataDocId = "";
	private String dataDocId = "";

	/**
	 * Constructor to build the test
	 * 
	 * @param name
	 *            the name of the test method
	 */
	public PutServiceClientTest(String name) {
		super(name);
	}

	/**
	 * Establish a testing framework by initializing appropriate objects
	 */
	public void setUp() {

	}

	/**
	 * Release any objects after tests are complete
	 */
	public void tearDown() {
	}

	/**
	 * Create a suite of tests to be run together
	 */
	public static Test suite() {
		TestSuite suite = new TestSuite();
		suite.addTest(new PutServiceClientTest("initialize"));
		suite.addTest(new PutServiceClientTest("putAndGetMetadata"));
		suite.addTest(new PutServiceClientTest("writeMetadataFileSuccess"));
		suite.addTest(new PutServiceClientTest("writeMetadataFileUnsucess"));
		suite.addTest(new PutServiceClientTest("writeDataFileSuccess"));
		suite.addTest(new PutServiceClientTest("writeDataFileUnsucess"));
		suite.addTest(new PutServiceClientTest("writeMetadataVector"));
		suite.addTest(new PutServiceClientTest("writeDataVector"));
		suite.addTest(new PutServiceClientTest("updateMetadata"));
		suite.addTest(new PutServiceClientTest("updateData"));

		return suite;
	}

	/**
	 * Run an initial test that always passes to check that the test harness is
	 * working.
	 */
	public void initialize() {
		assertTrue(1 == 1);
	}

	/**
	 * Method to test login success method
	 */
	public void loginSuccess() {
		try {
			// URL GSH = new URL(authenURL);
			// create a client object
			AuthenticationServiceClient client = new AuthenticationServiceClient(
					authenURL);
			// client.createEcoGridAuthLevelOnePortType();
			sessionId = client.login_action(username, password);
			assertFalse(sessionId.equals("an unknown error"));
		} catch (Exception e) {
			fail("Authentication exception:\n" + e.getMessage());
		}
	}// login

	/**
	 * Method to test logout method
	 */
	public void logout() {
		try {
			// create a client object
			AuthenticationServiceClient client = new AuthenticationServiceClient(
					authenURL);
			client.logout_action(sessionId);
			assertTrue(1 == 1);
		} catch (Exception e) {
			fail("Authentication exception:\n" + e.getMessage());
		}

	}

	public void putAndGetMetadata() {
		loginSuccess();
		try {
			// create a client object
			PutServiceClient client = new PutServiceClient(putURL);
			metadataDocId = generateDocid() + ".1";
			int objType = EcogridObjType.METADATA;
			System.err.println("doicd is " + metadataDocId);
			System.err.println("session id is " + sessionId);
			client.put(metadataFileName, metadataDocId, objType, sessionId);
			System.err.println("successfully insert metadata " + metadataDocId);
			readMetadata(metadataDocId);
			System.err.println("successfully read the same metadata "
					+ metadataDocId);
			assertTrue(1 == 1);
		} catch (Exception e) {
			fail("put and get excepiton:\n" + e.getMessage());
		}
		logout();
	}

	public void writeMetadataFileSuccess() {
		loginSuccess();
		try {
			// create a client object
			PutServiceClient client = new PutServiceClient(putURL);
			metadataDocId = generateDocid() + ".1";
			int objType = EcogridObjType.METADATA;
			System.err.println("doicd is " + metadataDocId);
			System.err.println("session id is " + sessionId);
			client.put(metadataFileName, metadataDocId, objType, sessionId);
			// readMetadata(metadataDocId);
			System.err.println("successfully insert metadata " + metadataDocId);
			assertTrue(1 == 1);
		} catch (Exception e) {
			fail("Write excepiton:\n" + e.getMessage());
		}
		logout();
	}

	public void writeMetadataFileUnsucess() {
		try {
			// create a client object
			PutServiceClient client = new PutServiceClient(putURL);
			String docId = generateDocid() + ".1";
			;
			int objType = EcogridObjType.METADATA;
			client.put(metadataFileName, docId, objType, sessionId);
			assertFalse(1 == 1);
		} catch (Exception e) {
			System.err.println("Public try to write metacat should fail:\n"
					+ e.getMessage());
			assertTrue(1 == 1);
		}

	}

	public void writeDataFileSuccess() {
		loginSuccess();
		try {
			// create a client object
			PutServiceClient client = new PutServiceClient(putURL);
			dataDocId = generateDocid() + ".1";
			;
			int objType = EcogridObjType.DATA;
			System.err.println("doicd is " + dataDocId);
			System.err.println("session id is " + sessionId);
			client.put(dataFileName, dataDocId, objType, sessionId);
			System.err.println("successfully insert data " + dataDocId);
			assertTrue(1 == 1);
		} catch (Exception e) {
			fail("Write excepiton:\n" + e.getMessage());
		}
		logout();
	}

	public void writeDataFileUnsucess() {
		try {
			// create a client object
			PutServiceClient client = new PutServiceClient(putURL);
			String docId = generateDocid() + ".1";
			;
			int objType = EcogridObjType.DATA;
			client.put(dataFileName, docId, objType, sessionId);
			assertFalse(1 == 1);
		} catch (Exception e) {
			System.err.println("public user should fail to load data:\n"
					+ e.getMessage());
			assertTrue(1 == 1);
		}

	}

	public void writeMetadataVector() {
		loginSuccess();
		try {
			// create a client object
			PutServiceClient client = new PutServiceClient(putURL);
			metadataDocId = generateDocid() + ".1"; // was 2
			int objType = EcogridObjType.METADATA;
			byte[] metadataVector = getBytesFromFile(metadataFileName);
			client.put(metadataVector, metadataDocId, objType, sessionId);
			// readMetadata(metadataDocId);
			System.err.println("successfully insert metadata " + metadataDocId);
			assertTrue(1 == 1);
		} catch (Exception e) {
			fail("Write excepiton:\n" + e.getMessage());
		}
		logout();
	}

	public void writeDataVector() {
		loginSuccess();
		try {
			// create a client object
			PutServiceClient client = new PutServiceClient(putURL);
			dataDocId = generateDocid() + ".2";
			int objType = EcogridObjType.DATA;
			byte[] dataVector = getBytesFromFile(dataFileName);
			client.put(dataVector, dataDocId, objType, sessionId);
			System.err.println("successfully insert data " + dataDocId);
			assertTrue(1 == 1);
		} catch (Exception e) {
			fail("Write excepiton:\n" + e.getMessage());
		}
		logout();

	}

	public void updateMetadata() {
		loginSuccess();
		try {
			// create a client object
			PutServiceClient client = new PutServiceClient(putURL);
			String newId = generateDocid();
			metadataDocId = newId + ".1";
			int objType = EcogridObjType.METADATA;
			System.err.println("doicd is " + metadataDocId);
			System.err.println("session id is " + sessionId);
			client.put(metadataFileName, metadataDocId, objType, sessionId);
			// readMetadata(metadataDocId);
			System.err.println("successfully insert metadata " + metadataDocId);
			try {
				System.out
						.println("waiting for metacat before trying the update");
				// let the metacat instance churn on the new doc id...some index
				// building or such?
				Thread.sleep(3000);
			} catch (Exception e) {
				e.printStackTrace();
			}

			metadataDocId = newId + ".2";
			System.err.println("doicd is " + metadataDocId);
			System.err.println("session id is " + sessionId);
			client.put(metadataFileName, metadataDocId, objType, sessionId);
			System.err.println("successfully update metadata " + metadataDocId);
			// readMetadata(metadataDocId);
			assertTrue(1 == 1);
		} catch (Exception e) {
			fail("Write excepiton:\n" + e.getMessage());
		}
		logout();
	}

	public void updateData() {
		loginSuccess();
		try {
			// create a client object
			PutServiceClient client = new PutServiceClient(putURL);
			String newId = generateDocid();
			dataDocId = newId + ".1";
			int objType = EcogridObjType.DATA;
			System.err.println("data doicd is " + dataDocId);
			System.err.println("session id is " + sessionId);
			client.put(dataFileName, dataDocId, objType, sessionId);
			System.err.println("successfully insert data " + dataDocId);
			try {
				System.out
						.println("waiting for metacat before trying the update");
				// let the metacat instance churn on the new doc id...some index
				// building or such?
				Thread.sleep(3000);
			} catch (Exception e) {
				e.printStackTrace();
			}
			dataDocId = newId + ".2";
			System.err.println("doicd is " + dataDocId);
			System.err.println("session id is " + sessionId);
			client.put(dataFileName, dataDocId, objType, sessionId);
			System.err.println("successfully updated data " + dataDocId);
			assertTrue(1 == 1);
		} catch (Exception e) {
			fail("Write excepiton:\n" + e.getMessage());
		}
		logout();
	}

	private void readMetadata(String id) {
		try {
			// create a client object
			URL GSH = new URL(queryURL);
			QueryServiceGetToStreamClient client = new QueryServiceGetToStreamClient(
					GSH);
			ByteArrayOutputStream bytes = new ByteArrayOutputStream();
			client.get(id, bytes);
			assertNotNull(bytes);
			assertTrue(bytes.size() > 0);

			// view it if we want
			client.get(id, System.out);

		} catch (Exception e) {
			fail("Failed to get doc:\n" + e.getMessage());
		}

	}

	/**
	 * Create a hopefully unique docid for testing insert and update. Does not
	 * include the 'revision' part of the id.
	 * 
	 * @return a String docid based on the current date and time
	 */
	private String generateDocid() {
		StringBuffer docid = new StringBuffer(prefix);
		docid.append(".");

		// Create a calendar to get the date formatted properly
		String[] ids = TimeZone.getAvailableIDs(-8 * 60 * 60 * 1000);
		SimpleTimeZone pdt = new SimpleTimeZone(-8 * 60 * 60 * 1000, ids[0]);
		pdt
				.setStartRule(Calendar.APRIL, 1, Calendar.SUNDAY,
						2 * 60 * 60 * 1000);
		pdt.setEndRule(Calendar.OCTOBER, -1, Calendar.SUNDAY,
				2 * 60 * 60 * 1000);
		Calendar calendar = new GregorianCalendar(pdt);
		Date trialTime = new Date();
		calendar.setTime(trialTime);
		docid.append(calendar.get(Calendar.YEAR));
		docid.append(calendar.get(Calendar.DAY_OF_YEAR));
		docid.append(calendar.get(Calendar.HOUR_OF_DAY));
		docid.append(calendar.get(Calendar.MINUTE));
		docid.append(calendar.get(Calendar.SECOND));

		return docid.toString();
	}

	byte[] getBytesFromFile(String fileName) {
		byte[] readBytes = new byte[2000];
		int n, i;

		byte[] total_bytes = null;
		byte[] tmp_bytes = null;
		int cur_byte_cnt;
		try {
			FileInputStream file = new FileInputStream(fileName);
			n = file.read(readBytes, 0, 2000);
			cur_byte_cnt = 0;
			while (n > 0) {
				if (total_bytes == null) {
					total_bytes = new byte[n];
					for (i = 0; i < n; i++)
						total_bytes[i] = readBytes[i];
				} else {
					tmp_bytes = new byte[total_bytes.length];
					for (i = 0; i < total_bytes.length; i++)
						tmp_bytes[i] = total_bytes[i];

					total_bytes = null;
					total_bytes = new byte[tmp_bytes.length + n];
					for (i = 0; i < tmp_bytes.length; i++)
						total_bytes[i] = tmp_bytes[i];
					for (i = 0; i < n; i++)
						total_bytes[tmp_bytes.length + i] = readBytes[i];

					tmp_bytes = null;
				}

				n = file.read(readBytes, 0, 2000);
			}

			file.close();
		} catch (Exception e) {
			System.out.println("Exception in reading data from file: "
					+ e.getMessage());
			System.exit(1);
		}

		return total_bytes;
	}

}
