package org.ecoinformatics.ecogrid.client;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;

import org.ecoinformatics.ecogrid.registry.stub.RegistryEntryType;
import org.ecoinformatics.ecogrid.registry.util.RegistryEntryTypeParser;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Test Ecogrid Registry Service.
 * 
 * @author Tao
 */
public class RegistryServiceClientTest extends TestCase
{
    
	// class fields   
	private  String registryURL = "http://dev.nceas.ucsb.edu/registry/services/RegistryService";
	private  String authenURL  = "http://dev.nceas.ucsb.edu/knb/services/AuthenticationService";
	private  String sessionId     = "";
	private  String userName    = "uid=test,o=NCEAS,dc=ecoinformatics,dc=org";
	private  String password     = "test";
	private  RegistryServiceClient registryClient = null;
	private String docid;
    //Constants
	private final static String REGISTRYENTRYFILE = "tests/testfiles/service_registry_example.xml";
	private final static String ENDPOINT = "endPoint";
	private final static String NEWENDPOINT ="http://newendpoint.org";
	/**
     * Constructor to build the test
     *
     * @param name the name of the test method
     */
    public RegistryServiceClientTest(String name)
    {
        super(name);
      
    }
    
    /**
     * Create a suite of tests to be run together
     */
    public static Test suite()
    {
      TestSuite suite = new TestSuite();
      suite.addTest(new RegistryServiceClientTest("initialize"));
      suite.addTest(new RegistryServiceClientTest("insertTest"));
      suite.addTest(new RegistryServiceClientTest("queryTest"));
      suite.addTest(new RegistryServiceClientTest("listTest"));
      suite.addTest(new RegistryServiceClientTest("updateTest"));
      suite.addTest(new RegistryServiceClientTest("removeTest"));
       return suite;
   }
    
    /**
	 * Establish a testing framework by initializing appropriate objects
	 */
    protected void setUp() throws Exception
    {
        super.setUp();
        try {
              
        	AuthenticationServiceClient client = 
				new AuthenticationServiceClient(authenURL);
			sessionId = client.login_action(userName, password);
			assertFalse(sessionId.equals("an unknown error"));
			registryClient = new RegistryServiceClient(registryURL);
			insertEntry();
        } 
        catch (Exception e) 
        {
            fail(e.getMessage());
        }
    }
    
    /**
	 * Run an initial test that always passes to check that the test harness is
	 * working.
	 */
	public void initialize() {
		assertTrue(1 == 1);
	}
	
	/**
	 * Test insert method in registry client
	 */
	public void insertTest()
	{
		try
		{
			//insertEntry();
		    assertTrue("The response of add is not a docid starting with 'ecogridService'", docid.startsWith("ecogridService"));
	   }
	  catch (Exception e) 
      {
          fail(e.getMessage());
      }
	}
	
	/**
	 * Test insert method in registry client
	 */
	public void insertEntry()
	{
		try
		{
		    File entryFile = new File(REGISTRYENTRYFILE);
		    FileReader reader = new FileReader(entryFile);
		    RegistryEntryType entry = RegistryEntryTypeParser.parseXML(reader);
		    docid = registryClient.add(sessionId, entry);
		    System.out.println("Response of adding an entry is " + docid);
	   }
	  catch (Exception e) 
      {
          fail(e.getMessage());
      }
	}
	
	/**
	 * Test query method in registry client
	 */
	public void queryTest()
	{
		try
		{
			boolean found = false;
			String queryString = "http://nceas-macbook04.msi.ucsb.edu:8080/knb/services/QueryService";
			found = queryEndPoint(queryString);
			assertTrue("Not found the inserted document in query method", found);
		}
		catch (Exception e) 
	    {
	          fail(e.getMessage());
	     }
	}
	
	/**
	 * Test list method in registry client. List will list all entries in the server. Howerver
	 * We never know how many entries are in the server. We only test if the inserted server
	 * is the return list.
	 */
	public void listTest()
	{
		try
		{
			boolean found = false;
			String queryString = "http://nceas-macbook04.msi.ucsb.edu:8080/knb/services/QueryService";
			RegistryEntryType[] entries = registryClient.list(sessionId);
			int length = entries.length;
			for (int i=0; i<length; i++)
			{
				RegistryEntryType entry = entries[i];
				if (entry != null)
				{
					String id = entry.getId();
					// if there is a endpoint match, we found the document just insert.
					if (id != null && id.equals(docid))
					{
						found = true;
						break;
					}
				}
			}
			assertTrue("Not found the inserted document in list method", found);
		}
		catch (Exception e) 
	    {
	          fail(e.getMessage());
	     }
	}
	
	/**
	 * Test update method in registry client
	 *
	 */
	public void updateTest()
	{
       try
       {
    	    String queryField = "endPoint";
			String queryString = "http://nceas-macbook04.msi.ucsb.edu:8080/knb/services/QueryService";
    	    
    	    String foundDocid = null;
		    File entryFile = new File(REGISTRYENTRYFILE);
		    FileReader reader = new FileReader(entryFile);
		    RegistryEntryType newEntry = RegistryEntryTypeParser.parseXML(reader);
		    //modify the endpoint
		    newEntry.setEndPoint(NEWENDPOINT);
		    //get the docid.
		    RegistryEntryType[] entries = registryClient.query(sessionId, queryField, queryString);
			int length = entries.length;
			for (int i=0; i<length; i++)
			{
				RegistryEntryType entry = entries[i];
				if (entry != null)
				{
					foundDocid = entry.getId();
					// if there is a endpoint match, we found the document just insert.
					if (foundDocid != null && foundDocid.equals(docid))
					{
						break;
					}
				}
			}
			System.out.println("the docid before update is " + foundDocid);
			if (foundDocid != null)
			{
				foundDocid = removeVersionFromId(foundDocid);
				docid = foundDocid + ".2";
				String response = registryClient.update(sessionId, docid, newEntry);
				System.out.println("update response is "+response);
				assertTrue("No success tag in update reponse", response.indexOf("<success>")!= -1);
				boolean found = queryEndPoint(NEWENDPOINT);
				assertTrue("Not found the inserted document in list method", found);
			}
			else
			{
				fail("Couldn't find the old version document in server");
			}
       }
       catch (Exception e) 
	    {
	          fail(e.getMessage());
	     }
       
	}
	
	/**
	 * Test remove mthod in registry client
	 *
	 */
	public void removeTest()
	{
		try
		{
			String foundDocid = null;
			RegistryEntryType[] entries = registryClient.query(sessionId, ENDPOINT, NEWENDPOINT);
			int length = entries.length;
			for (int i=0; i<length; i++)
			{
				RegistryEntryType entry = entries[i];
				if (entry != null)
				{
					foundDocid = entry.getId();
					// if there is a endpoint match, we found the document just insert.
					if (foundDocid != null && foundDocid.equals(docid))
					{
						//docid = entry.getId();
						break;
					}
				}
			}
			System.out.println("the docid will be removed is " + foundDocid);
			String response = registryClient.remove(sessionId, foundDocid);
			System.out.println("the response of remove is " + response);
			assertTrue("remove reponse doesn't have success tag", response.indexOf("<success>") != -1);
		}
		catch(Exception e)
		{
			fail(e.getMessage());
		}
	}
	
	/*
	 * Remove version number from docid
	 */
	private String removeVersionFromId(String docid)
	{
		String docidWithoutVersion = null;
		if (docid != null)
		{
			int position = docid.lastIndexOf(".");
			
			docidWithoutVersion = docid.substring(0, position);
		}
		System.out.println("the docid with version is "+docidWithoutVersion);
		return docidWithoutVersion;
	}
	
	/*
	 * Query the server to find a registry entry which has a given end point 
	 */
	private boolean queryEndPoint(String queryString) throws Exception
	{	
			boolean found = false;
			RegistryEntryType[] entries = registryClient.query(sessionId,ENDPOINT , queryString);
			int length = entries.length;
			for (int i=0; i<length; i++)
			{
				RegistryEntryType entry = entries[i];
				if (entry != null)
				{
					String endPoint = entry.getEndPoint();
					// if there is a endpoint match, we found the document just insert.
					if (endPoint != null && endPoint.equals(queryString))
					{
						found = true;
					}
				}
			}
			return found;		
	}
}
