
/** CreateContourImage given a set of weather data creates the contour
 * plots using gnuplot image manipulation tool.            
 *
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.ROADnet;

import java.awt.Image;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ObjectToken;
import ptolemy.data.StringToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.data.expr.StringParameter;

//////////////////////////////////////////////////////////////////////////
//// CreateContourImages
/**
   Using gnuplot create contour plot from given weather data and save the 
   image.

   @author Nandita Mangal, Application Based on Todd Hansen's ROADNet
   Application
   @version $Id: CreateContourImages.java,v 1.1 2005/09/27 10:47:17 
   @category.name orb
   @category.name external execution
 */


public class CreateContourImages extends TypedAtomicActor {
    /**
     *  @param container The container.
     *  @param name The name of this actor.
     *  @exception IllegalActionException If the actor cannot be contained
     *   by the proposed container.
     *  @exception NameDuplicationException If the container already has an
     *   actor with this name.
     */
    public CreateContourImages(CompositeEntity container, String name)
	throws NameDuplicationException, IllegalActionException {
	
	super(container, name);

	//get a HashMap which consists of weather data.
	input =new TypedIOPort(this,"input",true,false);
	input.setMultiport(false);
	input.setTypeEquals(BaseType.OBJECT);

	//output a location of the saved contour Image.
	output = new TypedIOPort(this, "output", false, true);
	output.setMultiport(false);
	output.setTypeEquals(BaseType.STRING);  

      imageToolLocation = new StringParameter(this, "Plotting Tool Location");
      imageToolLocation.setExpression("C:/gnuplot/gnuplot4/bin/pgnuplot.exe");

	

    }
    ///////////////////////////////////////////////////////////////////
    ///               public methods                             ////
    
     /** Start up a new gnuplot process and feed commands into 
      * the sub process via its
      *  its input Stream. Get user selections for weather data 
      *  based on existing keys left in the Hash Map for data.
      *  Create contour plots based on those selections.
      *  
      *  @exception IllegalActionException
      */

    public void fire()  throws IllegalActionException
    {
	try{

	boolean plotHumidity = false;
	boolean plotTemperature =false;
	boolean plotPressure = false;
	boolean plotWind = false;
	

	// get the weather data (after it has passed through) user selection
	HashMap inputMatrices = (HashMap) ((ObjectToken)(input.get(0))).getValue();
	if(inputMatrices.containsKey("temperature"))
	    plotTemperature=true;
	if(inputMatrices.containsKey("pressure"))
	    plotPressure=true;
	if(inputMatrices.containsKey("humidity"))
	    plotHumidity=true;
	if(inputMatrices.containsKey("wind"))
	    plotWind=true;

	//start gnuplot
	Process p = Runtime.getRuntime().exec(imageToolLocation.stringValue());
	OutputStream outputStream = p.getOutputStream();
	PrintWriter printWriter=outputStream!=null?new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream))):null;
	
	//NOTE:- Temporary changes currently in affect due to transistion from ORB to SRB as 
	//well as changing currently implemented ORB source actors in Kepler.
	// cont_hum.dat is currently the source of data for humidity weather data.
	// cont_temp.dat is currently the source of data for temperature weather data.
	
	if(printWriter!=null)
          { 
		     
		     printWriter.println("reset\n");
                 printWriter.flush();
                 printWriter.println("cd \"lib\"");
                 printWriter.flush();
                 printWriter.println("cd \"testdata\"");
                 printWriter.flush();
                 printWriter.println("cd \"ROADnet\"");
		     printWriter.flush();
		     printWriter.println("set contour\n");
		     printWriter.flush();
		     printWriter.println("unset clabel");
		     printWriter.flush();
		     printWriter.println("unset surface\n");
		     printWriter.flush();
		     printWriter.println("set cntrparam levels inc 0,2,50\n");
		     printWriter.flush();
		     printWriter.println("set dgrid3d 50,50,10\n");
		     printWriter.flush();
		     printWriter.println("set view 140,91,1,1");
		     printWriter.flush();
		     printWriter.println("unset xzeroaxis");
		     printWriter.flush();
		     printWriter.println("unset yzeroaxis");
		     printWriter.flush();
		     printWriter.println("set xrange[32.4:33.6]");
		     printWriter.flush();
		     printWriter.println("set yrange[-118.4:-116.4]");
		     printWriter.flush();
		     printWriter.println("set term png transparent");
		     printWriter.flush();
		     printWriter.println("set output \"temp.png\"");
		     printWriter.flush();
		     printWriter.println("set multiplot");
		     printWriter.flush();
		     printWriter.println("splot \"WeatherSensors.dat\" with lines lt 3 lw 1.5");
		     printWriter.flush();
		     printWriter.println("unset multiplot");
		     printWriter.flush();
		     printWriter.println("exit");
		     printWriter.flush();		     
			     			     
	 }
	
	 Image img=null;
	 String imgFileName ="";
	 
	 //destroy gnuplot process after plot is saved.
	 p.destroy();
	
	 imgFileName = "C:/Project/kepler/lib/testdata/ROADnet/temp.png";
	   output.broadcast(new StringToken("http://angelfire.com/sd2/nmangal/abc.html"));
			
	  while(!((new File(imgFileName)).exists()))
	      {
		  //wait till file becomes available from gnuplot 
	      }
	  if( (new File(imgFileName)).exists())
	      {
		   
		//   output.broadcast(new AWTImageToken(Toolkit.getDefaultToolkit().createImage(imgFileName)));
                
		      
	      }
        else
		  output.broadcast(new StringToken("http://angelfire.com/sd2/nmangal/abc.html"));
  
	//   output.brodcast(new ObjectToken(null));

	}catch(Exception e) { // if eihter process failed/or simply gnuplot not available.
         //error message, old google maps data shown
        output.broadcast(new StringToken("http://angelfire.com/sd2/nmangal/abc.html"));
        }

    }

    ////////////////////////////////////////////////////////////////
    /////              public ports                          //////
   
    /* output the location of contour image just created via gnuplot*/
    public TypedIOPort output;
    
    /* hashMap of the weather data */
    public TypedIOPort input;

    /*location of image tool*/
    public StringParameter imageToolLocation;
  
   
}
