package org.cipres.kepler;
/* ClustalWOutputAdapter actor reads the Nexus file generated by ClustalW
 * and fix the line of symbols. After this fixing, the Nexus format could 
 * be accepted by most of the phylogeny softwares.

Copyright (c) 1998-2003 The Regents of the University of California.
All rights reserved.
Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.

                                       PT_COPYRIGHT_VERSION_2
                                       COPYRIGHTENDKEY
*/


import ptolemy.actor.TypedAtomicActor;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.*;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.StringToken;
import ptolemy.data.type.BaseType;
import ptolemy.data.expr.Parameter;

import org.cipres.util.file.cipresFile;

import java.io.File;


//////////////////////////////////////////////////////////////////////////
////ClustalWOutputAdapter
/**
* This is the implementation of the ClustalWOutputAdapter actor using Kepler.
* This actor reads and fixes the ClustalW output.
* 
* @author Alex Borchers, Zhijie Guan  
* borchers@sdsc.edu, guan@sdsc.edu
*/

public class ClustalWOutputAdapter extends TypedAtomicActor {

	/** Construct ClustalWOutputAdapter source with the given container and name.
    *  @param name The name of this actor.
    *  @exception IllegalActionException If the entity cannot be contained
    *   by the proposed container.
    *  @exception NameDuplicationException If the container already has an
    *   actor with this name.
    */
	
   public ClustalWOutputAdapter(CompositeEntity container, String name)
           throws NameDuplicationException, IllegalActionException  {
	   super(container, name);
       
	   inputNexusFile = new TypedIOPort(this, "ClustalW's output Nexus", true, false);
	   inputNexusFile.setTypeEquals(BaseType.STRING);
		
	   outputNexusFile = new TypedIOPort(this, "Fixed Nexus File", false, true);
       // Set the type constraint.
       outputNexusFile.setTypeEquals(BaseType.STRING);

       fileClustalNexusOutputPar = new Parameter(this, "Clustal Output Nexus File Name", new StringToken(""));
       
       _attachText("_iconDescription", "<svg>\n" +
               "<rect x=\"0\" y=\"0\" "
               + "width=\"60\" height=\"20\" "
               + "style=\"fill:white\"/>\n" +
               "</svg>\n");
		
   }

   ///////////////////////////////////////////////////////////////////
   ////                     ports and parameters                  ////

   /** The input/output file port.  The type of this port will be set to String.
    *  The data transferred through these ports are file names.
    */
	public TypedIOPort inputNexusFile = null;
	public TypedIOPort outputNexusFile = null;
	
	/** The file name parameter, which defines the default output file name.
	 */
    public Parameter fileClustalNexusOutputPar;
	
	///////////////////////////////////////////////////////////////////
	////                    functional variables                   ////
	
   ///////////////////////////////////////////////////////////////////
   ////                         public methods                    ////

   /** Read and parse the Nexus data.
    *  @exception IllegalActionException If it is thrown by the
    *   send() method sending out the token.
    */
   public void fire() throws IllegalActionException {
       super.fire();
		
		if (inputNexusFile.hasToken(0)) {	
			File inFile = new File( ((StringToken)inputNexusFile.get(0)).stringValue() );
			try {
				cipresFile cfIn = new cipresFile(inFile.getAbsolutePath());
				cipresFile cfOut = new cipresFile(((StringToken)fileClustalNexusOutputPar.getToken()).stringValue());
				String content = cfIn.getContent();
				//find beginnning of symbols statement
				int pos1 = content.toLowerCase().indexOf("symbols");
				//find end of symbols statement (will be the 2nd quotation mark after "symbols")
				int pos2 = content.indexOf("\"", pos1);
				pos2 = content.indexOf("\"", pos2+1);
				String symbolsString  = content.substring(pos1, pos2);
				cfOut.fillFromString(content.substring(0,pos1) + 
						content.substring(pos1 + symbolsString.length() + 1, content.length()));
				// generate the output file name tokens
				outputNexusFile.send(0, new StringToken(cfOut.getAbsolutePath()));
			} catch (Exception ex) {
				System.out.println("Exception on fixing ClustalW's output Nexus file: ");
				ex.printStackTrace();
			}
			
		}
		
   }

}
