/**
 *    '$RCSfile: CancelSearchAction.java,v $'
 *
 *     '$Author: ruland $'
 *       '$Date: 2005/11/01 20:39:05 $'
 *   '$Revision: 1.2 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.seek.ecogrid;

import java.awt.Window;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

/**
 * This will destory a current window and shown the parent frame
 * @author Jing Tao
 *  
 */

public class CancelSearchAction extends AbstractAction 
{ 
  private Window current = null;
  private ServicesDisplayFrame parent = null;
  
  /**
   * Constructor
   * @param name String
   * @param searchDialog JDialog
   * @param parent ServicesDisplayFrame
   */
  public CancelSearchAction(String name, Window current, ServicesDisplayFrame parent) 
  {
    super(name);
    this.current = current;
    this.parent       = parent;
  }//CancelSearchAction
  
  /**
   * Method to perform action
   * @param e ActionEvent
   */
  public void actionPerformed(ActionEvent e) 
  {
    current.setVisible(false);
    current.dispose();
    current = null;
    parent.setVisible(true);
  }//actionPerformed

}//CancelSearchAction