/**
 *    '$RCSfile: SelectableServiceName.java,v $'
 *
 *     '$Author: tao $'
 *       '$Date: 2005/06/08 00:51:03 $'
 *   '$Revision: 1.1 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2003 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */


package org.ecoinformatics.seek.ecogrid;

/**
 * This class represents a selected service name in table
 * @author Jing Tao
 *  
 */

public class SelectableServiceName implements SelectableObjectInterface 
{
  private String serviceName   = null;
  private boolean isSelected   = SelectableObjectInterface.DEFAULTSELECTIONSTATUS;
  private boolean isEnable     = SelectableObjectInterface.ENABLE;
  
  /**
   * Default constructor
   */
  public SelectableServiceName() 
  {
  }//SelectedServiceName
  
  /**
   * Method to getServiceName
   * @return String
   */
  public String getServiceName()
  {
    return this.serviceName;
  }//getServiceName
  
  /**
   * Method to set serviceName
   * @param seviceName String
   */
  public void setServiceName(String serviceName)
  {
    this.serviceName = serviceName;
  }//setServiceName
  
  /**
   * Method to get selected status
   * @return boolean
   */
  public boolean getIsSelected()
  {
    return this.isSelected;
  }//getSelected
  
  /**
   * Method to set selected status
   */
  public void setIsSelected(boolean isSelected)
  {
    this.isSelected = isSelected;
  }//setIsSelected
  
  /**
   * Method from SelectedObject interface. In this case will return serive name
   * @return String
   */
  public String getSelectableObjectLabel()
  {
    return this.serviceName;
  }
  
  /**
   * Method to get icon enable status
   * @return boolean
   */
  public boolean getEnabled()
  {
    return this.isEnable;
  }
  
  /**
   * Method to set icon enable status
   * @param isEnable boolean
   */
  public void setEnabled(boolean isEnable)
  {
    this.isEnable = isEnable;
  }
}//SelectedServiceName